/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.builders;

import java.util.Map;
import org.mule.MuleManager;
import org.mule.config.ConfigurationBuilder;
import org.mule.config.ConfigurationException;
import org.mule.config.ReaderResource;
import org.mule.config.i18n.Message;
import org.mule.impl.MuleDescriptor;
import org.mule.impl.MuleModel;
import org.mule.impl.endpoint.MuleEndpoint;
import org.mule.impl.endpoint.MuleEndpointURI;
import org.mule.providers.service.ConnectorFactory;
import org.mule.umo.UMOComponent;
import org.mule.umo.UMODescriptor;
import org.mule.umo.UMOException;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.endpoint.UMOEndpointURI;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.manager.UMOContainerContext;
import org.mule.umo.manager.UMOManager;
import org.mule.umo.provider.UMOConnector;

public class QuickConfigurationBuilder
implements ConfigurationBuilder {
    private UMOManager manager;

    public QuickConfigurationBuilder() {
        this.manager = MuleManager.getInstance();
    }

    public QuickConfigurationBuilder(boolean disposeCurrent) throws UMOException {
        if (disposeCurrent) {
            this.disposeCurrent();
        }
        this.manager = MuleManager.getInstance();
    }

    public void disposeCurrent() throws UMOException {
        if (MuleManager.isInstanciated()) {
            MuleManager.getInstance().dispose();
        }
    }

    public UMOManager createStartedManager(boolean synchronous, String serverUrl) throws UMOException {
        if (this.manager.isStarted()) {
            throw new InitialisationException(new Message(88), (Object)this);
        }
        if (serverUrl == null) {
            serverUrl = "";
        }
        MuleManager.getConfiguration().setServerUrl(serverUrl);
        MuleManager.getConfiguration().setSynchronous(synchronous);
        this.manager.setModel(new MuleModel());
        this.manager.start();
        return this.manager;
    }

    public UMOManager createStartedManager(boolean synchronous, String serverUrl, UMOConnector serverConnector) throws UMOException {
        int param;
        if (serverConnector != null) {
            this.manager.registerConnector(serverConnector);
        }
        serverUrl = (param = serverUrl.indexOf("?")) == -1 ? serverUrl + "?" : serverUrl + "&";
        serverUrl = serverUrl + "createConnector=" + serverConnector.getName();
        return this.createStartedManager(synchronous, serverUrl);
    }

    public UMODescriptor registerComponentInstance(Object component, String name, UMOEndpointURI listenerEndpointUri) throws UMOException {
        return this.registerComponentInstance(component, name, listenerEndpointUri, null);
    }

    public UMODescriptor registerComponentInstance(Object component, String name, UMOEndpointURI listenerEndpointUri, UMOEndpointURI sendEndpointUri) throws UMOException {
        MuleDescriptor descriptor = new MuleDescriptor();
        descriptor.setImplementationInstance(component);
        descriptor.setName(name);
        UMOEndpoint inboundProvider = null;
        UMOEndpoint outboundProvider = null;
        if (listenerEndpointUri != null) {
            inboundProvider = ConnectorFactory.createEndpoint(listenerEndpointUri, "receiver");
        }
        if (sendEndpointUri != null) {
            outboundProvider = ConnectorFactory.createEndpoint(sendEndpointUri, "sender");
        }
        descriptor.setInboundEndpoint(inboundProvider);
        descriptor.setOutboundEndpoint(outboundProvider);
        this.manager.getModel().registerComponent(descriptor);
        return descriptor;
    }

    public UMOComponent registerComponent(String implementation, String name, String inboundEndpoint, String outboundEndpoint, Map properties) throws UMOException {
        UMOEndpoint inEndpoint = null;
        UMOEndpoint outEndpoint = null;
        if (inboundEndpoint != null && (inEndpoint = this.manager.lookupEndpoint(inboundEndpoint)) == null) {
            inEndpoint = this.createEndpoint(inboundEndpoint, null, true);
        }
        if (outboundEndpoint != null && (outEndpoint = this.manager.lookupEndpoint(outboundEndpoint)) == null) {
            outEndpoint = this.createEndpoint(outboundEndpoint, null, false);
        }
        UMODescriptor d = this.createDescriptor(implementation, name, inEndpoint, outEndpoint, properties);
        return this.registerComponent(d);
    }

    public UMOComponent registerComponent(UMODescriptor descriptor) throws UMOException {
        return this.manager.getModel().registerComponent(descriptor);
    }

    public UMOComponent registerComponent(String implementation, String name, UMOEndpointURI inboundEndpointUri) throws UMOException {
        return this.registerComponent(implementation, name, inboundEndpointUri, null, null);
    }

    public UMOComponent registerComponent(String implementation, String name, UMOEndpointURI inboundEndpointUri, Map properties) throws UMOException {
        return this.registerComponent(implementation, name, inboundEndpointUri, null, properties);
    }

    public UMOComponent registerComponent(String implementation, String name, UMOEndpointURI inboundEndpointUri, UMOEndpointURI outboundEndpointUri) throws UMOException {
        return this.registerComponent(implementation, name, inboundEndpointUri, outboundEndpointUri, null);
    }

    public UMOComponent registerComponent(String implementation, String name, UMOEndpointURI inboundEndpointUri, UMOEndpointURI outboundEndpointUri, Map properties) throws UMOException {
        UMODescriptor d = this.createDescriptor(implementation, name, inboundEndpointUri, outboundEndpointUri, properties);
        return this.manager.getModel().registerComponent(d);
    }

    public UMODescriptor createDescriptor(String implementation, String name, String inboundEndpointUri, String outboundEndpointUri, Map properties) throws UMOException {
        MuleEndpointURI inEndpointUri = null;
        MuleEndpointURI outEndpointUri = null;
        if (inboundEndpointUri != null) {
            inEndpointUri = new MuleEndpointURI(inboundEndpointUri);
        }
        if (outboundEndpointUri != null) {
            outEndpointUri = new MuleEndpointURI(outboundEndpointUri);
        }
        return this.createDescriptor(implementation, name, inEndpointUri, outEndpointUri, properties);
    }

    public UMODescriptor createDescriptor(String implementation, String name, UMOEndpointURI inboundEndpointUri, UMOEndpointURI outboundEndpointUri, Map properties) throws UMOException {
        UMOEndpoint inboundEndpoint = null;
        UMOEndpoint outboundEndpoint = null;
        if (inboundEndpointUri != null) {
            inboundEndpoint = ConnectorFactory.createEndpoint(inboundEndpointUri, "receiver");
        }
        if (outboundEndpointUri != null) {
            outboundEndpoint = ConnectorFactory.createEndpoint(outboundEndpointUri, "sender");
        }
        return this.createDescriptor(implementation, name, inboundEndpoint, outboundEndpoint, properties);
    }

    public UMODescriptor createDescriptor(String implementation, String name, UMOEndpoint inboundEndpoint, UMOEndpoint outboundEndpoint, Map properties) throws UMOException {
        MuleDescriptor descriptor = new MuleDescriptor();
        descriptor.setImplementation(implementation);
        descriptor.setName(name);
        if (properties != null) {
            descriptor.getProperties().putAll(properties);
        }
        descriptor.setInboundEndpoint(inboundEndpoint);
        descriptor.setOutboundEndpoint(outboundEndpoint);
        return descriptor;
    }

    public void setContainerContext(UMOContainerContext ctx) throws UMOException {
        this.manager.setContainerContext(ctx);
    }

    public void unregisterComponent(String name) throws UMOException {
        UMODescriptor descriptor = this.manager.getModel().getDescriptor(name);
        if (descriptor != null) {
            this.manager.getModel().unregisterComponent(descriptor);
        }
    }

    public UMOEndpoint createEndpoint(String uri, String name, boolean inbound) throws UMOException {
        UMOEndpoint ep = MuleEndpoint.createEndpointFromUri(new MuleEndpointURI(uri), inbound ? "receiver" : "sender");
        ep.setName(name);
        return ep;
    }

    public UMOEndpoint registerEndpoint(String uri, String name, boolean inbound) throws UMOException {
        UMOEndpoint ep = this.createEndpoint(uri, name, inbound);
        ep.initialise();
        this.manager.registerEndpoint(ep);
        return ep;
    }

    public UMOEndpoint registerEndpoint(String uri, String name, boolean inbound, Map properties) throws UMOException {
        UMOEndpoint ep = this.createEndpoint(uri, name, inbound);
        ep.getProperties().putAll(properties);
        ep.initialise();
        this.manager.registerEndpoint(ep);
        return ep;
    }

    public UMOManager configure(String configResources) throws ConfigurationException {
        return this.manager;
    }

    public UMOManager configure(ReaderResource[] configResources) throws ConfigurationException {
        return this.manager;
    }

    public boolean isConfigured() {
        return this.manager != null;
    }
}

