/*
 * Decompiled with CFR 0.152.
 */
package org.mule.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.resource.spi.work.Work;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.MuleManager;
import org.mule.config.i18n.Message;
import org.mule.impl.ImmutableMuleDescriptor;
import org.mule.impl.InterceptorsInvoker;
import org.mule.impl.MuleComponent;
import org.mule.impl.MuleDescriptor;
import org.mule.impl.MuleEvent;
import org.mule.impl.MuleMessage;
import org.mule.impl.RequestContext;
import org.mule.impl.endpoint.MuleEndpoint;
import org.mule.impl.endpoint.MuleEndpointURI;
import org.mule.management.stats.ComponentStatistics;
import org.mule.providers.AbstractConnector;
import org.mule.providers.ReplyToHandler;
import org.mule.umo.MessagingException;
import org.mule.umo.UMOEvent;
import org.mule.umo.UMOException;
import org.mule.umo.UMOImmutableDescriptor;
import org.mule.umo.UMOInterceptor;
import org.mule.umo.UMOMessage;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.lifecycle.Disposable;
import org.mule.umo.lifecycle.Initialisable;
import org.mule.umo.lifecycle.Lifecycle;
import org.mule.umo.lifecycle.UMOLifecycleAdapter;
import org.mule.umo.model.ModelException;
import org.mule.umo.model.UMOEntryPointResolver;
import org.mule.umo.model.UMOModel;
import org.mule.umo.provider.UMOMessageDispatcher;
import org.mule.umo.transformer.TransformerException;
import org.mule.umo.transformer.UMOTransformer;
import org.mule.util.ObjectPool;
import org.mule.util.queue.QueueSession;

public class MuleProxy
implements Work,
Lifecycle {
    private static transient Log logger = LogFactory.getLog((Class)(class$org$mule$impl$MuleProxy == null ? (class$org$mule$impl$MuleProxy = MuleProxy.class$("org.mule.impl.MuleProxy")) : class$org$mule$impl$MuleProxy));
    private UMOEvent event;
    private UMOLifecycleAdapter umo;
    private ImmutableMuleDescriptor descriptor;
    private boolean suspended = true;
    private List interceptorList;
    private ObjectPool proxyPool;
    private ComponentStatistics stat = null;
    private QueueSession queueSession = null;
    static /* synthetic */ Class class$org$mule$impl$MuleProxy;

    public MuleProxy(Object component, MuleDescriptor descriptor, ObjectPool proxyPool) throws UMOException {
        this.descriptor = new ImmutableMuleDescriptor(descriptor);
        this.proxyPool = proxyPool;
        UMOModel model = MuleManager.getInstance().getModel();
        UMOEntryPointResolver resolver = model.getEntryPointResolver();
        this.umo = model.getLifecycleAdapterFactory().create(component, descriptor, resolver);
        this.interceptorList = new ArrayList(descriptor.getInterceptors().size() + 1);
        this.interceptorList.addAll(descriptor.getInterceptors());
        this.interceptorList.add(this.umo);
        Iterator iter = this.interceptorList.iterator();
        while (iter.hasNext()) {
            UMOInterceptor interceptor = (UMOInterceptor)iter.next();
            if (!(interceptor instanceof Initialisable)) continue;
            try {
                ((Initialisable)((Object)interceptor)).initialise();
            }
            catch (Exception e) {
                throw new ModelException(new Message(40, "Component '" + descriptor.getName() + "'"), (Throwable)e);
            }
        }
    }

    public void start() throws UMOException {
        this.checkDisposed();
        if (!this.umo.isStarted()) {
            try {
                this.umo.start();
            }
            catch (Exception e) {
                throw new ModelException(new Message(42, "Component '" + this.descriptor.getName() + "'"), (Throwable)e);
            }
        }
    }

    public boolean isStarted() {
        return this.umo.isStarted();
    }

    public void stop() throws UMOException {
        this.checkDisposed();
        if (this.umo.isStarted()) {
            try {
                this.umo.stop();
            }
            catch (Exception e) {
                throw new ModelException(new Message(41, "Component '" + this.descriptor.getName() + "'"), (Throwable)e);
            }
        }
    }

    public void dispose() {
        this.checkDisposed();
        Iterator iter = this.interceptorList.iterator();
        while (iter.hasNext()) {
            UMOInterceptor interceptor = (UMOInterceptor)iter.next();
            if (!(interceptor instanceof Disposable)) continue;
            try {
                ((Disposable)((Object)interceptor)).dispose();
            }
            catch (Exception e) {
                logger.error((Object)new Message(67, "Component '" + this.descriptor.getName() + "'"), (Throwable)e);
            }
        }
    }

    private void checkDisposed() {
        if (this.umo.isDisposed()) {
            throw new IllegalStateException("Components Disposed Of");
        }
    }

    public void onEvent(QueueSession session, UMOEvent event) {
        this.queueSession = session;
        this.event = (MuleEvent)event;
    }

    public ComponentStatistics getStatistics() {
        return this.stat;
    }

    public void setStatistics(ComponentStatistics stat) {
        this.stat = stat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object onCall(UMOEvent event) throws UMOException {
        logger.trace((Object)("MuleProxy: sync call for Mule UMO " + this.descriptor.getName()));
        UMOMessage returnMessage = null;
        try {
            if (event.getEndpoint().canReceive()) {
                String requestor;
                RequestContext.setEvent(event);
                Object replyTo = event.getMessage().getReplyTo();
                ReplyToHandler replyToHandler = null;
                if (replyTo != null) {
                    replyToHandler = ((AbstractConnector)event.getEndpoint().getConnector()).getReplyToHandler();
                }
                InterceptorsInvoker invoker = new InterceptorsInvoker(this.interceptorList, this.descriptor, event.getMessage());
                long startTime = 0L;
                if (this.stat.isEnabled()) {
                    startTime = System.currentTimeMillis();
                }
                returnMessage = invoker.execute();
                if (this.stat.isEnabled()) {
                    this.stat.addExecutionTime(System.currentTimeMillis() - startTime);
                }
                if ((event = RequestContext.getEvent()).isStopFurtherProcessing()) {
                    logger.debug((Object)"Event stop further processing has been set, no outbound routing will be performed.");
                }
                if (returnMessage != null && !event.isStopFurtherProcessing()) {
                    Map context = RequestContext.clearProperties();
                    if (context != null) {
                        returnMessage.addProperties(context);
                    }
                    if (this.descriptor.getOutboundRouter().hasEndpoints()) {
                        UMOMessage outboundReturnMessage = this.descriptor.getOutboundRouter().route(returnMessage, event.getSession(), event.isSynchronous());
                        if (outboundReturnMessage != null) {
                            returnMessage = outboundReturnMessage;
                        }
                    } else {
                        logger.debug((Object)("Outbound router on component '" + this.descriptor.getName() + "' doesn't have any endpoints configured."));
                    }
                }
                if (returnMessage != null && this.descriptor.getResponseRouter() != null) {
                    logger.debug((Object)"Waiting for response router message");
                    returnMessage = this.descriptor.getResponseRouter().getResponse(returnMessage);
                }
                if (returnMessage != null && replyToHandler != null && ((requestor = (String)returnMessage.getProperty("MULE_REPLYTO_REQUESTOR")) != null && !requestor.equals(this.descriptor.getName()) || requestor == null)) {
                    replyToHandler.processReplyTo(event, returnMessage, replyTo);
                }
            } else {
                returnMessage = event.getSession().sendEvent(event);
                this.processReplyTo(returnMessage);
            }
            if (this.stat.isEnabled()) {
                this.stat.incSentEventSync();
            }
        }
        catch (Exception e) {
            event.getSession().setValid(false);
            if (e instanceof UMOException) {
                this.handleException(e);
            } else {
                this.handleException(new MessagingException(new Message(127, this.descriptor.getName()), event.getMessage(), (Throwable)e));
            }
        }
        finally {
            if (event.getComponent() != null) {
                ((MuleComponent)event.getComponent()).finaliseEvent(event);
            }
        }
        return this.applyResponseTransformer(returnMessage);
    }

    public void handleException(Exception exception) {
        this.descriptor.getExceptionListener().exceptionThrown(exception);
    }

    public String toString() {
        return "proxy for: " + this.descriptor.toString();
    }

    public boolean isSuspended() {
        return this.suspended;
    }

    public void suspend() {
        this.suspended = true;
    }

    public void resume() {
        this.suspended = false;
    }

    private void processReplyTo(UMOMessage returnMessage) throws UMOException {
        if (returnMessage != null && returnMessage.getReplyTo() != null) {
            logger.info((Object)("sending reply to: " + returnMessage.getReplyTo()));
            MuleEndpointURI endpointUri = new MuleEndpointURI(returnMessage.getReplyTo().toString());
            UMOEndpoint endpoint = MuleEndpoint.getOrCreateEndpointForUri(endpointUri, "sender");
            MuleEvent replyToEvent = new MuleEvent(returnMessage, endpoint, this.event.getSession(), false);
            replyToEvent.removeProperty("MULE_REPLYTO");
            this.onEvent(this.queueSession, replyToEvent);
            logger.info((Object)("reply to sent: " + returnMessage.getReplyTo()));
            if (this.stat.isEnabled()) {
                this.stat.incSentReplyToEvent();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        logger.trace((Object)("MuleProxy: async onEvent for Mule UMO " + this.descriptor.getName()));
        try {
            if (this.event.getEndpoint().canReceive()) {
                String requestor;
                RequestContext.setEvent(this.event);
                Object replyTo = this.event.getMessage().getReplyTo();
                ReplyToHandler replyToHandler = null;
                if (replyTo != null) {
                    replyToHandler = ((AbstractConnector)this.event.getEndpoint().getConnector()).getReplyToHandler();
                }
                InterceptorsInvoker invoker = new InterceptorsInvoker(this.interceptorList, this.descriptor, this.event.getMessage());
                long startTime = 0L;
                if (this.stat.isEnabled()) {
                    startTime = System.currentTimeMillis();
                }
                UMOMessage result = invoker.execute();
                if (this.stat.isEnabled()) {
                    this.stat.addExecutionTime(System.currentTimeMillis() - startTime);
                }
                this.event = (MuleEvent)RequestContext.getEvent();
                if (result != null && !this.event.isStopFurtherProcessing()) {
                    this.descriptor.getOutboundRouter().route(result, this.event.getSession(), this.event.isSynchronous());
                }
                if (result != null && replyToHandler != null && ((requestor = (String)result.getProperty("MULE_REPLYTO_REQUESTOR")) != null && !requestor.equals(this.descriptor.getName()) || requestor == null)) {
                    replyToHandler.processReplyTo(this.event, result, replyTo);
                }
            } else {
                UMOMessageDispatcher dispatcher = this.event.getEndpoint().getConnector().getDispatcher(this.event.getEndpoint().getEndpointURI().getAddress());
                dispatcher.dispatch(this.event);
            }
            ((MuleComponent)this.event.getComponent()).finaliseEvent(this.event);
            if (this.stat.isEnabled()) {
                this.stat.incSentEventASync();
            }
        }
        catch (Exception e) {
            ((MuleComponent)this.event.getComponent()).finaliseEvent(this.event);
            this.event.getSession().setValid(false);
            if (e instanceof UMOException) {
                this.handleException(e);
            } else {
                this.handleException(new MessagingException(new Message(127, this.descriptor.getName()), this.event.getMessage(), (Throwable)e));
            }
        }
        finally {
            try {
                this.proxyPool.returnObject(this);
            }
            catch (Exception e2) {
                logger.error((Object)("Failed to return proxy: " + e2.getMessage()), (Throwable)e2);
            }
            this.getStatistics().setComponentPoolSize(this.proxyPool.getSize());
        }
    }

    public void release() {
    }

    public UMOImmutableDescriptor getDescriptor() {
        return this.descriptor;
    }

    protected UMOMessage applyResponseTransformer(UMOMessage returnMessage) throws TransformerException {
        if (returnMessage == null) {
            return null;
        }
        UMOTransformer trans = this.descriptor.getResponseTransformer();
        if (trans == null && this.descriptor.getResponseRouter() != null) {
            trans = this.descriptor.getResponseRouter().getTransformer();
        }
        if (trans != null) {
            if (trans.isSourceTypeSupported(returnMessage.getPayload().getClass())) {
                Object result = trans.transform(returnMessage.getPayload());
                returnMessage = result instanceof UMOMessage ? (UMOMessage)result : new MuleMessage(result, returnMessage.getProperties());
            } else if (logger.isDebugEnabled()) {
                logger.debug((Object)("Response transformer: " + trans + " doesn't support the result payload: " + returnMessage.getPayload().getClass()));
            }
        }
        return returnMessage;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

