/*
 * Decompiled with CFR 0.152.
 */
package org.mule.impl.security;

import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.config.i18n.Message;
import org.mule.umo.UMOEncryptionStrategy;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.security.CryptoFailureException;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class PasswordBasedEncryptionStrategy
implements UMOEncryptionStrategy {
    protected static transient Log logger = LogFactory.getLog((Class)(class$org$mule$impl$security$PasswordBasedEncryptionStrategy == null ? (class$org$mule$impl$security$PasswordBasedEncryptionStrategy = PasswordBasedEncryptionStrategy.class$("org.mule.impl.security.PasswordBasedEncryptionStrategy")) : class$org$mule$impl$security$PasswordBasedEncryptionStrategy));
    private PBEKeySpec pbeKeySpec;
    private PBEParameterSpec pbeParamSpec;
    private SecretKeyFactory keyFac;
    private SecretKey pbeKey;
    private Cipher encryptCipher;
    private Cipher decryptCipher;
    private String algorithm = "PBEWithMD5AndDES";
    private byte[] salt = null;
    private int iterationCount = 20;
    private char[] password;
    private boolean base64Encoding = true;
    static /* synthetic */ Class class$org$mule$impl$security$PasswordBasedEncryptionStrategy;

    public void initialise() throws InitialisationException {
        if (this.algorithm == null) {
            throw new InitialisationException(new Message(45, "PBE Algorithm"), (Object)this);
        }
        logger.debug((Object)("Using encryption algorithm: " + this.algorithm));
        if (this.salt == null) {
            this.salt = new byte[]{-57, 115, 33, -116, 126, -56, -18, -103};
            logger.debug((Object)"Salt is not set. Using default salt");
        }
        if (this.password == null) {
            throw new InitialisationException(new Message(45, "Password"), (Object)this);
        }
        this.pbeParamSpec = new PBEParameterSpec(this.salt, this.iterationCount);
        this.pbeKeySpec = new PBEKeySpec(this.password);
        try {
            this.keyFac = SecretKeyFactory.getInstance(this.getAlgorithm());
            this.pbeKey = this.keyFac.generateSecret(this.pbeKeySpec);
            this.encryptCipher = Cipher.getInstance(this.getAlgorithm());
            this.encryptCipher.init(1, (Key)this.pbeKey, this.pbeParamSpec);
            this.decryptCipher = Cipher.getInstance(this.getAlgorithm());
            this.decryptCipher.init(2, (Key)this.pbeKey, this.pbeParamSpec);
        }
        catch (Exception e) {
            throw new InitialisationException(new Message(65, "PBE encryption ciphers"), e, this);
        }
    }

    public byte[] encrypt(byte[] data, Object info) throws CryptoFailureException {
        try {
            byte[] buf = this.encryptCipher.doFinal(data);
            if (this.base64Encoding) {
                return new BASE64Encoder().encode(buf).getBytes();
            }
            return buf;
        }
        catch (Exception e) {
            throw new CryptoFailureException(this, (Throwable)e);
        }
    }

    public byte[] decrypt(byte[] data, Object info) throws CryptoFailureException {
        try {
            byte[] dec = data;
            if (this.base64Encoding) {
                dec = new BASE64Decoder().decodeBuffer(new String(data));
            }
            return this.decryptCipher.doFinal(dec);
        }
        catch (Exception e) {
            throw new CryptoFailureException(this, (Throwable)e);
        }
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    public byte[] getSalt() {
        return this.salt;
    }

    public void setSalt(byte[] salt) {
        this.salt = salt;
    }

    public void setSalt(String salt) {
        this.salt = salt.getBytes();
    }

    public int getIterationCount() {
        return this.iterationCount;
    }

    public void setIterationCount(int iterationCount) {
        this.iterationCount = iterationCount;
    }

    public char[] getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password.toCharArray();
    }

    public void setPassword(char[] password) {
        this.password = password;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("Algorithm=").append(this.algorithm);
        return buf.toString();
    }

    public boolean isBase64Encoding() {
        return this.base64Encoding;
    }

    public void setBase64Encoding(boolean base64Encoding) {
        this.base64Encoding = base64Encoding;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

