/*
 * Decompiled with CFR 0.152.
 */
package org.mule.impl.work;

import EDU.oswego.cs.dl.util.concurrent.Channel;
import EDU.oswego.cs.dl.util.concurrent.PooledExecutor;
import org.mule.config.ThreadingProfile;
import org.mule.impl.work.NullWorkExecutorPool;
import org.mule.impl.work.WorkExecutorPool;

public class WorkExecutorPoolImpl
implements WorkExecutorPool {
    private PooledExecutor pooledExecutor;
    private ThreadingProfile profile;
    private String name;
    private static final long SHUTDOWN_TIMEOUT = 5000L;

    public WorkExecutorPoolImpl(ThreadingProfile profile, String name) {
        this.profile = profile;
        this.name = name;
        this.pooledExecutor = profile.createPool(name);
    }

    public WorkExecutorPoolImpl(Channel channel, int maxSize) {
        this.pooledExecutor = new PooledExecutor(channel, maxSize);
        this.pooledExecutor.setMinimumPoolSize(maxSize);
        this.pooledExecutor.waitWhenBlocked();
    }

    public void execute(Runnable work) throws InterruptedException {
        this.pooledExecutor.execute(work);
    }

    public int getPoolSize() {
        return this.pooledExecutor.getPoolSize();
    }

    public int getMaximumPoolSize() {
        return this.pooledExecutor.getMaximumPoolSize();
    }

    public void setMaximumPoolSize(int maxSize) {
        this.pooledExecutor.setMaximumPoolSize(maxSize);
    }

    public WorkExecutorPool start() {
        throw new IllegalStateException("This pooled executor is already started");
    }

    public WorkExecutorPool stop() {
        this.pooledExecutor.shutdownNow();
        try {
            this.pooledExecutor.awaitTerminationAfterShutdown(5000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return new NullWorkExecutorPool(this.profile, this.name);
    }
}

