/*
 * Decompiled with CFR 0.152.
 */
package org.mule.management.agents;

import java.net.URI;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import mx4j.log.CommonsLogger;
import mx4j.log.Log;
import mx4j.log.Logger;
import mx4j.tools.adaptor.http.HttpAdaptor;
import mx4j.tools.adaptor.http.ProcessorMBean;
import mx4j.tools.adaptor.http.XSLTProcessor;
import org.mule.config.i18n.Message;
import org.mule.management.agents.JmxManagementException;
import org.mule.umo.UMOException;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.manager.UMOAgent;

public class Mx4jAgent
implements UMOAgent {
    private String name;
    private String jmxAdaptorUrl = "http://localhost:9999";
    private Object adaptor;
    private MBeanServer mBeanServer;
    private ObjectName adaptorName;

    protected Object createAdaptor() throws Exception {
        HttpAdaptor adaptor = null;
        Log.redirectTo((Logger)new CommonsLogger());
        URI uri = new URI(this.jmxAdaptorUrl);
        adaptor = new HttpAdaptor(uri.getPort(), uri.getHost());
        adaptor.setProcessor((ProcessorMBean)new XSLTProcessor());
        return adaptor;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return "MX4J Http adaptor: " + this.jmxAdaptorUrl;
    }

    public void start() throws UMOException {
        try {
            this.mBeanServer.invoke(this.adaptorName, "start", null, null);
        }
        catch (InstanceNotFoundException e) {
            throw new JmxManagementException(new Message(42, "Mx4j agent"), this.adaptorName, e);
        }
        catch (MBeanException e) {
            throw new JmxManagementException(new Message(42, "Mx4j agent"), this.adaptorName, e);
        }
        catch (ReflectionException reflectionException) {
            // empty catch block
        }
    }

    public void stop() throws UMOException {
        try {
            this.mBeanServer.invoke(this.adaptorName, "stop", null, null);
        }
        catch (InstanceNotFoundException e) {
            throw new JmxManagementException(new Message(41, "Mx4j agent"), this.adaptorName, e);
        }
        catch (MBeanException e) {
            throw new JmxManagementException(new Message(41, "Mx4j agent"), this.adaptorName, e);
        }
        catch (ReflectionException reflectionException) {
            // empty catch block
        }
    }

    public void dispose() {
        try {
            this.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void registered() {
    }

    public void unregistered() {
    }

    public void initialise() throws InitialisationException {
        try {
            this.mBeanServer = MBeanServerFactory.findMBeanServer(null).get(0);
            this.adaptor = this.createAdaptor();
            this.adaptorName = new ObjectName("Adaptor:class=" + this.adaptor.getClass().getName());
            this.mBeanServer.registerMBean(this.adaptor, this.adaptorName);
        }
        catch (Exception e) {
            throw new InitialisationException(new Message(42, "mx4j agent"), (Object)e);
        }
    }

    public String getJmxAdaptorUrl() {
        return this.jmxAdaptorUrl;
    }

    public void setJmxAdaptorUrl(String jmxAdaptorUrl) {
        this.jmxAdaptorUrl = jmxAdaptorUrl;
    }
}

