/*
 * Decompiled with CFR 0.152.
 */
package org.mule.management.stats;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentHashMap;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.mule.management.stats.Statistics;
import org.mule.management.stats.printers.SimplePrinter;
import org.mule.umo.endpoint.UMOEndpoint;

public class RouterStatistics
implements Statistics {
    public static final int TYPE_INBOUND = 1;
    public static final int TYPE_OUTBOUND = 2;
    public static final int TYPE_RESPONSE = 3;
    private boolean enabled;
    private int notRouted;
    private int caughtInCatchAll;
    private int totalRouted;
    private int totalReceived;
    private Map routed;
    private int type;

    public synchronized void clear() {
        this.notRouted = 0;
        this.totalRouted = 0;
        this.totalReceived = 0;
        this.caughtInCatchAll = 0;
        this.routed.clear();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void logSummary() {
        this.logSummary(new SimplePrinter(System.out));
    }

    public void logSummary(PrintWriter printer) {
        printer.print(this);
    }

    public synchronized void setEnabled(boolean b) {
        this.enabled = b;
    }

    public RouterStatistics(int type) {
        this.type = type;
        this.routed = new ConcurrentHashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementRoutedMessage(Collection endpoints) {
        ArrayList list;
        if (endpoints == null || endpoints.isEmpty()) {
            return;
        }
        ArrayList arrayList = list = new ArrayList(endpoints);
        synchronized (arrayList) {
            for (int i = 0; i < list.size(); ++i) {
                this.incrementRoutedMessage((UMOEndpoint)list.get(i));
            }
        }
    }

    public synchronized void incrementRoutedMessage(UMOEndpoint endpoint) {
        if (endpoint == null) {
            return;
        }
        String name = endpoint.getName();
        Integer cpt = (Integer)this.routed.get(name);
        int count = 0;
        if (cpt != null) {
            count = cpt;
        }
        this.routed.put(name, new Integer(++count));
        ++this.totalRouted;
        ++this.totalReceived;
    }

    public synchronized void incrementNoRoutedMessage() {
        ++this.notRouted;
        ++this.totalReceived;
    }

    public synchronized void incrementCaughtMessage() {
        ++this.caughtInCatchAll;
    }

    public final int getCaughtMessages() {
        return this.caughtInCatchAll;
    }

    public final int getNotRouted() {
        return this.notRouted;
    }

    public final int getTotalReceived() {
        return this.totalReceived;
    }

    public final int getTotalRouted() {
        return this.totalRouted;
    }

    public final int getRouted(String endpointName) {
        Integer i = (Integer)this.routed.get(endpointName);
        if (i == null) {
            return 0;
        }
        return i;
    }

    public boolean isInbound() {
        return this.type == 1;
    }

    public Map getRouted() {
        return this.routed;
    }
}

