/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers;

import org.mule.config.i18n.Message;
import org.mule.providers.AbstractConnectionStrategy;
import org.mule.providers.FatalConnectException;
import org.mule.umo.provider.UMOConnectable;

public class SimpleRetryConnectionStrategy
extends AbstractConnectionStrategy {
    private int retryCount = 2;
    private long frequency = 2000L;
    private int count = 0;

    public void doConnect(UMOConnectable connectable) throws FatalConnectException {
        while (true) {
            try {
                ++this.count;
                connectable.connect();
                this.count = 0;
                if (!this.logger.isDebugEnabled()) break;
                this.logger.debug((Object)("Successfully connected to " + this.getDescription(connectable)));
                break;
            }
            catch (Exception e) {
                if (this.count == this.retryCount) {
                    throw new FatalConnectException(new Message(164, this.getClass().getName(), (Object)this.getDescription(connectable)), e, connectable);
                }
                this.logger.warn((Object)("Failed to connect/reconnect on endpoint: " + this.getDescription(connectable)));
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Waiting for " + this.frequency + "ms before reconnecting"));
                }
                try {
                    Thread.sleep(this.frequency);
                }
                catch (InterruptedException e1) {
                    throw new FatalConnectException(new Message(164, this.getClass().getName(), (Object)this.getDescription(connectable)), e, connectable);
                }
            }
        }
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public void setRetryCount(int retryCount) {
        this.retryCount = retryCount;
    }

    public long getFrequency() {
        return this.frequency;
    }

    public void setFrequency(long frequency) {
        this.frequency = frequency;
    }
}

