/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.inbound;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.routing.inbound.EventGroup;
import org.mule.routing.inbound.SelectiveConsumer;
import org.mule.umo.MessagingException;
import org.mule.umo.UMOEvent;

public abstract class AbstractEventResequencer
extends SelectiveConsumer {
    protected static final String NO_CORRELATION_ID = "no-id";
    protected static transient Log logger = LogFactory.getLog((Class)(class$org$mule$routing$inbound$AbstractEventResequencer == null ? (class$org$mule$routing$inbound$AbstractEventResequencer = AbstractEventResequencer.class$("org.mule.routing.inbound.AbstractEventResequencer")) : class$org$mule$routing$inbound$AbstractEventResequencer));
    private Comparator comparator;
    private Map eventGroups = new HashMap();
    static /* synthetic */ Class class$org$mule$routing$inbound$AbstractEventResequencer;

    public UMOEvent[] process(UMOEvent event) throws MessagingException {
        EventGroup eg;
        if (this.isMatch(event) && this.shouldResequence(eg = this.addEvent(event))) {
            List resequencedEvents = this.resequenceEvents(eg);
            this.removeGroup(eg.getGroupId());
            UMOEvent[] returnEvents = new UMOEvent[resequencedEvents.size()];
            resequencedEvents.toArray(returnEvents);
            return returnEvents;
        }
        return null;
    }

    protected EventGroup addEvent(UMOEvent event) {
        EventGroup eg;
        String cId = event.getMessage().getCorrelationId();
        if (cId == null) {
            cId = NO_CORRELATION_ID;
        }
        if ((eg = (EventGroup)this.eventGroups.get(cId)) == null) {
            eg = new EventGroup(cId);
            eg.addEvent(event);
            this.eventGroups.put(eg.getGroupId(), eg);
        } else {
            eg.addEvent(event);
        }
        return eg;
    }

    protected void removeGroup(Object id) {
        this.eventGroups.remove(id);
    }

    protected List resequenceEvents(EventGroup events) {
        ArrayList result = new ArrayList(events.getEvents());
        if (this.comparator != null) {
            Collections.sort(result, this.comparator);
        } else {
            logger.warn((Object)"Event comparator is null, events were not reordered");
        }
        return result;
    }

    public Comparator getComparator() {
        return this.comparator;
    }

    public void setComparator(Comparator comparator) {
        this.comparator = comparator;
    }

    protected abstract boolean shouldResequence(EventGroup var1);

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

