/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.inbound;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.config.i18n.Message;
import org.mule.impl.MuleMessage;
import org.mule.management.stats.RouterStatistics;
import org.mule.umo.MessagingException;
import org.mule.umo.UMOEvent;
import org.mule.umo.UMOFilter;
import org.mule.umo.UMOMessage;
import org.mule.umo.routing.RoutingException;
import org.mule.umo.routing.UMOInboundRouter;
import org.mule.umo.transformer.TransformerException;

public class SelectiveConsumer
implements UMOInboundRouter {
    protected transient Log logger = LogFactory.getLog(this.getClass());
    private UMOFilter filter;
    private boolean transformFirst = true;
    private RouterStatistics routerStatistics;

    public boolean isMatch(UMOEvent event) throws MessagingException {
        UMOMessage message;
        if (this.filter == null) {
            return true;
        }
        if (this.transformFirst) {
            try {
                Object payload = event.getTransformedMessage();
                message = new MuleMessage(payload, event.getMessage().getProperties());
            }
            catch (TransformerException e) {
                throw new RoutingException(new Message(52), event.getMessage(), event.getEndpoint(), e);
            }
        } else {
            message = event.getMessage();
        }
        return this.filter.accept(message);
    }

    public UMOEvent[] process(UMOEvent event) throws MessagingException {
        if (this.isMatch(event)) {
            return new UMOEvent[]{event};
        }
        return null;
    }

    public UMOFilter getFilter() {
        return this.filter;
    }

    public void setFilter(UMOFilter filter) {
        this.filter = filter;
    }

    public boolean isTransformFirst() {
        return this.transformFirst;
    }

    public void setTransformFirst(boolean transformFirst) {
        this.transformFirst = transformFirst;
    }

    public void setRouterStatistics(RouterStatistics stats) {
        this.routerStatistics = stats;
    }

    public RouterStatistics getRouterStatistics() {
        return this.routerStatistics;
    }
}

