/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.outbound;

import org.mule.config.i18n.Message;
import org.mule.impl.MuleMessage;
import org.mule.routing.outbound.AbstractOutboundRouter;
import org.mule.umo.UMOException;
import org.mule.umo.UMOFilter;
import org.mule.umo.UMOMessage;
import org.mule.umo.UMOSession;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.routing.CouldNotRouteOutboundMessageException;
import org.mule.umo.routing.RoutePathNotFoundException;
import org.mule.umo.routing.RoutingException;
import org.mule.umo.transformer.TransformerException;
import org.mule.umo.transformer.UMOTransformer;

public class FilteringOutboundRouter
extends AbstractOutboundRouter {
    private UMOTransformer transformer;
    private UMOFilter filter;

    public UMOMessage route(UMOMessage message, UMOSession session, boolean synchronous) throws RoutingException {
        UMOMessage result = null;
        if (this.endpoints == null || this.endpoints.size() == 0) {
            throw new RoutePathNotFoundException(new Message(89), message, null);
        }
        try {
            if (synchronous) {
                result = this.send(session, message, (UMOEndpoint)this.endpoints.get(0));
            } else {
                this.dispatch(session, message, (UMOEndpoint)this.endpoints.get(0));
            }
        }
        catch (UMOException e) {
            throw new CouldNotRouteOutboundMessageException(message, (UMOEndpoint)this.endpoints.get(0), (Throwable)e);
        }
        return result;
    }

    public UMOFilter getFilter() {
        return this.filter;
    }

    public void setFilter(UMOFilter filter) {
        this.filter = filter;
    }

    public boolean isMatch(UMOMessage message) throws RoutingException {
        if (this.getFilter() == null) {
            return true;
        }
        if (this.transformer != null) {
            try {
                Object payload = this.transformer.transform(message.getPayload());
                message = new MuleMessage(payload, message.getProperties());
            }
            catch (TransformerException e) {
                throw new RoutingException(new Message(52), message, (UMOEndpoint)this.endpoints.get(0), e);
            }
        }
        return this.getFilter().accept(message);
    }

    public UMOTransformer getTransformer() {
        return this.transformer;
    }

    public void setTransformer(UMOTransformer transformer) {
        this.transformer = transformer;
    }
}

