/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.response;

import EDU.oswego.cs.dl.util.concurrent.CopyOnWriteArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.impl.MuleMessage;
import org.mule.providers.AbstractConnector;
import org.mule.routing.AbstractRouterCollection;
import org.mule.umo.UMOEvent;
import org.mule.umo.UMOMessage;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.routing.RoutingException;
import org.mule.umo.routing.UMOResponseMessageRouter;
import org.mule.umo.routing.UMOResponseRouter;
import org.mule.umo.transformer.TransformerException;
import org.mule.umo.transformer.UMOTransformer;

public class ResponseMessageRouter
extends AbstractRouterCollection
implements UMOResponseMessageRouter {
    protected static transient Log logger = LogFactory.getLog((Class)(class$org$mule$routing$response$ResponseMessageRouter == null ? (class$org$mule$routing$response$ResponseMessageRouter = ResponseMessageRouter.class$("org.mule.routing.response.ResponseMessageRouter")) : class$org$mule$routing$response$ResponseMessageRouter));
    private List endpoints = new CopyOnWriteArrayList();
    private UMOTransformer transformer;
    private boolean transExplicitlySet = false;
    private int timeout = 10000;
    static /* synthetic */ Class class$org$mule$routing$response$ResponseMessageRouter;

    public ResponseMessageRouter() {
        super(3);
    }

    public void route(UMOEvent event) throws RoutingException {
        UMOResponseRouter router = null;
        if (!this.transExplicitlySet) {
            this.transformer = ((AbstractConnector)event.getEndpoint().getConnector()).getDefaultResponseTransformer();
        }
        Iterator iterator = this.getRouters().iterator();
        while (iterator.hasNext()) {
            router = (UMOResponseRouter)iterator.next();
            router.process(event);
            if (!this.getStatistics().isEnabled()) continue;
            this.getStatistics().incrementRoutedMessage(event.getEndpoint());
        }
    }

    public UMOMessage getResponse(UMOMessage message) throws RoutingException {
        UMOMessage result = null;
        if (this.routers.size() == 0) {
            logger.warn((Object)"There are no routers configured on the response router. Returning the current message");
            result = message;
        } else {
            UMOResponseRouter router = null;
            Iterator iterator = this.getRouters().iterator();
            while (iterator.hasNext()) {
                router = (UMOResponseRouter)iterator.next();
                result = router.getResponse(message);
            }
            if (result == null && this.getStatistics().isEnabled()) {
                this.getStatistics().incrementNoRoutedMessage();
            }
        }
        if (result != null && this.transformer != null) {
            try {
                result = new MuleMessage(this.transformer.transform(result.getPayload()), result.getProperties());
            }
            catch (TransformerException e) {
                throw new RoutingException(result, null);
            }
        }
        return result;
    }

    public void addRouter(UMOResponseRouter router) {
        router.setTimeout(this.getTimeout());
        this.routers.add(router);
    }

    public UMOResponseRouter removeRouter(UMOResponseRouter router) {
        if (this.routers.remove(router)) {
            return router;
        }
        return null;
    }

    public void addEndpoint(UMOEndpoint endpoint) {
        if (endpoint == null) {
            throw new NullPointerException("Endpoint cannot be null");
        }
        endpoint.setType("response");
        this.endpoints.add(endpoint);
    }

    public boolean removeEndpoint(UMOEndpoint endpoint) {
        return this.endpoints.remove(endpoint);
    }

    public List getEndpoints() {
        return this.endpoints;
    }

    public void setEndpoints(List endpoints) {
        Iterator iterator = endpoints.iterator();
        while (iterator.hasNext()) {
            UMOEndpoint endpoint = (UMOEndpoint)iterator.next();
            this.addEndpoint(endpoint);
        }
    }

    public UMOEndpoint getEndpoint(String name) {
        Iterator iterator = this.endpoints.iterator();
        while (iterator.hasNext()) {
            UMOEndpoint endpointDescriptor = (UMOEndpoint)iterator.next();
            if (!endpointDescriptor.getName().equals(name)) continue;
            return endpointDescriptor;
        }
        return null;
    }

    public UMOTransformer getTransformer() {
        return this.transformer;
    }

    public void setTransformer(UMOTransformer transformer) {
        this.transformer = transformer;
        this.transExplicitlySet = true;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

