/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck.providers;

import org.mule.tck.AbstractMuleTestCase;
import org.mule.umo.provider.UMOMessageAdapter;

public abstract class AbstractMessageAdapterTestCase
extends AbstractMuleTestCase {
    public void testMessageRetrieval() throws Exception {
        Object message = this.getValidMessage();
        UMOMessageAdapter adapter = this.createAdapter(message);
        AbstractMessageAdapterTestCase.assertEquals((Object)message, (Object)adapter.getPayload());
        byte[] bytes = adapter.getPayloadAsBytes();
        AbstractMessageAdapterTestCase.assertNotNull((Object)bytes);
        String stringMessage = adapter.getPayloadAsString();
        AbstractMessageAdapterTestCase.assertNotNull((Object)stringMessage);
        AbstractMessageAdapterTestCase.assertNotNull((Object)adapter.getPayload());
        try {
            adapter = this.createAdapter(this.getInvalidMessage());
            AbstractMessageAdapterTestCase.fail((String)"Message adapter should throw exception if an invalid messgae is set");
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void testMessageProps() throws Exception {
        UMOMessageAdapter adapter = this.createAdapter(this.getValidMessage());
        adapter.setProperty("TestString", "Test1");
        adapter.setProperty("TestLong", new Long(20000000L));
        adapter.setProperty("TestInt", new Integer(200000));
        AbstractMessageAdapterTestCase.assertNotNull((Object)adapter.getPropertyNames());
        Object prop = adapter.getProperty("TestString");
        AbstractMessageAdapterTestCase.assertNotNull((Object)prop);
        AbstractMessageAdapterTestCase.assertEquals((Object)"Test1", (Object)prop);
        prop = adapter.getProperty("TestLong");
        AbstractMessageAdapterTestCase.assertNotNull((Object)prop);
        AbstractMessageAdapterTestCase.assertEquals((Object)new Long(20000000L), (Object)prop);
        prop = adapter.getProperty("TestInt");
        AbstractMessageAdapterTestCase.assertNotNull((Object)prop);
        AbstractMessageAdapterTestCase.assertEquals((Object)new Integer(200000), (Object)prop);
    }

    public Object getInvalidMessage() {
        return new InvalidMessage();
    }

    public abstract Object getValidMessage() throws Exception;

    public abstract UMOMessageAdapter createAdapter(Object var1) throws Exception;

    final class InvalidMessage {
        InvalidMessage() {
        }

        public String toString() {
            return "invalid message";
        }
    }
}

