/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transaction;

import java.util.HashMap;
import java.util.Map;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.mule.MuleManager;
import org.mule.config.i18n.Message;
import org.mule.transaction.AbstractTransaction;
import org.mule.transaction.IllegalTransactionStateException;
import org.mule.transaction.TransactionRollbackException;
import org.mule.transaction.TransactionStatusException;
import org.mule.umo.TransactionException;
import org.mule.umo.UMOTransaction;

public class XaTransaction
extends AbstractTransaction
implements UMOTransaction {
    private Transaction transaction = null;
    private Map resources = null;

    protected void doBegin() throws TransactionException {
        TransactionManager txManager = MuleManager.getInstance().getTransactionManager();
        if (txManager == null) {
            throw new IllegalStateException(new Message(82, "Transaction Manager").getMessage());
        }
        try {
            txManager.begin();
            this.transaction = txManager.getTransaction();
        }
        catch (Exception e) {
            throw new TransactionException(new Message(96, "XA"), (Throwable)e);
        }
    }

    protected void doCommit() throws TransactionException {
        try {
            this.transaction.commit();
        }
        catch (RollbackException e) {
            throw new TransactionRollbackException(new Message(77), (Throwable)e);
        }
        catch (HeuristicRollbackException e) {
            throw new TransactionRollbackException(new Message(77), (Throwable)e);
        }
        catch (Exception e) {
            throw new IllegalTransactionStateException(new Message(97), (Throwable)e);
        }
    }

    protected void doRollback() throws TransactionRollbackException {
        try {
            this.transaction.rollback();
        }
        catch (SystemException e) {
            throw new TransactionRollbackException(e);
        }
    }

    public int getStatus() throws TransactionStatusException {
        if (this.transaction == null) {
            return 6;
        }
        try {
            return this.transaction.getStatus();
        }
        catch (SystemException e) {
            throw new TransactionStatusException(e);
        }
    }

    public void setRollbackOnly() {
        try {
            this.transaction.setRollbackOnly();
        }
        catch (SystemException e) {
            throw new IllegalStateException("Failed to set transaction to rollback only: " + e.getMessage());
        }
    }

    public Object getResource(Object key) {
        return this.resources == null ? null : this.resources.get(key);
    }

    public boolean hasResource(Object key) {
        return this.resources != null && this.resources.containsKey(key);
    }

    public void bindResource(Object key, Object resource) throws TransactionException {
        if (this.resources == null) {
            this.resources = new HashMap();
        }
        if (this.resources.containsKey(key)) {
            throw new IllegalTransactionStateException(new Message(100, key));
        }
        this.resources.put(key, resource);
    }
}

