/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformers.compression;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.transformers.AbstractTransformer;
import org.mule.umo.transformer.TransformerException;
import org.mule.util.Utility;
import org.mule.util.compression.CompressionHelper;
import org.mule.util.compression.CompressionStrategy;

public abstract class AbstractCompressionTransformer
extends AbstractTransformer {
    private static transient Log logger = LogFactory.getLog((Class)(class$org$mule$transformers$compression$AbstractCompressionTransformer == null ? (class$org$mule$transformers$compression$AbstractCompressionTransformer = AbstractCompressionTransformer.class$("org.mule.transformers.compression.AbstractCompressionTransformer")) : class$org$mule$transformers$compression$AbstractCompressionTransformer));
    static /* synthetic */ Class class$org$mule$transformers$compression$AbstractCompressionTransformer;

    protected byte[] compressMessage(Object src) throws TransformerException {
        try {
            byte[] buffer = src instanceof String ? ((String)src).getBytes() : (src instanceof byte[] ? (byte[])src : Utility.objectToByteArray(src));
            byte[] cmp = CompressionHelper.compressByteArray(buffer);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Compressed message in transformation");
            }
            return cmp;
        }
        catch (IOException e) {
            throw new TransformerException(this, (Throwable)e);
        }
    }

    protected byte[] uncompressMessage(Object src) throws TransformerException {
        byte[] buffer = null;
        try {
            buffer = src instanceof String ? this.getStrategy().uncompressByteArray(((String)src).getBytes()) : this.getStrategy().uncompressByteArray((byte[])src);
        }
        catch (IOException e) {
            logger.error((Object)("Failed to uncompress message: " + e), (Throwable)e);
        }
        return buffer;
    }

    protected abstract CompressionStrategy getStrategy();

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

