/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.queue;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.doomdark.uuid.UUIDGenerator;
import org.mule.MuleManager;
import org.mule.util.file.DeleteException;
import org.mule.util.queue.QueuePersistenceStrategy;

public class FilePersistenceStrategy
implements QueuePersistenceStrategy {
    private static final Log logger = LogFactory.getLog((Class)(class$org$mule$util$queue$FilePersistenceStrategy == null ? (class$org$mule$util$queue$FilePersistenceStrategy = FilePersistenceStrategy.class$("org.mule.util.queue.FilePersistenceStrategy")) : class$org$mule$util$queue$FilePersistenceStrategy));
    public static final String EXTENSION = ".msg";
    private File store;
    private UUIDGenerator gen = UUIDGenerator.getInstance();
    static /* synthetic */ Class class$org$mule$util$queue$FilePersistenceStrategy;

    protected String getId(Object obj) {
        String id = this.gen.generateRandomBasedUUID().toString();
        return id;
    }

    public Object store(String queue, Object obj) throws IOException {
        String id = this.getId(obj);
        File file = new File(this.store, queue + File.separator + id + EXTENSION);
        file.getParentFile().mkdirs();
        ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(file));
        oos.writeObject(obj);
        oos.close();
        return id;
    }

    public void remove(String queue, Object id) throws IOException {
        File file = new File(this.store, queue + File.separator + id + EXTENSION);
        if (file.exists()) {
            if (!file.delete()) {
                throw new DeleteException(file);
            }
        } else {
            throw new FileNotFoundException(file.toString());
        }
    }

    public Object load(String queue, Object id) throws IOException {
        File file = new File(this.store, queue + File.separator + id + EXTENSION);
        ObjectInputStream ois = null;
        try {
            Object obj;
            ois = new ObjectInputStream(new FileInputStream(file));
            Object object = obj = ois.readObject();
            return object;
        }
        catch (ClassNotFoundException e) {
            throw (IOException)new IOException("Error loading persistent object").initCause(e);
        }
        finally {
            if (ois != null) {
                ois.close();
            }
        }
    }

    public List restore() throws IOException {
        try {
            ArrayList msgs = new ArrayList();
            this.restoreFiles(this.store, msgs);
            logger.debug((Object)("Restore retrieved " + msgs.size() + " objects"));
            return msgs;
        }
        catch (ClassNotFoundException e) {
            throw (IOException)new IOException("Could not restore").initCause(e);
        }
    }

    protected void restoreFiles(File dir, List msgs) throws IOException, ClassNotFoundException {
        File[] files = dir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                this.restoreFiles(files[i], msgs);
                continue;
            }
            if (!files[i].getName().endsWith(EXTENSION)) continue;
            String id = files[i].getCanonicalPath();
            id = id.substring(this.store.getCanonicalPath().length() + 1, id.length() - EXTENSION.length());
            String queue = id.substring(0, id.indexOf(File.separator));
            id = id.substring(queue.length() + 1);
            msgs.add(new HolderImpl(queue, id));
        }
    }

    public void open() throws IOException {
        String path = MuleManager.getConfiguration().getWorkingDirectory() + File.separator + "queuestore";
        this.store = new File(path).getCanonicalFile();
        this.store.mkdirs();
    }

    public void close() throws IOException {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected static class HolderImpl
    implements QueuePersistenceStrategy.Holder {
        private String queue;
        private Object id;

        public HolderImpl(String queue, Object id) {
            this.queue = queue;
            this.id = id;
        }

        public Object getId() {
            return this.id;
        }

        public String getQueue() {
            return this.queue;
        }
    }
}

