/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.queue;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentHashMap;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.activeio.Packet;
import org.activeio.journal.Journal;
import org.activeio.journal.JournalEventListener;
import org.activeio.journal.RecordLocation;
import org.activeio.journal.active.JournalImpl;
import org.activeio.journal.active.LogFileManager;
import org.activeio.packet.ByteArrayPacket;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.doomdark.uuid.UUID;
import org.doomdark.uuid.UUIDGenerator;
import org.mule.MuleManager;
import org.mule.util.queue.QueuePersistenceStrategy;

public class JournalPersistenceStrategy
implements QueuePersistenceStrategy,
Runnable,
JournalEventListener {
    private static final Log logger = LogFactory.getLog((Class)(class$org$mule$util$queue$JournalPersistenceStrategy == null ? (class$org$mule$util$queue$JournalPersistenceStrategy = JournalPersistenceStrategy.class$("org.mule.util.queue.JournalPersistenceStrategy")) : class$org$mule$util$queue$JournalPersistenceStrategy));
    private UUIDGenerator gen = UUIDGenerator.getInstance();
    private Journal journal;
    private Map marks;
    private Thread marker;
    private SortedSet pendingMarks;
    private SortedSet unusedMarks;
    private Object markLock = new Object();
    private RecordLocation overflowLocation = null;
    private File store;
    private static final byte STORE_BYTE = 0;
    private static final byte DELETE_BYTE = 1;
    private static final int UUID_LENGTH = new UUID().asByteArray().length;
    private static final Object ACTIVE_MARK = new Object();
    private static final Object INACTIVE_MARK = new Object();
    static /* synthetic */ Class class$org$mule$util$queue$JournalPersistenceStrategy;

    protected UUID getId(Object obj) {
        return this.gen.generateTimeBasedUUID();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object store(String queue, Object obj) throws IOException {
        UUID id = this.getId(obj);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeByte(0);
        oos.writeUTF(queue);
        oos.write(id.asByteArray());
        oos.writeObject(obj);
        oos.close();
        ByteArrayPacket packet = new ByteArrayPacket(baos.toByteArray());
        RecordLocation loc = this.journal.write((Packet)packet, false);
        Object object = this.markLock;
        synchronized (object) {
            this.marks.put(id, loc);
            this.pendingMarks.add(loc);
        }
        return id;
    }

    public Object load(String queue, Object id) throws IOException {
        try {
            RecordLocation loc = (RecordLocation)this.marks.get(id);
            Packet packet = this.journal.read(loc);
            ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(packet.sliceAsBytes()));
            ois.readByte();
            ois.readUTF();
            ois.skipBytes(UUID_LENGTH);
            Object obj = ois.readObject();
            return obj;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw (IOException)new IOException().initCause(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String queue, Object id) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(1);
        baos.write(((UUID)id).asByteArray());
        ByteArrayPacket packet = new ByteArrayPacket(baos.toByteArray());
        RecordLocation loc = this.journal.write((Packet)packet, false);
        Object object = this.markLock;
        synchronized (object) {
            this.unusedMarks.add(loc);
            loc = (RecordLocation)this.marks.remove(id);
            if (loc != null) {
                this.pendingMarks.remove(loc);
                this.unusedMarks.add(loc);
            }
            this.markLock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List restore() throws IOException {
        HashMap<UUID, HolderImpl> results = new HashMap<UUID, HolderImpl>();
        RecordLocation pos = null;
        logger.info((Object)"Journal Recovery Started.");
        try {
            Object object = this.markLock;
            synchronized (object) {
                while ((pos = this.journal.getNextRecordLocation(pos)) != null) {
                    Packet packet = this.journal.read(pos);
                    byte[] buffer = packet.sliceAsBytes();
                    if (buffer[0] == 1) {
                        UUID id = new UUID(buffer, 1);
                        results.remove(id);
                        this.unusedMarks.add(pos);
                        RecordLocation loc = (RecordLocation)this.marks.remove(id);
                        if (loc != null) {
                            this.pendingMarks.remove(loc);
                            this.unusedMarks.add(loc);
                        }
                        this.markLock.notify();
                        continue;
                    }
                    ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(buffer));
                    ois.readByte();
                    String queue = ois.readUTF();
                    byte[] buf = new byte[UUID_LENGTH];
                    ois.read(buf);
                    UUID id = new UUID(buf);
                    results.put(id, new HolderImpl(queue, id));
                    this.marks.put(id, pos);
                    this.pendingMarks.add(pos);
                }
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw (IOException)new IOException().initCause(e);
        }
        logger.info((Object)("Journal Recovered: " + results.size() + " message(s) in transactions recovered."));
        return new ArrayList(results.values());
    }

    public void open() throws IOException {
        File s = this.store;
        if (s == null) {
            s = new File(MuleManager.getConfiguration().getWorkingDirectory() + File.separator + "queuestore");
        }
        s.mkdirs();
        this.journal = new JournalImpl(s, 8, LogFileManager.DEFAULT_LOGFILE_SIZE);
        this.journal.setJournalEventListener((JournalEventListener)this);
        this.marks = new ConcurrentHashMap();
        this.pendingMarks = new TreeSet();
        this.unusedMarks = new TreeSet();
        this.marker = new Thread((Runnable)this, "JournalPersistenceStrategy");
        this.marker.setDaemon(true);
        this.marker.start();
    }

    public void close() throws IOException {
        this.marker.interrupt();
        this.journal.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        long lastTime = 0L;
        try {
            while (!Thread.interrupted()) {
                Thread.sleep(100L);
                Object object = this.markLock;
                synchronized (object) {
                    try {
                        SortedSet<RecordLocation> m;
                        if (this.overflowLocation != null) {
                            RecordLocation overflowLoc = this.overflowLocation;
                            this.overflowLocation = null;
                            m = this.pendingMarks.headSet(overflowLoc);
                            if (m != null && m.size() > 0) {
                                logger.trace((Object)("Relocating " + m.size() + " records"));
                                int nbRecord = 0;
                                while (m.size() > 0) {
                                    RecordLocation loc = m.first();
                                    Packet packet = this.journal.read(loc);
                                    RecordLocation newLoc = this.journal.write(packet, false);
                                    ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(packet.sliceAsBytes()));
                                    ois.readByte();
                                    String queue = ois.readUTF();
                                    byte[] buf = new byte[UUID_LENGTH];
                                    ois.read(buf);
                                    UUID id = new UUID(buf);
                                    if (++nbRecord % 10 == 0) {
                                        RecordLocation n = this.journal.getNextRecordLocation(loc);
                                        this.journal.setMark(n != null ? n : loc, false);
                                    }
                                    this.unusedMarks.add(loc);
                                    this.pendingMarks.add(newLoc);
                                    this.marks.put(id, newLoc);
                                    m.remove(loc);
                                }
                            }
                        }
                        if (this.pendingMarks.isEmpty()) {
                            m = this.unusedMarks;
                        } else {
                            RecordLocation pendingMark = (RecordLocation)this.pendingMarks.first();
                            m = this.unusedMarks.headSet(pendingMark);
                        }
                        if (!m.isEmpty()) {
                            RecordLocation last = m.last();
                            RecordLocation n = this.journal.getNextRecordLocation(m.last());
                            if (n == null) {
                                n = last;
                            }
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)("Marking to " + n + " / " + (this.pendingMarks.isEmpty() ? "null" : this.pendingMarks.last())));
                            }
                            if (this.journal.getMark() == null || n.compareTo((Object)this.journal.getMark()) > 0) {
                                this.journal.setMark(n, false);
                            }
                            m.clear();
                        }
                    }
                    catch (Exception e) {
                        logger.warn((Object)"Error when relocating records", (Throwable)e);
                    }
                }
            }
            return;
        }
        catch (InterruptedException e) {
            logger.debug((Object)"Marker thread interrupted");
        }
    }

    public void overflowNotification(RecordLocation safeLoc) {
        this.overflowLocation = safeLoc;
        logger.debug((Object)("Overflow to " + safeLoc));
    }

    public File getStore() {
        return this.store;
    }

    public void setStore(File store) {
        this.store = store;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected static class HolderImpl
    implements QueuePersistenceStrategy.Holder {
        private String queue;
        private Object id;

        public HolderImpl(String queue, Object id) {
            this.queue = queue;
            this.id = id;
        }

        public Object getId() {
            return this.id;
        }

        public String getQueue() {
            return this.queue;
        }
    }
}

