/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.queue;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.util.queue.MemoryPersistenceStrategy;
import org.mule.util.queue.Queue;
import org.mule.util.queue.QueueConfiguration;
import org.mule.util.queue.QueueManager;
import org.mule.util.queue.QueuePersistenceStrategy;
import org.mule.util.queue.QueueSession;
import org.mule.util.xa.AbstractTransactionContext;
import org.mule.util.xa.AbstractXAResourceManager;
import org.mule.util.xa.ResourceManagerException;
import org.mule.util.xa.ResourceManagerSystemException;

public class TransactionalQueueManager
extends AbstractXAResourceManager
implements QueueManager {
    private static Log logger = LogFactory.getLog((Class)(class$org$mule$util$queue$TransactionalQueueManager == null ? (class$org$mule$util$queue$TransactionalQueueManager = TransactionalQueueManager.class$("org.mule.util.queue.TransactionalQueueManager")) : class$org$mule$util$queue$TransactionalQueueManager));
    private Map queues = new HashMap();
    private QueuePersistenceStrategy memoryPersistenceStrategy = new MemoryPersistenceStrategy();
    private QueuePersistenceStrategy persistenceStrategy;
    private QueueConfiguration defaultQueueConfiguration = new QueueConfiguration(false);
    static /* synthetic */ Class class$org$mule$util$queue$TransactionalQueueManager;

    public synchronized QueueSession getQueueSession() {
        return new QueueSessionImpl();
    }

    public synchronized void setDefaultQueueConfiguration(QueueConfiguration config) {
        this.defaultQueueConfiguration = config;
    }

    public synchronized void setQueueConfiguration(String queueName, QueueConfiguration config) {
        this.getQueue((String)queueName).config = config;
    }

    protected synchronized QueueInfo getQueue(String name) {
        QueueInfo q = (QueueInfo)this.queues.get(name);
        if (q == null) {
            q = new QueueInfo();
            q.name = name;
            q.list = new LinkedList();
            q.config = this.defaultQueueConfiguration;
            this.queues.put(name, q);
        }
        return q;
    }

    protected Log getLogger() {
        return logger;
    }

    public void close() {
        try {
            this.stop(0);
        }
        catch (ResourceManagerException e) {
            logger.error((Object)"Error disposing manager", (Throwable)e);
        }
    }

    protected void doStart() throws ResourceManagerSystemException {
        if (this.persistenceStrategy != null) {
            try {
                this.persistenceStrategy.open();
            }
            catch (IOException e) {
                throw new ResourceManagerSystemException(e);
            }
        }
    }

    protected boolean shutdown(int mode, long timeoutMSecs) {
        try {
            if (this.persistenceStrategy != null) {
                this.persistenceStrategy.close();
            }
        }
        catch (IOException e) {
            logger.error((Object)"Error closing persistent store", (Throwable)e);
        }
        return super.shutdown(mode, timeoutMSecs);
    }

    protected void recover() throws ResourceManagerSystemException {
        if (this.persistenceStrategy != null) {
            try {
                List msgs = this.persistenceStrategy.restore();
                Iterator it = msgs.iterator();
                while (it.hasNext()) {
                    QueuePersistenceStrategy.Holder h = (QueuePersistenceStrategy.Holder)it.next();
                    this.getQueue(h.getQueue()).putNow(h.getId());
                }
            }
            catch (Exception e) {
                throw new ResourceManagerSystemException(e);
            }
        }
    }

    protected AbstractTransactionContext createTransactionContext(Object session) {
        return new QueueTransactionContext();
    }

    protected void doBegin(AbstractTransactionContext context) {
    }

    protected int doPrepare(AbstractTransactionContext context) {
        return 0;
    }

    protected void doCommit(AbstractTransactionContext context) throws ResourceManagerException {
        QueueTransactionContext ctx = (QueueTransactionContext)context;
        try {
            QueueInfo queue;
            Map.Entry entry;
            Iterator it;
            if (ctx.added != null) {
                it = ctx.added.entrySet().iterator();
                while (it.hasNext()) {
                    entry = it.next();
                    queue = (QueueInfo)entry.getKey();
                    List queueAdded = (List)entry.getValue();
                    if (queueAdded == null || queueAdded.size() <= 0) continue;
                    Iterator itAdded = queueAdded.iterator();
                    while (itAdded.hasNext()) {
                        Object object = itAdded.next();
                        Object id = this.doStore(queue, object);
                        queue.putNow(id);
                    }
                }
            }
            if (ctx.removed != null) {
                it = ctx.removed.entrySet().iterator();
                while (it.hasNext()) {
                    entry = it.next();
                    queue = (QueueInfo)entry.getKey();
                    List queueRemoved = (List)entry.getValue();
                    if (queueRemoved == null || queueRemoved.size() <= 0) continue;
                    Iterator itRemoved = queueRemoved.iterator();
                    while (itRemoved.hasNext()) {
                        Object id = itRemoved.next();
                        this.doRemove(queue, id);
                    }
                }
            }
        }
        catch (Exception e) {
            throw new ResourceManagerException(e);
        }
        finally {
            ctx.added = null;
            ctx.removed = null;
        }
    }

    protected Object doStore(QueueInfo queue, Object object) throws IOException {
        QueuePersistenceStrategy ps = queue.config.persistent ? this.persistenceStrategy : this.memoryPersistenceStrategy;
        Object id = ps.store(queue.name, object);
        return id;
    }

    protected void doRemove(QueueInfo queue, Object id) throws IOException {
        QueuePersistenceStrategy ps = queue.config.persistent ? this.persistenceStrategy : this.memoryPersistenceStrategy;
        ps.remove(queue.name, id);
    }

    protected Object doLoad(QueueInfo queue, Object id) throws IOException {
        QueuePersistenceStrategy ps = queue.config.persistent ? this.persistenceStrategy : this.memoryPersistenceStrategy;
        Object obj = ps.load(queue.name, id);
        return obj;
    }

    protected void doRollback(AbstractTransactionContext context) throws ResourceManagerException {
        QueueTransactionContext ctx = (QueueTransactionContext)context;
        if (ctx.removed != null) {
            Iterator it = ctx.removed.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                QueueInfo queue = (QueueInfo)entry.getKey();
                List queueRemoved = (List)entry.getValue();
                if (queueRemoved == null || queueRemoved.size() <= 0) continue;
                Iterator itRemoved = queueRemoved.iterator();
                while (itRemoved.hasNext()) {
                    Object id = itRemoved.next();
                    queue.putNow(id);
                }
            }
        }
        ctx.added = null;
        ctx.removed = null;
    }

    public QueuePersistenceStrategy getPersistenceStrategy() {
        return this.persistenceStrategy;
    }

    public void setPersistenceStrategy(QueuePersistenceStrategy persistenceStrategy) {
        if (this.operationMode != 0) {
            throw new IllegalStateException();
        }
        this.persistenceStrategy = persistenceStrategy;
    }

    public QueuePersistenceStrategy getMemoryPersistenceStrategy() {
        return this.memoryPersistenceStrategy;
    }

    public void setMemoryPersistenceStrategy(QueuePersistenceStrategy memoryPersistenceStrategy) {
        if (this.operationMode != 0) {
            throw new IllegalStateException();
        }
        this.memoryPersistenceStrategy = memoryPersistenceStrategy;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected class QueueSessionImpl
    extends AbstractXAResourceManager.AbstractSession
    implements QueueSession {
        protected QueueSessionImpl() {
            super(TransactionalQueueManager.this);
        }

        public Queue getQueue(String name) {
            QueueInfo queue = TransactionalQueueManager.this.getQueue(name);
            return new QueueImpl(queue);
        }

        protected class QueueImpl
        implements Queue {
            protected QueueInfo queue;

            public QueueImpl(QueueInfo queue) {
                this.queue = queue;
            }

            public void put(Object item) throws InterruptedException {
                this.offer(item, Long.MAX_VALUE);
            }

            public boolean offer(Object item, long timeout) throws InterruptedException {
                if (QueueSessionImpl.this.localContext != null) {
                    return ((QueueTransactionContext)QueueSessionImpl.this.localContext).offer(this.queue, item, timeout);
                }
                try {
                    Object id = TransactionalQueueManager.this.doStore(this.queue, item);
                    try {
                        if (!this.queue.offer(id, 0, timeout)) {
                            TransactionalQueueManager.this.doRemove(this.queue, item);
                            return false;
                        }
                        return true;
                    }
                    catch (InterruptedException e) {
                        TransactionalQueueManager.this.doRemove(this.queue, item);
                        throw e;
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

            public Object take() throws InterruptedException {
                return this.poll(Long.MAX_VALUE);
            }

            public Object poll(long timeout) throws InterruptedException {
                try {
                    if (QueueSessionImpl.this.localContext != null) {
                        return ((QueueTransactionContext)QueueSessionImpl.this.localContext).poll(this.queue, timeout);
                    }
                    Object id = this.queue.poll(timeout);
                    if (id != null) {
                        Object item = TransactionalQueueManager.this.doLoad(this.queue, id);
                        TransactionalQueueManager.this.doRemove(this.queue, id);
                        return item;
                    }
                    return null;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

            public Object peek() throws InterruptedException {
                try {
                    if (QueueSessionImpl.this.localContext != null) {
                        return ((QueueTransactionContext)QueueSessionImpl.this.localContext).peek(this.queue);
                    }
                    Object id = this.queue.peek();
                    if (id != null) {
                        Object item = TransactionalQueueManager.this.doLoad(this.queue, id);
                        TransactionalQueueManager.this.doRemove(this.queue, id);
                        return item;
                    }
                    return null;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

            public int size() {
                if (QueueSessionImpl.this.localContext != null) {
                    return ((QueueTransactionContext)QueueSessionImpl.this.localContext).size(this.queue);
                }
                return this.queue.list.size();
            }
        }
    }

    protected class QueueTransactionContext
    extends AbstractTransactionContext {
        protected Map added;
        protected Map removed;

        protected QueueTransactionContext() {
        }

        public boolean offer(QueueInfo queue, Object item, long timeout) throws InterruptedException {
            ArrayList<Object> queueAdded;
            this.readOnly = false;
            if (this.added == null) {
                this.added = new HashMap();
            }
            if ((queueAdded = (ArrayList<Object>)this.added.get(queue)) == null) {
                queueAdded = new ArrayList<Object>();
                this.added.put(queue, queueAdded);
            }
            if (queue.offer(null, queueAdded.size(), Long.MAX_VALUE)) {
                queueAdded.add(item);
                return true;
            }
            return false;
        }

        public Object poll(QueueInfo queue, long timeout) throws IOException, InterruptedException {
            List queueAdded;
            this.readOnly = false;
            if (this.added != null && (queueAdded = (List)this.added.get(queue)) != null) {
                return queueAdded.remove(queueAdded.size() - 1);
            }
            Object o = queue.poll(Long.MAX_VALUE);
            if (o != null) {
                ArrayList<Object> queueRemoved;
                if (this.removed == null) {
                    this.removed = new HashMap();
                }
                if ((queueRemoved = (ArrayList<Object>)this.removed.get(queue)) == null) {
                    queueRemoved = new ArrayList<Object>();
                    this.removed.put(queue, queueRemoved);
                }
                queueRemoved.add(o);
                o = TransactionalQueueManager.this.doLoad(queue, o);
            }
            return o;
        }

        public Object peek(QueueInfo queue) throws IOException, InterruptedException {
            List queueAdded;
            this.readOnly = false;
            if (this.added != null && (queueAdded = (List)this.added.get(queue)) != null) {
                return queueAdded.get(queueAdded.size() - 1);
            }
            Object o = queue.peek();
            if (o != null) {
                o = TransactionalQueueManager.this.doLoad(queue, o);
            }
            return o;
        }

        public int size(QueueInfo queue) {
            List queueAdded;
            int sz = queue.list.size();
            if (this.added != null && (queueAdded = (List)this.added.get(queue)) != null) {
                sz += queueAdded.size();
            }
            return sz;
        }
    }

    public static class QueueInfo {
        protected LinkedList list;
        protected String name;
        protected QueueConfiguration config;

        public boolean equals(Object obj) {
            return obj instanceof QueueInfo && this.name.equals(((QueueInfo)obj).name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void putNow(Object o) {
            LinkedList linkedList = this.list;
            synchronized (linkedList) {
                this.list.addLast(o);
                this.list.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean offer(Object o, int room, long timeout) throws InterruptedException {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            LinkedList linkedList = this.list;
            synchronized (linkedList) {
                if (this.config.capacity > 0) {
                    if (this.config.capacity <= room) {
                        throw new IllegalStateException("Can not add more objects than the capacity in one time");
                    }
                    long l1 = timeout > 0L ? System.currentTimeMillis() : 0L;
                    long l2 = timeout;
                    while (this.list.size() >= this.config.capacity - room) {
                        if (l2 <= 0L) {
                            return false;
                        }
                        this.list.wait(l2);
                        l2 = timeout - (System.currentTimeMillis() - l1);
                    }
                }
                if (o != null) {
                    this.list.addLast(o);
                }
                this.list.notifyAll();
                return true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object poll(long timeout) throws InterruptedException {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            LinkedList linkedList = this.list;
            synchronized (linkedList) {
                long l1 = timeout > 0L ? System.currentTimeMillis() : 0L;
                long l2 = timeout;
                while (this.list.isEmpty()) {
                    if (l2 <= 0L) {
                        return null;
                    }
                    this.list.wait(l2);
                    l2 = timeout - (System.currentTimeMillis() - l1);
                }
                Object o = this.list.removeFirst();
                this.list.notifyAll();
                return o;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object peek() throws InterruptedException {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            LinkedList linkedList = this.list;
            synchronized (linkedList) {
                if (this.list.isEmpty()) {
                    return null;
                }
                return this.list.getFirst();
            }
        }
    }
}

