/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.xa;

import java.util.HashMap;
import java.util.Map;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.mule.util.xa.AbstractResourceManager;
import org.mule.util.xa.AbstractTransactionContext;
import org.mule.util.xa.ResourceManagerException;

public abstract class AbstractXAResourceManager
extends AbstractResourceManager {
    protected Map suspendedContexts = new HashMap();
    protected Map activeContexts = new HashMap();

    protected boolean includeBranchInXid() {
        return true;
    }

    protected AbstractTransactionContext getTransactionalResource(Xid xid) {
        AbstractTransactionContext context = this.getActiveTransactionalResource(xid);
        if (context != null) {
            return context;
        }
        return this.getSuspendedTransactionalResource(xid);
    }

    protected AbstractTransactionContext getActiveTransactionalResource(Xid xid) {
        return (AbstractTransactionContext)this.activeContexts.get(xid);
    }

    protected AbstractTransactionContext getSuspendedTransactionalResource(Xid xid) {
        return (AbstractTransactionContext)this.suspendedContexts.get(xid);
    }

    protected void addActiveTransactionalResource(Xid xid, AbstractTransactionContext context) {
        this.activeContexts.put(xid, context);
    }

    protected void addSuspendedTransactionalResource(Xid xid, AbstractTransactionContext context) {
        this.suspendedContexts.put(xid, context);
    }

    protected void removeActiveTransactionalResource(Xid xid) {
        this.activeContexts.remove(xid);
    }

    protected void removeSuspendedTransactionalResource(Xid xid) {
        this.suspendedContexts.remove(xid);
    }

    public class AbstractSession
    implements XAResource {
        protected AbstractTransactionContext localContext = null;
        protected Xid localXid = null;

        public XAResource getXAResource() {
            return this;
        }

        public Object getResourceManager() {
            return AbstractXAResourceManager.this;
        }

        public void begin() throws ResourceManagerException {
            if (this.localXid != null) {
                throw new IllegalStateException("Cannot start local transaction. An XA transaction is already in progress.");
            }
            if (this.localContext != null) {
                throw new IllegalStateException("Cannot start local transaction. A local transaction already in progress.");
            }
            this.localContext = AbstractXAResourceManager.this.createTransactionContext(this);
            AbstractXAResourceManager.this.beginTransaction(this.localContext);
        }

        public void commit() throws ResourceManagerException {
            if (this.localXid != null) {
                throw new IllegalStateException("Cannot commit local transaction as an XA transaction is in progress.");
            }
            if (this.localContext == null) {
                throw new IllegalStateException("Cannot commit local transaction as no transaction was begun");
            }
            AbstractXAResourceManager.this.commitTransaction(this.localContext);
            this.localContext = null;
        }

        public void rollback() throws ResourceManagerException {
            if (this.localXid != null) {
                throw new IllegalStateException("Cannot rollback local transaction as an XA transaction is in progress.");
            }
            if (this.localContext == null) {
                throw new IllegalStateException("Cannot commit local transaction as no transaction was begun");
            }
            AbstractXAResourceManager.this.rollbackTransaction(this.localContext);
            this.localContext = null;
        }

        public boolean isSameRM(XAResource xares) throws XAException {
            return xares instanceof AbstractSession && ((AbstractSession)xares).getResourceManager() == AbstractXAResourceManager.this;
        }

        public Xid[] recover(int flag) throws XAException {
            return null;
        }

        public void start(Xid xid, int flags) throws XAException {
            if (AbstractXAResourceManager.this.logger.isDebugEnabled()) {
                AbstractXAResourceManager.this.logger.debug((Object)new StringBuffer(128).append("Thread ").append(Thread.currentThread()).append(flags == 0 ? " starts" : (flags == 0x200000 ? " joins" : " resumes")).append(" work on behalf of transaction branch ").append(xid).toString());
            }
            if (this.localContext != null) {
                throw new XAException(-6);
            }
            if (this.localXid != null) {
                throw new XAException(-6);
            }
            switch (flags) {
                default: {
                    try {
                        this.localContext = AbstractXAResourceManager.this.createTransactionContext(this);
                        AbstractXAResourceManager.this.beginTransaction(this.localContext);
                        break;
                    }
                    catch (Exception e) {
                        AbstractXAResourceManager.this.logger.error((Object)"Could not create new transactional resource", (Throwable)e);
                        throw new XAException(e.getMessage());
                    }
                }
                case 0x8000000: {
                    this.localContext = AbstractXAResourceManager.this.getSuspendedTransactionalResource(xid);
                    if (this.localContext == null) {
                        throw new XAException(-4);
                    }
                    AbstractXAResourceManager.this.removeSuspendedTransactionalResource(xid);
                }
            }
            this.localXid = xid;
            AbstractXAResourceManager.this.addActiveTransactionalResource(this.localXid, this.localContext);
        }

        public void end(Xid xid, int flags) throws XAException {
            if (AbstractXAResourceManager.this.logger.isDebugEnabled()) {
                AbstractXAResourceManager.this.logger.debug((Object)new StringBuffer(128).append("Thread ").append(Thread.currentThread()).append(flags == 0x2000000 ? " suspends" : (flags == 0x20000000 ? " fails" : " ends")).append(" work on behalf of transaction branch ").append(xid).toString());
            }
            if (this.localContext == null) {
                throw new XAException(-4);
            }
            if (this.localXid == null || !this.localXid.equals(xid)) {
                throw new XAException(-6);
            }
            try {
                switch (flags) {
                    case 0x2000000: {
                        AbstractXAResourceManager.this.addSuspendedTransactionalResource(this.localXid, this.localContext);
                        AbstractXAResourceManager.this.removeActiveTransactionalResource(this.localXid);
                        break;
                    }
                    case 0x20000000: {
                        AbstractXAResourceManager.this.setTransactionRollbackOnly(this.localContext);
                        break;
                    }
                }
            }
            catch (ResourceManagerException e) {
                throw (XAException)new XAException(-3).initCause(e);
            }
            this.localXid = null;
            this.localContext = null;
        }

        public void commit(Xid xid, boolean onePhase) throws XAException {
            if (xid == null) {
                throw new XAException(-6);
            }
            AbstractTransactionContext context = AbstractXAResourceManager.this.getActiveTransactionalResource(xid);
            if (context == null) {
                throw new XAException(-4);
            }
            if (AbstractXAResourceManager.this.logger.isDebugEnabled()) {
                AbstractXAResourceManager.this.logger.debug((Object)("Committing transaction branch " + xid));
            }
            if (context.status == 1) {
                throw new XAException(100);
            }
            try {
                if (context.status != 2) {
                    if (onePhase) {
                        AbstractXAResourceManager.this.prepareTransaction(context);
                    } else {
                        throw new XAException(-6);
                    }
                }
                AbstractXAResourceManager.this.commitTransaction(context);
            }
            catch (ResourceManagerException e) {
                throw (XAException)new XAException(-3).initCause(e);
            }
            AbstractXAResourceManager.this.removeActiveTransactionalResource(xid);
            AbstractXAResourceManager.this.removeSuspendedTransactionalResource(xid);
        }

        public void rollback(Xid xid) throws XAException {
            if (xid == null) {
                throw new XAException(-6);
            }
            AbstractTransactionContext context = AbstractXAResourceManager.this.getActiveTransactionalResource(xid);
            if (context == null) {
                throw new XAException(-4);
            }
            if (AbstractXAResourceManager.this.logger.isDebugEnabled()) {
                AbstractXAResourceManager.this.logger.debug((Object)("Rolling back transaction branch " + xid));
            }
            try {
                AbstractXAResourceManager.this.rollbackTransaction(context);
            }
            catch (ResourceManagerException e) {
                throw (XAException)new XAException(-3).initCause(e);
            }
            AbstractXAResourceManager.this.removeActiveTransactionalResource(xid);
            AbstractXAResourceManager.this.removeSuspendedTransactionalResource(xid);
        }

        public int prepare(Xid xid) throws XAException {
            if (xid == null) {
                throw new XAException(-6);
            }
            AbstractTransactionContext context = AbstractXAResourceManager.this.getTransactionalResource(xid);
            if (context == null) {
                throw new XAException(-4);
            }
            if (AbstractXAResourceManager.this.logger.isDebugEnabled()) {
                AbstractXAResourceManager.this.logger.debug((Object)("Preparing transaction branch " + xid));
            }
            if (context.status == 1) {
                throw new XAException(100);
            }
            try {
                int result = AbstractXAResourceManager.this.prepareTransaction(context);
                return result;
            }
            catch (ResourceManagerException e) {
                throw (XAException)new XAException(-3).initCause(e);
            }
        }

        public void forget(Xid xid) throws XAException {
            AbstractTransactionContext context;
            if (AbstractXAResourceManager.this.logger.isDebugEnabled()) {
                AbstractXAResourceManager.this.logger.debug((Object)("Forgetting transaction branch " + xid));
            }
            if ((context = AbstractXAResourceManager.this.getTransactionalResource(xid)) == null) {
                throw new XAException(-4);
            }
            AbstractXAResourceManager.this.removeActiveTransactionalResource(xid);
            AbstractXAResourceManager.this.removeSuspendedTransactionalResource(xid);
        }

        public int getTransactionTimeout() throws XAException {
            return (int)(AbstractXAResourceManager.this.getDefaultTransactionTimeout() / 1000L);
        }

        public boolean setTransactionTimeout(int timeout) throws XAException {
            AbstractXAResourceManager.this.setDefaultTransactionTimeout(timeout * 1000);
            return false;
        }
    }
}

