/*
 * Decompiled with CFR 0.152.
 */
package org.mule.components.builder;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.components.builder.MessageBuilder;
import org.mule.impl.MuleMessage;
import org.mule.impl.UMODescriptorAware;
import org.mule.umo.UMODescriptor;
import org.mule.umo.UMOEventContext;
import org.mule.umo.UMOMessage;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.lifecycle.Callable;
import org.mule.umo.routing.UMOOutboundRouter;

public abstract class AbstractMessageBuilder
implements UMODescriptorAware,
Callable,
MessageBuilder {
    protected transient Log logger = LogFactory.getLog(this.getClass());
    protected UMODescriptor descriptor;

    public void setDescriptor(UMODescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public Object onCall(UMOEventContext eventContext) throws Exception {
        UMOMessage requestMessage = new MuleMessage(eventContext.getTransformedMessage());
        UMOMessage responseMessage = requestMessage;
        if (this.descriptor.getOutboundRouter().hasEndpoints()) {
            ArrayList endpoints = new ArrayList();
            Iterator iterator = this.descriptor.getOutboundRouter().getRouters().iterator();
            while (iterator.hasNext()) {
                UMOOutboundRouter router = (UMOOutboundRouter)iterator.next();
                endpoints.addAll(router.getEndpoints());
            }
            iterator = endpoints.iterator();
            while (iterator.hasNext()) {
                UMOEndpoint endpoint = (UMOEndpoint)iterator.next();
                boolean rsync = eventContext.getBooleanProperty("MULE_REMOTE_SYNC", endpoint.isRemoteSync());
                if (!rsync) {
                    this.logger.info((Object)("Endpoint: " + endpoint + " is not remoteSync enabled. Message builder finishing"));
                    if (eventContext.isSynchronous()) {
                        responseMessage = eventContext.sendEvent(requestMessage, endpoint);
                    } else {
                        eventContext.dispatchEvent(requestMessage, endpoint);
                        responseMessage = null;
                    }
                    break;
                }
                responseMessage = eventContext.sendEvent(requestMessage, endpoint);
                Object builtMessage = this.buildMessage(requestMessage, responseMessage);
                responseMessage = new MuleMessage(builtMessage, responseMessage.getProperties());
                requestMessage = responseMessage;
            }
        } else {
            this.logger.info((Object)("There are currently no endpoints configured on component: " + this.descriptor.getName()));
        }
        eventContext.setStopFurtherProcessing(true);
        return responseMessage;
    }
}

