/*
 * Decompiled with CFR 0.152.
 */
package org.mule.components.script.jsr223;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.Namespace;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.config.i18n.Message;
import org.mule.umo.lifecycle.Initialisable;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.lifecycle.RecoverableException;
import org.mule.util.Utility;

public class Scriptable
implements Initialisable {
    protected transient Log logger = LogFactory.getLog(this.getClass());
    private String scriptText;
    private String scriptFile;
    private Reader script;
    private CompiledScript compiledScript;
    private ScriptEngine scriptEngine;
    private String scriptEngineName;

    public void initialise() throws InitialisationException, RecoverableException {
        if (this.scriptEngine == null) {
            if (this.compiledScript == null) {
                int i;
                if (this.scriptEngineName != null) {
                    this.scriptEngine = this.createScriptEngine();
                } else if (this.scriptFile != null && (i = this.scriptFile.lastIndexOf(".")) > -1) {
                    this.setScriptEngineName(this.scriptFile.substring(i + 1));
                    this.logger.info((Object)("Script Engine name not set.  Defaulting to file extension: " + this.getScriptEngineName()));
                    this.scriptEngine = this.createScriptEngine();
                }
                if (this.scriptEngine == null) {
                    throw new InitialisationException(new Message(183, "scriptEngine, scriptEngineName, compiledScript"), (Object)this);
                }
            } else {
                this.scriptEngine = this.compiledScript.getEngine();
            }
        }
        if (this.compiledScript == null) {
            if (this.script == null) {
                if (this.scriptText == null && this.scriptFile == null) {
                    throw new InitialisationException(new Message(183, "scriptText, scriptFile"), (Object)this);
                }
                if (this.scriptText != null) {
                    this.script = new StringReader(this.scriptText);
                } else {
                    InputStream is = null;
                    try {
                        is = Utility.loadResource(this.scriptFile, this.getClass());
                        this.script = new InputStreamReader(is);
                    }
                    catch (IOException e) {
                        throw new InitialisationException(new Message(122, this.scriptFile), e, this);
                    }
                }
            }
            try {
                this.compiledScript = this.compileScript(this.script);
            }
            catch (ScriptException e) {
                throw new InitialisationException(e, (Object)this);
            }
        }
    }

    public ScriptEngine getScriptEngine() {
        return this.scriptEngine;
    }

    public void setScriptEngine(ScriptEngine scriptEngine) {
        this.scriptEngine = scriptEngine;
    }

    public CompiledScript getCompiledScript() {
        return this.compiledScript;
    }

    public void setCompiledScript(CompiledScript compiledScript) {
        this.compiledScript = compiledScript;
    }

    public String getScriptText() {
        return this.scriptText;
    }

    public void setScriptText(String scriptText) {
        this.scriptText = scriptText;
    }

    public String getScriptFile() {
        return this.scriptFile;
    }

    public void setScriptFile(String scriptFile) {
        this.scriptFile = scriptFile;
    }

    public void setScriptEngineName(String scriptEngineName) {
        this.scriptEngineName = scriptEngineName;
    }

    public String getScriptEngineName() {
        return this.scriptEngineName;
    }

    protected CompiledScript compileScript(Compilable compilable, Reader scriptReader) throws ScriptException {
        return compilable.compile(scriptReader);
    }

    protected CompiledScript compileScript(Reader scriptReader) throws ScriptException {
        if (this.scriptEngine instanceof Compilable) {
            Compilable compilable = (Compilable)((Object)this.scriptEngine);
            return this.compileScript(compilable, scriptReader);
        }
        return null;
    }

    protected CompiledScript compileScript(Compilable compilable) throws ScriptException {
        return this.compileScript(compilable, this.script);
    }

    protected Object evaluteScript(Namespace namespace) throws ScriptException {
        return this.scriptEngine.eval(this.scriptText, namespace);
    }

    public Object runScript(Namespace namespace) throws ScriptException {
        Object result = null;
        result = this.compiledScript != null ? this.compiledScript.eval(namespace) : this.evaluteScript(namespace);
        return result;
    }

    public Object runScript(CompiledScript compiledScript, Namespace namespace) throws ScriptException {
        Object result = null;
        if (compiledScript != null) {
            result = compiledScript.eval(namespace);
        }
        return result;
    }

    protected ScriptEngine createScriptEngine() {
        ScriptEngineManager manager = new ScriptEngineManager();
        return manager.getEngineByName(this.scriptEngineName);
    }
}

