/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.builders;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.digester.AbstractObjectCreationFactory;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.ObjectCreateRule;
import org.apache.commons.digester.ObjectCreationFactory;
import org.apache.commons.digester.Rule;
import org.apache.commons.digester.SetNextRule;
import org.apache.commons.digester.SetPropertiesRule;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.MuleManager;
import org.mule.config.ConfigurationBuilder;
import org.mule.config.ConfigurationException;
import org.mule.config.MuleConfiguration;
import org.mule.config.ReaderResource;
import org.mule.config.ThreadingProfile;
import org.mule.config.builders.AbstractDigesterConfiguration;
import org.mule.config.builders.ContainerReference;
import org.mule.config.builders.EndpointReference;
import org.mule.config.builders.MuleSetPropertiesRule;
import org.mule.config.builders.ObjectGetOrCreateRule;
import org.mule.config.builders.PlaceholderProcessor;
import org.mule.config.builders.TransformerReference;
import org.mule.config.converters.ConnectorConverter;
import org.mule.config.converters.EndpointConverter;
import org.mule.config.converters.EndpointURIConverter;
import org.mule.config.converters.TransactionFactoryConverter;
import org.mule.config.converters.TransformerConverter;
import org.mule.config.i18n.Message;
import org.mule.impl.MuleDescriptor;
import org.mule.impl.model.ModelFactory;
import org.mule.interceptors.InterceptorStack;
import org.mule.providers.AbstractConnector;
import org.mule.umo.UMODescriptor;
import org.mule.umo.UMOEncryptionStrategy;
import org.mule.umo.UMOInterceptor;
import org.mule.umo.UMOInterceptorStack;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.manager.ContainerException;
import org.mule.umo.manager.UMOContainerContext;
import org.mule.umo.manager.UMOManager;
import org.mule.umo.manager.UMOTransactionManagerFactory;
import org.mule.umo.model.UMOModel;
import org.mule.umo.routing.UMOOutboundRouter;
import org.mule.umo.security.UMOSecurityManager;
import org.mule.util.ClassHelper;
import org.mule.util.PropertiesHelper;
import org.mule.util.Utility;
import org.xml.sax.Attributes;

public class MuleXmlConfigurationBuilder
extends AbstractDigesterConfiguration
implements ConfigurationBuilder {
    protected static transient Log logger = LogFactory.getLog((Class)(class$org$mule$config$builders$MuleXmlConfigurationBuilder == null ? (class$org$mule$config$builders$MuleXmlConfigurationBuilder = MuleXmlConfigurationBuilder.class$("org.mule.config.builders.MuleXmlConfigurationBuilder")) : class$org$mule$config$builders$MuleXmlConfigurationBuilder));
    public static final String DEFAULT_ENTRY_POINT_RESOLVER = (class$org$mule$model$DynamicEntryPointResolver == null ? (class$org$mule$model$DynamicEntryPointResolver = MuleXmlConfigurationBuilder.class$("org.mule.model.DynamicEntryPointResolver")) : class$org$mule$model$DynamicEntryPointResolver).getName();
    public static final String DEFAULT_LIFECYCLE_ADAPTER = (class$org$mule$impl$DefaultLifecycleAdapter == null ? (class$org$mule$impl$DefaultLifecycleAdapter = MuleXmlConfigurationBuilder.class$("org.mule.impl.DefaultLifecycleAdapter")) : class$org$mule$impl$DefaultLifecycleAdapter).getName();
    public static final String DEFAULT_ENDPOINT = (class$org$mule$impl$endpoint$MuleEndpoint == null ? (class$org$mule$impl$endpoint$MuleEndpoint = MuleXmlConfigurationBuilder.class$("org.mule.impl.endpoint.MuleEndpoint")) : class$org$mule$impl$endpoint$MuleEndpoint).getName();
    public static final String DEFAULT_TRANSACTION_CONFIG = (class$org$mule$impl$MuleTransactionConfig == null ? (class$org$mule$impl$MuleTransactionConfig = MuleXmlConfigurationBuilder.class$("org.mule.impl.MuleTransactionConfig")) : class$org$mule$impl$MuleTransactionConfig).getName();
    public static final String DEFAULT_DESCRIPTOR = (class$org$mule$impl$MuleDescriptor == null ? (class$org$mule$impl$MuleDescriptor = MuleXmlConfigurationBuilder.class$("org.mule.impl.MuleDescriptor")) : class$org$mule$impl$MuleDescriptor).getName();
    public static final String DEFAULT_SECURITY_MANAGER = (class$org$mule$impl$security$MuleSecurityManager == null ? (class$org$mule$impl$security$MuleSecurityManager = MuleXmlConfigurationBuilder.class$("org.mule.impl.security.MuleSecurityManager")) : class$org$mule$impl$security$MuleSecurityManager).getName();
    public static final String DEFAULT_OUTBOUND_MESSAGE_ROUTER = (class$org$mule$routing$outbound$OutboundMessageRouter == null ? (class$org$mule$routing$outbound$OutboundMessageRouter = MuleXmlConfigurationBuilder.class$("org.mule.routing.outbound.OutboundMessageRouter")) : class$org$mule$routing$outbound$OutboundMessageRouter).getName();
    public static final String DEFAULT_INBOUND_MESSAGE_ROUTER = (class$org$mule$routing$inbound$InboundMessageRouter == null ? (class$org$mule$routing$inbound$InboundMessageRouter = MuleXmlConfigurationBuilder.class$("org.mule.routing.inbound.InboundMessageRouter")) : class$org$mule$routing$inbound$InboundMessageRouter).getName();
    public static final String DEFAULT_RESPONSE_MESSAGE_ROUTER = (class$org$mule$routing$response$ResponseMessageRouter == null ? (class$org$mule$routing$response$ResponseMessageRouter = MuleXmlConfigurationBuilder.class$("org.mule.routing.response.ResponseMessageRouter")) : class$org$mule$routing$response$ResponseMessageRouter).getName();
    public static final String DEFAULT_CATCH_ALL_STRATEGY = (class$org$mule$routing$LoggingCatchAllStrategy == null ? (class$org$mule$routing$LoggingCatchAllStrategy = MuleXmlConfigurationBuilder.class$("org.mule.routing.LoggingCatchAllStrategy")) : class$org$mule$routing$LoggingCatchAllStrategy).getName();
    public static final String DEFAULT_POOL_FACTORY = (class$org$mule$config$pool$CommonsPoolFactory == null ? (class$org$mule$config$pool$CommonsPoolFactory = MuleXmlConfigurationBuilder.class$("org.mule.config.pool.CommonsPoolFactory")) : class$org$mule$config$pool$CommonsPoolFactory).getName();
    public static final String THREADING_PROFILE = (class$org$mule$config$ThreadingProfile == null ? (class$org$mule$config$ThreadingProfile = MuleXmlConfigurationBuilder.class$("org.mule.config.ThreadingProfile")) : class$org$mule$config$ThreadingProfile).getName();
    public static final String POOLING_PROFILE = (class$org$mule$config$PoolingProfile == null ? (class$org$mule$config$PoolingProfile = MuleXmlConfigurationBuilder.class$("org.mule.config.PoolingProfile")) : class$org$mule$config$PoolingProfile).getName();
    public static final String QUEUE_PROFILE = (class$org$mule$config$QueueProfile == null ? (class$org$mule$config$QueueProfile = MuleXmlConfigurationBuilder.class$("org.mule.config.QueueProfile")) : class$org$mule$config$QueueProfile).getName();
    public static final String PERSISTENCE_STRATEGY_INTERFACE = (class$org$mule$util$queue$EventFilePersistenceStrategy == null ? (class$org$mule$util$queue$EventFilePersistenceStrategy = MuleXmlConfigurationBuilder.class$("org.mule.util.queue.EventFilePersistenceStrategy")) : class$org$mule$util$queue$EventFilePersistenceStrategy).getName();
    public static final String INBOUND_MESSAGE_ROUTER_INTERFACE = (class$org$mule$umo$routing$UMOInboundMessageRouter == null ? (class$org$mule$umo$routing$UMOInboundMessageRouter = MuleXmlConfigurationBuilder.class$("org.mule.umo.routing.UMOInboundMessageRouter")) : class$org$mule$umo$routing$UMOInboundMessageRouter).getName();
    public static final String RESPONSE_MESSAGE_ROUTER_INTERFACE = (class$org$mule$umo$routing$UMOResponseMessageRouter == null ? (class$org$mule$umo$routing$UMOResponseMessageRouter = MuleXmlConfigurationBuilder.class$("org.mule.umo.routing.UMOResponseMessageRouter")) : class$org$mule$umo$routing$UMOResponseMessageRouter).getName();
    public static final String OUTBOUND_MESSAGE_ROUTER_INTERFACE = (class$org$mule$umo$routing$UMOOutboundMessageRouter == null ? (class$org$mule$umo$routing$UMOOutboundMessageRouter = MuleXmlConfigurationBuilder.class$("org.mule.umo.routing.UMOOutboundMessageRouter")) : class$org$mule$umo$routing$UMOOutboundMessageRouter).getName();
    public static final String TRANSFORMER_INTERFACE = (class$org$mule$umo$transformer$UMOTransformer == null ? (class$org$mule$umo$transformer$UMOTransformer = MuleXmlConfigurationBuilder.class$("org.mule.umo.transformer.UMOTransformer")) : class$org$mule$umo$transformer$UMOTransformer).getName();
    public static final String TRANSACTION_MANAGER_FACTORY_INTERFACE = (class$org$mule$umo$manager$UMOTransactionManagerFactory == null ? (class$org$mule$umo$manager$UMOTransactionManagerFactory = MuleXmlConfigurationBuilder.class$("org.mule.umo.manager.UMOTransactionManagerFactory")) : class$org$mule$umo$manager$UMOTransactionManagerFactory).getName();
    public static final String SECURITY_PROVIDER_INTERFACE = (class$org$mule$umo$security$UMOSecurityProvider == null ? (class$org$mule$umo$security$UMOSecurityProvider = MuleXmlConfigurationBuilder.class$("org.mule.umo.security.UMOSecurityProvider")) : class$org$mule$umo$security$UMOSecurityProvider).getName();
    public static final String ENCRYPTION_STRATEGY_INTERFACE = (class$org$mule$umo$UMOEncryptionStrategy == null ? (class$org$mule$umo$UMOEncryptionStrategy = MuleXmlConfigurationBuilder.class$("org.mule.umo.UMOEncryptionStrategy")) : class$org$mule$umo$UMOEncryptionStrategy).getName();
    public static final String ENDPOINT_SECURITY_FILTER_INTERFACE = (class$org$mule$umo$security$UMOEndpointSecurityFilter == null ? (class$org$mule$umo$security$UMOEndpointSecurityFilter = MuleXmlConfigurationBuilder.class$("org.mule.umo.security.UMOEndpointSecurityFilter")) : class$org$mule$umo$security$UMOEndpointSecurityFilter).getName();
    public static final String AGENT_INTERFACE = (class$org$mule$umo$manager$UMOAgent == null ? (class$org$mule$umo$manager$UMOAgent = MuleXmlConfigurationBuilder.class$("org.mule.umo.manager.UMOAgent")) : class$org$mule$umo$manager$UMOAgent).getName();
    public static final String TRANSACTION_FACTORY_INTERFACE = (class$org$mule$umo$UMOTransactionFactory == null ? (class$org$mule$umo$UMOTransactionFactory = MuleXmlConfigurationBuilder.class$("org.mule.umo.UMOTransactionFactory")) : class$org$mule$umo$UMOTransactionFactory).getName();
    public static final String TRANSACTION_CONSTRAINT_INTERFACE = (class$org$mule$transaction$constraints$BatchConstraint == null ? (class$org$mule$transaction$constraints$BatchConstraint = MuleXmlConfigurationBuilder.class$("org.mule.transaction.constraints.BatchConstraint")) : class$org$mule$transaction$constraints$BatchConstraint).getName();
    public static final String CONNECTOR_INTERFACE = (class$org$mule$umo$provider$UMOConnector == null ? (class$org$mule$umo$provider$UMOConnector = MuleXmlConfigurationBuilder.class$("org.mule.umo.provider.UMOConnector")) : class$org$mule$umo$provider$UMOConnector).getName();
    public static final String INTERCEPTOR_INTERFACE = (class$org$mule$umo$UMOInterceptor == null ? (class$org$mule$umo$UMOInterceptor = MuleXmlConfigurationBuilder.class$("org.mule.umo.UMOInterceptor")) : class$org$mule$umo$UMOInterceptor).getName();
    public static final String ROUTER_INTERFACE = (class$org$mule$umo$routing$UMOOutboundRouter == null ? (class$org$mule$umo$routing$UMOOutboundRouter = MuleXmlConfigurationBuilder.class$("org.mule.umo.routing.UMOOutboundRouter")) : class$org$mule$umo$routing$UMOOutboundRouter).getName();
    public static final String EXCEPTION_STRATEGY_INTERFACE = (class$java$beans$ExceptionListener == null ? (class$java$beans$ExceptionListener = MuleXmlConfigurationBuilder.class$("java.beans.ExceptionListener")) : class$java$beans$ExceptionListener).getName();
    public static final String CONNECTION_STRATEGY_INTERFACE = (class$org$mule$providers$ConnectionStrategy == null ? (class$org$mule$providers$ConnectionStrategy = MuleXmlConfigurationBuilder.class$("org.mule.providers.ConnectionStrategy")) : class$org$mule$providers$ConnectionStrategy).getName();
    protected UMOManager manager;
    private List transformerReferences = new ArrayList();
    private List endpointReferences = new ArrayList();
    static /* synthetic */ Class class$org$mule$config$builders$MuleXmlConfigurationBuilder;
    static /* synthetic */ Class class$org$mule$model$DynamicEntryPointResolver;
    static /* synthetic */ Class class$org$mule$impl$DefaultLifecycleAdapter;
    static /* synthetic */ Class class$org$mule$impl$endpoint$MuleEndpoint;
    static /* synthetic */ Class class$org$mule$impl$MuleTransactionConfig;
    static /* synthetic */ Class class$org$mule$impl$MuleDescriptor;
    static /* synthetic */ Class class$org$mule$impl$security$MuleSecurityManager;
    static /* synthetic */ Class class$org$mule$routing$outbound$OutboundMessageRouter;
    static /* synthetic */ Class class$org$mule$routing$inbound$InboundMessageRouter;
    static /* synthetic */ Class class$org$mule$routing$response$ResponseMessageRouter;
    static /* synthetic */ Class class$org$mule$routing$LoggingCatchAllStrategy;
    static /* synthetic */ Class class$org$mule$config$pool$CommonsPoolFactory;
    static /* synthetic */ Class class$org$mule$config$ThreadingProfile;
    static /* synthetic */ Class class$org$mule$config$PoolingProfile;
    static /* synthetic */ Class class$org$mule$config$QueueProfile;
    static /* synthetic */ Class class$org$mule$util$queue$EventFilePersistenceStrategy;
    static /* synthetic */ Class class$org$mule$umo$routing$UMOInboundMessageRouter;
    static /* synthetic */ Class class$org$mule$umo$routing$UMOResponseMessageRouter;
    static /* synthetic */ Class class$org$mule$umo$routing$UMOOutboundMessageRouter;
    static /* synthetic */ Class class$org$mule$umo$transformer$UMOTransformer;
    static /* synthetic */ Class class$org$mule$umo$manager$UMOTransactionManagerFactory;
    static /* synthetic */ Class class$org$mule$umo$security$UMOSecurityProvider;
    static /* synthetic */ Class class$org$mule$umo$UMOEncryptionStrategy;
    static /* synthetic */ Class class$org$mule$umo$security$UMOEndpointSecurityFilter;
    static /* synthetic */ Class class$org$mule$umo$manager$UMOAgent;
    static /* synthetic */ Class class$org$mule$umo$UMOTransactionFactory;
    static /* synthetic */ Class class$org$mule$transaction$constraints$BatchConstraint;
    static /* synthetic */ Class class$org$mule$umo$provider$UMOConnector;
    static /* synthetic */ Class class$org$mule$umo$UMOInterceptor;
    static /* synthetic */ Class class$org$mule$umo$routing$UMOOutboundRouter;
    static /* synthetic */ Class class$java$beans$ExceptionListener;
    static /* synthetic */ Class class$org$mule$providers$ConnectionStrategy;
    static /* synthetic */ Class class$org$mule$umo$endpoint$UMOEndpoint;
    static /* synthetic */ Class class$org$mule$umo$endpoint$UMOEndpointURI;
    static /* synthetic */ Class class$org$mule$config$MuleConfiguration;

    public MuleXmlConfigurationBuilder() throws ConfigurationException {
        super(System.getProperty("org.mule.xml.validate", "true").equalsIgnoreCase("true"), System.getProperty("org.mule.xml.dtd", "mule-configuration.dtd"));
        ConvertUtils.register((Converter)new EndpointConverter(), (Class)(class$org$mule$umo$endpoint$UMOEndpoint == null ? (class$org$mule$umo$endpoint$UMOEndpoint = MuleXmlConfigurationBuilder.class$("org.mule.umo.endpoint.UMOEndpoint")) : class$org$mule$umo$endpoint$UMOEndpoint));
        ConvertUtils.register((Converter)new TransformerConverter(), (Class)(class$org$mule$umo$transformer$UMOTransformer == null ? (class$org$mule$umo$transformer$UMOTransformer = MuleXmlConfigurationBuilder.class$("org.mule.umo.transformer.UMOTransformer")) : class$org$mule$umo$transformer$UMOTransformer));
        ConvertUtils.register((Converter)new ConnectorConverter(), (Class)(class$org$mule$umo$provider$UMOConnector == null ? (class$org$mule$umo$provider$UMOConnector = MuleXmlConfigurationBuilder.class$("org.mule.umo.provider.UMOConnector")) : class$org$mule$umo$provider$UMOConnector));
        ConvertUtils.register((Converter)new TransactionFactoryConverter(), (Class)(class$org$mule$umo$UMOTransactionFactory == null ? (class$org$mule$umo$UMOTransactionFactory = MuleXmlConfigurationBuilder.class$("org.mule.umo.UMOTransactionFactory")) : class$org$mule$umo$UMOTransactionFactory));
        ConvertUtils.register((Converter)new EndpointURIConverter(), (Class)(class$org$mule$umo$endpoint$UMOEndpointURI == null ? (class$org$mule$umo$endpoint$UMOEndpointURI = MuleXmlConfigurationBuilder.class$("org.mule.umo.endpoint.UMOEndpointURI")) : class$org$mule$umo$endpoint$UMOEndpointURI));
        String path = this.getRootName();
        this.addManagerRules(this.digester, path);
        this.addServerPropertiesRules(path + "/environment-properties", "addProperties", 0);
        this.addContainerContextRules(path + "/container-context", "setContainerContext", 0);
        this.addMuleConfigurationRules(this.digester, path);
        this.addTransformerRules(this.digester, path);
        this.addSecurityManagerRules(this.digester, path);
        this.addTransactionManagerRules(this.digester, path);
        this.addGlobalEndpointRules(this.digester, path);
        this.addEndpointIdentifierRules(this.digester, path);
        this.addInterceptorStackRules(this.digester, path);
        this.addConnectorRules(this.digester, path);
        this.addAgentRules(this.digester, path);
        this.addModelRules(this.digester, path);
        this.addMuleDescriptorRules(this.digester, path);
    }

    public String getRootName() {
        return "mule-configuration";
    }

    public UMOManager configure(String configResources) throws ConfigurationException {
        try {
            String[] resources = Utility.split(configResources, ",");
            MuleManager.getConfiguration().setConfigResources(resources);
            ReaderResource[] readers = new ReaderResource[resources.length];
            for (int i = 0; i < resources.length; ++i) {
                InputStream is = this.loadConfig(resources[i].trim());
                readers[i] = new ReaderResource(resources[i].trim(), new InputStreamReader(is, this.configEncoding));
            }
            return this.configure(readers);
        }
        catch (Exception e) {
            throw new ConfigurationException(e);
        }
    }

    public UMOManager configure(ReaderResource[] configResources) throws ConfigurationException {
        this.manager = (MuleManager)this.process(configResources);
        try {
            this.setContainerProperties();
            this.setTransformers();
            this.setGlobalEndpoints();
            this.manager.start();
        }
        catch (Exception e) {
            throw new ConfigurationException(new Message(40, "MuleManager"), (Throwable)e);
        }
        return this.manager;
    }

    public boolean isConfigured() {
        return this.manager != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setContainerProperties() throws ContainerException {
        UMOContainerContext ctx = this.manager.getContainerContext();
        try {
            Iterator iterator = this.containerReferences.iterator();
            while (iterator.hasNext()) {
                ContainerReference reference = (ContainerReference)iterator.next();
                reference.resolveReference(ctx);
            }
        }
        finally {
            this.containerReferences.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setTransformers() throws InitialisationException {
        try {
            Iterator iterator = this.transformerReferences.iterator();
            while (iterator.hasNext()) {
                TransformerReference reference = (TransformerReference)iterator.next();
                reference.resolveTransformer();
            }
        }
        finally {
            this.transformerReferences.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setGlobalEndpoints() throws InitialisationException {
        Map endpoints = MuleManager.getInstance().getEndpoints();
        Iterator<Object> iterator = endpoints.values().iterator();
        while (iterator.hasNext()) {
            UMOEndpoint ep = (UMOEndpoint)iterator.next();
            ep.initialise();
            MuleManager.getInstance().unregisterEndpoint(ep.getName());
            MuleManager.getInstance().registerEndpoint(ep);
        }
        try {
            iterator = this.endpointReferences.iterator();
            while (iterator.hasNext()) {
                EndpointReference reference = (EndpointReference)iterator.next();
                reference.resolveEndpoint();
            }
        }
        finally {
            this.endpointReferences.clear();
        }
    }

    protected void addManagerRules(Digester digester, String path) {
        digester.addFactoryCreate(path, (ObjectCreationFactory)new AbstractObjectCreationFactory(){

            public Object createObject(Attributes attributes) throws Exception {
                MuleXmlConfigurationBuilder.this.manager = MuleManager.getInstance();
                return MuleXmlConfigurationBuilder.this.manager;
            }
        });
        digester.addSetProperties(path);
    }

    protected void addMuleConfigurationRules(Digester digester, String path) {
        digester.addSetProperties(path);
        path = path + "/mule-environment-properties";
        digester.addObjectCreate(path, class$org$mule$config$MuleConfiguration == null ? (class$org$mule$config$MuleConfiguration = MuleXmlConfigurationBuilder.class$("org.mule.config.MuleConfiguration")) : class$org$mule$config$MuleConfiguration);
        this.addSetPropertiesRule(path, digester);
        this.addPoolingProfileRules(digester, path);
        this.addQueueProfileRules(digester, path);
        digester.addObjectCreate(path + "/threading-profile", THREADING_PROFILE);
        SetPropertiesRule threadingRule = new SetPropertiesRule();
        threadingRule.addAlias("setPoolExhaustedAction", "setPoolExhaustedActionString");
        digester.addRule(path + "/threading-profile", (Rule)threadingRule);
        digester.addRule(path + "/threading-profile", new Rule(){
            private String id;

            public void begin(String s, String s1, Attributes attributes) throws Exception {
                this.id = attributes.getValue("id");
            }

            public void end(String s, String s1) throws Exception {
                ThreadingProfile tp = (ThreadingProfile)this.digester.peek();
                MuleConfiguration cfg = (MuleConfiguration)this.digester.peek(1);
                if ("default".equals(this.id)) {
                    cfg.setDefaultThreadingProfile(tp);
                    cfg.setMessageDispatcherThreadingProfile(tp);
                    cfg.setMessageReceiverThreadingProfile(tp);
                    cfg.setComponentThreadingProfile(tp);
                } else if ("messageReceiver".equals(this.id) || "receiver".equals(this.id)) {
                    cfg.setMessageReceiverThreadingProfile(tp);
                } else if ("messageDispatcher".equals(this.id) || "dispatcher".equals(this.id)) {
                    cfg.setMessageDispatcherThreadingProfile(tp);
                } else if ("component".equals(this.id)) {
                    cfg.setComponentThreadingProfile(tp);
                }
            }
        });
        digester.addObjectCreate(path + "/persistence-strategy", PERSISTENCE_STRATEGY_INTERFACE, "className");
        this.addMulePropertiesRule(path + "/persistence-strategy", digester);
        digester.addSetNext(path + "/persistence-strategy", "setPersistenceStrategy");
        digester.addObjectCreate(path + "/connection-strategy", CONNECTION_STRATEGY_INTERFACE, "className");
        this.addMulePropertiesRule(path + "/connection-strategy", digester);
        digester.addRule(path + "/connection-strategy", (Rule)new SetNextRule("setConnectionStrategy"){

            public void end(String s, String s1) throws Exception {
                super.end(s, s1);
            }
        });
        digester.addRule(path, new Rule(){

            public void end(String s, String s1) throws Exception {
                MuleManager.setConfiguration((MuleConfiguration)this.digester.peek());
            }
        });
    }

    protected void addSecurityManagerRules(Digester digester, String path) throws ConfigurationException {
        path = path + "/security-manager";
        this.addObjectCreateOrGetFromContainer(path, DEFAULT_SECURITY_MANAGER, "className", "ref", false);
        digester.addObjectCreate(path + "/security-provider", SECURITY_PROVIDER_INTERFACE, "className");
        this.addSetPropertiesRule(path + "/security-provider", digester);
        this.addMulePropertiesRule(path + "/security-provider", digester);
        digester.addSetNext(path + "/security-provider", "addProvider");
        digester.addObjectCreate(path + "/encryption-strategy", ENCRYPTION_STRATEGY_INTERFACE, "className");
        this.addSetPropertiesRule(path + "/encryption-strategy", digester);
        this.addMulePropertiesRule(path + "/encryption-strategy", digester);
        digester.addRule(path + "/encryption-strategy", new Rule(){
            private String name;

            public void begin(String endpointName, String endpointName1, Attributes attributes) throws Exception {
                this.name = attributes.getValue("name");
            }

            public void end(String endpointName, String endpointName1) throws Exception {
                UMOEncryptionStrategy s = (UMOEncryptionStrategy)this.digester.peek();
                ((UMOSecurityManager)this.digester.peek(1)).addEncryptionStrategy(this.name, s);
            }
        });
        digester.addSetNext(path, "setSecurityManager");
    }

    protected void addTransformerRules(Digester digester, String path) throws ConfigurationException {
        path = path + "/transformers/transformer";
        this.addObjectCreateOrGetFromContainer(path, TRANSFORMER_INTERFACE, "className", "ref", true);
        this.addSetPropertiesRule(path, digester);
        this.addMulePropertiesRule(path, digester);
        digester.addSetRoot(path, "registerTransformer");
    }

    protected void addGlobalEndpointRules(Digester digester, String path) throws ConfigurationException {
        path = path + "/global-endpoints";
        this.addEndpointRules(digester, path, "registerEndpoint");
    }

    protected void addEndpointIdentifierRules(Digester digester, String path) throws ConfigurationException {
        path = path + "/endpoint-identifiers/endpoint-identifier";
        digester.addCallMethod(path, "registerEndpointIdentifier", 2);
        digester.addCallParam(path, 0, "name");
        digester.addCallParam(path, 1, "value");
    }

    protected void addTransactionManagerRules(Digester digester, String path) throws ConfigurationException {
        path = path + "/transaction-manager";
        this.addObjectCreateOrGetFromContainer(path, TRANSACTION_MANAGER_FACTORY_INTERFACE, "factory", "ref", true);
        this.addMulePropertiesRule(path, digester);
        digester.addSetRoot(path, "setTransactionManager");
        digester.addRule(path, new Rule(){

            public void end(String s, String s1) throws Exception {
                UMOTransactionManagerFactory txFactory = (UMOTransactionManagerFactory)this.digester.pop();
                this.digester.push((Object)txFactory.create());
            }
        });
    }

    protected void addAgentRules(Digester digester, String path) throws ConfigurationException {
        path = path + "/agents/agent";
        this.addObjectCreateOrGetFromContainer(path, AGENT_INTERFACE, "className", "ref", true);
        this.addSetPropertiesRule(path, digester);
        this.addMulePropertiesRule(path, digester);
        digester.addSetRoot(path, "registerAgent");
    }

    protected void addConnectorRules(Digester digester, String path) throws ConfigurationException {
        path = path + "/connector";
        this.addObjectCreateOrGetFromContainer(path, CONNECTOR_INTERFACE, "className", "ref", true);
        this.addSetPropertiesRule(path, digester);
        this.addMulePropertiesRule(path, digester);
        digester.addRule(path + "/threading-profile", new Rule(){
            private String id;

            public void begin(String s, String s1, Attributes attributes) throws Exception {
                MuleConfiguration cfg = MuleManager.getConfiguration();
                this.id = attributes.getValue("id");
                if ("default".equals(this.id)) {
                    this.digester.push((Object)cfg.getDefaultThreadingProfile());
                } else if ("receiver".equals(this.id)) {
                    this.digester.push((Object)cfg.getMessageReceiverThreadingProfile());
                } else if ("dispatcher".equals(this.id)) {
                    this.digester.push((Object)cfg.getMessageDispatcherThreadingProfile());
                }
            }

            public void end(String s, String s1) throws Exception {
                ThreadingProfile tp = (ThreadingProfile)this.digester.pop();
                AbstractConnector cnn = (AbstractConnector)this.digester.peek();
                if ("default".equals(this.id)) {
                    cnn.setReceiverThreadingProfile(tp);
                    cnn.setDispatcherThreadingProfile(tp);
                } else if ("receiver".equals(this.id)) {
                    cnn.setReceiverThreadingProfile(tp);
                } else if ("dispatcher".equals(this.id)) {
                    cnn.setDispatcherThreadingProfile(tp);
                }
            }
        });
        SetPropertiesRule threadingRule = new SetPropertiesRule();
        threadingRule.addAlias("setPoolExhaustedAction", "setPoolExhaustedActionString");
        digester.addRule(path + "/threading-profile", (Rule)threadingRule);
        digester.addObjectCreate(path + "/connection-strategy", CONNECTION_STRATEGY_INTERFACE, "className");
        this.addMulePropertiesRule(path + "/connection-strategy", digester);
        digester.addSetNext(path + "/connection-strategy", "setConnectionStrategy");
        this.addExceptionStrategyRules(digester, path);
        digester.addSetRoot(path, "registerConnector");
    }

    protected void addInterceptorStackRules(Digester digester, String path) throws ConfigurationException {
        path = path + "/interceptor-stack";
        digester.addRule(path + "/interceptor", (Rule)new ObjectCreateRule(INTERCEPTOR_INTERFACE, "className"){

            public void end(String s, String s1) throws Exception {
            }
        });
        digester.addRule(path, new Rule(){

            public void begin(String s, String s1, Attributes attributes) throws Exception {
                this.digester.push((Object)attributes.getValue("name"));
            }

            public void end(String s, String s1) throws Exception {
                ArrayList<Object> list = new ArrayList<Object>();
                Object obj = this.digester.peek();
                while (obj instanceof UMOInterceptor) {
                    list.add(0, this.digester.pop());
                    obj = this.digester.peek();
                }
                InterceptorStack stack = new InterceptorStack();
                stack.setInterceptors(list);
                MuleXmlConfigurationBuilder.this.manager.registerInterceptorStack(this.digester.pop().toString(), stack);
            }
        });
    }

    protected void addModelRules(Digester digester, String path) throws ConfigurationException {
        path = path + "/model";
        digester.addRule(path, new Rule(){

            public void begin(String string, String string1, Attributes attributes) throws Exception {
                String modelType = attributes.getValue("type");
                if (modelType == null) {
                    modelType = MuleManager.getConfiguration().getModelType();
                }
                UMOModel model = null;
                if (modelType.equalsIgnoreCase("custom")) {
                    String className = attributes.getValue("className");
                    if (className == null) {
                        throw new IllegalArgumentException("Cannot use 'custom' model type without setting the 'className' for the model");
                    }
                    model = (UMOModel)ClassHelper.instanciateClass(className, ClassHelper.NO_ARGS, ((Object)((Object)this)).getClass());
                } else {
                    model = ModelFactory.createModel(modelType);
                }
                this.digester.push((Object)model);
            }
        });
        this.addSetPropertiesRule(path, digester);
        digester.addSetRoot(path, "setModel");
        digester.addObjectCreate(path + "/entry-point-resolver", DEFAULT_ENTRY_POINT_RESOLVER, "className");
        this.addSetPropertiesRule(path + "/entry-point-resolver", digester);
        digester.addSetNext(path + "/entry-point-resolver", "setEntryPointResolver");
        digester.addObjectCreate(path + "/component-lifecycle-adapter-factory", DEFAULT_LIFECYCLE_ADAPTER, "className");
        this.addSetPropertiesRule(path, digester);
        digester.addSetNext(path + "/component-lifecycle-adapter-factory", "setLifecycleAdapterFactory");
        this.addPoolingProfileRules(digester, path);
        this.addExceptionStrategyRules(digester, path);
        this.addMuleDescriptorRules(digester, path);
    }

    protected void addMuleDescriptorRules(Digester digester, String path) throws ConfigurationException {
        path = path + "/mule-descriptor";
        this.addObjectCreateOrGetFromContainer(path, DEFAULT_DESCRIPTOR, "className", "ref", false);
        this.addSetPropertiesRule(path, digester);
        this.addMessageRouterRules(digester, path, "inbound");
        this.addMessageRouterRules(digester, path, "outbound");
        this.addMessageRouterRules(digester, path, "response");
        this.addThreadingProfileRules(digester, path, "component");
        this.addPoolingProfileRules(digester, path);
        this.addQueueProfileRules(digester, path);
        digester.addRule(path + "/interceptor", new Rule(){

            public void begin(String string, String string1, Attributes attributes) throws Exception {
                String value = attributes.getValue("name");
                if (value == null) {
                    value = attributes.getValue("className");
                }
                UMOManager man = (UMOManager)this.digester.getRoot();
                UMOInterceptorStack interceptorStack = man.lookupInterceptorStack(value);
                MuleDescriptor temp = (MuleDescriptor)this.digester.peek();
                if (interceptorStack != null) {
                    temp.addInterceptor(interceptorStack);
                } else {
                    Class<?> clazz = this.digester.getClassLoader().loadClass(value);
                    Object instance = clazz.newInstance();
                    temp.addInterceptor((UMOInterceptor)instance);
                    this.digester.push(instance);
                }
            }

            public void end(String s, String s1) throws Exception {
                if (this.digester.peek() instanceof UMOInterceptor) {
                    this.digester.pop();
                }
            }
        });
        this.addMulePropertiesRule(path + "/interceptor", digester);
        this.addExceptionStrategyRules(digester, path);
        this.addMulePropertiesRule(path, digester, "setProperties");
        digester.addSetNext(path + "/properties", "setProperties");
        digester.addRule(path, new Rule(){

            public void end(String s, String s1) throws Exception {
                UMODescriptor descriptor = (UMODescriptor)this.digester.peek();
                Object obj = this.digester.peek(1);
                UMOModel model = obj instanceof UMOManager ? ((UMOManager)obj).getModel() : (UMOModel)obj;
                model.registerComponent(descriptor);
            }
        });
    }

    protected void addThreadingProfileRules(Digester digester, String path, final String type) {
        digester.addRule(path + "/threading-profile", new Rule(){

            public void begin(String s, String s1, Attributes attributes) throws Exception {
                MuleConfiguration cfg = MuleManager.getConfiguration();
                if ("component".equals(type)) {
                    this.digester.push((Object)cfg.getComponentThreadingProfile());
                } else if ("messageReceiver".equals(type)) {
                    this.digester.push((Object)cfg.getComponentThreadingProfile());
                } else if ("messageDispatcher".equals(type)) {
                    this.digester.push((Object)cfg.getComponentThreadingProfile());
                } else {
                    this.digester.push((Object)cfg.getDefaultThreadingProfile());
                }
            }

            public void end(String s, String s1) throws Exception {
                this.digester.pop();
            }
        });
        SetPropertiesRule threadingRule = new SetPropertiesRule();
        threadingRule.addAlias("setPoolExhaustedAction", "setPoolExhaustedActionString");
        digester.addRule(path + "/threading-profile", (Rule)threadingRule);
        digester.addSetNext(path + "/threading-profile", "setThreadingProfile");
    }

    protected void addPoolingProfileRules(Digester digester, String path) {
        digester.addRule(path + "/pooling-profile", new Rule(){

            public void begin(String s, String s1, Attributes attributes) throws Exception {
                MuleConfiguration cfg = MuleManager.getConfiguration();
                this.digester.push((Object)cfg.getPoolingProfile());
            }

            public void end(String s, String s1) throws Exception {
                this.digester.pop();
            }
        });
        SetPropertiesRule rule = new SetPropertiesRule();
        rule.addAlias("exhaustedAction", "exhaustedActionString");
        rule.addAlias("initialisationPolicy", "initialisationPolicyString");
        digester.addRule(path + "/pooling-profile", (Rule)rule);
        digester.addSetNext(path + "/pooling-profile", "setPoolingProfile");
    }

    protected void addQueueProfileRules(Digester digester, String path) {
        digester.addObjectCreate(path + "/queue-profile", QUEUE_PROFILE);
        this.addSetPropertiesRule(path + "/queue-profile", digester);
        digester.addSetNext(path + "/queue-profile", "setQueueProfile");
    }

    protected void addMessageRouterRules(Digester digester, String path, String type) throws ConfigurationException {
        String defaultRouter = null;
        String setMethod = null;
        if ("inbound".equals(type)) {
            defaultRouter = DEFAULT_INBOUND_MESSAGE_ROUTER;
            setMethod = "setInboundRouter";
            path = path + "/inbound-router";
            this.addEndpointRules(digester, path, "addEndpoint");
            this.addGlobalReferenceEndpointRules(digester, path, "addEndpoint");
        } else if ("response".equals(type)) {
            defaultRouter = DEFAULT_RESPONSE_MESSAGE_ROUTER;
            setMethod = "setResponseRouter";
            path = path + "/response-router";
            this.addEndpointRules(digester, path, "addEndpoint");
            this.addGlobalReferenceEndpointRules(digester, path, "addEndpoint");
        } else {
            defaultRouter = DEFAULT_OUTBOUND_MESSAGE_ROUTER;
            setMethod = "setOutboundRouter";
            path = path + "/outbound-router";
        }
        digester.addObjectCreate(path, defaultRouter, "className");
        this.addSetPropertiesRule(path, digester);
        digester.addObjectCreate(path + "/catch-all-strategy", DEFAULT_CATCH_ALL_STRATEGY, "className");
        this.addSetPropertiesRule(path + "/catch-all-strategy", digester);
        this.addEndpointRules(digester, path + "/catch-all-strategy", "setEndpoint");
        this.addGlobalReferenceEndpointRules(digester, path + "/catch-all-strategy", "setEndpoint");
        this.addMulePropertiesRule(path + "/catch-all-strategy", digester);
        digester.addSetNext(path + "/catch-all-strategy", "setCatchAllStrategy");
        this.addRouterRules(digester, path, type);
        digester.addSetNext(path, setMethod);
    }

    protected void addRouterRules(Digester digester, String path, String type) throws ConfigurationException {
        path = path + "/router";
        if ("inbound".equals(type)) {
            digester.addObjectCreate(path, INBOUND_MESSAGE_ROUTER_INTERFACE, "className");
        } else if ("response".equals(type)) {
            digester.addObjectCreate(path, RESPONSE_MESSAGE_ROUTER_INTERFACE, "className");
        } else {
            digester.addObjectCreate(path, OUTBOUND_MESSAGE_ROUTER_INTERFACE, "className");
        }
        this.addSetPropertiesRule(path, digester, new String[]{"enableCorrelation"}, new String[]{"enableCorrelationAsString"});
        this.addMulePropertiesRule(path, digester);
        if ("outbound".equals(type)) {
            this.addEndpointRules(digester, path, "addEndpoint");
            this.addReplyToRules(digester, path);
            this.addGlobalReferenceEndpointRules(digester, path, "addEndpoint");
            this.addTransactionConfigRules(path, digester);
        }
        this.addFilterRules(digester, path);
        digester.addSetNext(path, "addRouter");
    }

    protected void addReplyToRules(Digester digester, String path) throws ConfigurationException {
        path = path + "/reply-to";
        digester.addRule(path, new Rule(){

            public void begin(String s, String s1, Attributes attributes) throws Exception {
                String replyTo = attributes.getValue("address");
                ((UMOOutboundRouter)this.digester.peek()).setReplyTo(replyTo);
            }
        });
    }

    protected void addEndpointRules(Digester digester, String path, String method) throws ConfigurationException {
        path = path + "/endpoint";
        this.addObjectCreateOrGetFromContainer(path, DEFAULT_ENDPOINT, "className", "ref", false);
        this.addCommonEndpointRules(digester, path, method);
    }

    protected void addGlobalReferenceEndpointRules(Digester digester, String path, final String method) throws ConfigurationException {
        path = path + "/global-endpoint";
        digester.addRule(path, new Rule(){

            public void begin(String s, String s1, Attributes attributes) throws Exception {
                String name = attributes.getValue("name");
                String address = attributes.getValue("address");
                String trans = attributes.getValue("transformers");
                String responseTrans = attributes.getValue("responseTransformers");
                String createConnector = attributes.getValue("createConnector");
                EndpointReference ref = new EndpointReference(method, name, address, trans, responseTrans, createConnector, this.digester.peek());
                this.digester.push((Object)ref);
            }

            public void end(String endpointName, String endpointName1) throws Exception {
                MuleXmlConfigurationBuilder.this.endpointReferences.add(this.digester.pop());
            }
        });
        this.addCommonEndpointRules(digester, path, null);
    }

    protected void addCommonEndpointRules(Digester digester, String path, String method) throws ConfigurationException {
        this.addSetPropertiesRule(path, digester, new String[]{"address", "transformers", "responseTransformers", "createConnector"}, new String[]{"endpointURI", "transformer", "responseTransformer", "createConnectorAsString"});
        this.addMulePropertiesRule(path, digester, "setProperties");
        this.addTransactionConfigRules(path, digester);
        this.addFilterRules(digester, path);
        if (method != null) {
            digester.addSetNext(path, method);
        }
        digester.addObjectCreate(path + "/security-filter", ENDPOINT_SECURITY_FILTER_INTERFACE, "className");
        this.addMulePropertiesRule(path + "/security-filter", digester);
        digester.addSetNext(path + "/security-filter", "setSecurityFilter");
    }

    protected void addTransactionConfigRules(String path, Digester digester) {
        digester.addObjectCreate(path + "/transaction", DEFAULT_TRANSACTION_CONFIG);
        this.addSetPropertiesRule(path + "/transaction", digester, new String[]{"action"}, new String[]{"actionAsString"});
        digester.addObjectCreate(path + "/transaction/constraint", TRANSACTION_CONSTRAINT_INTERFACE, "className");
        this.addSetPropertiesRule(path + "/transaction/constraint", digester);
        digester.addSetNext(path + "/transaction/constraint", "setConstraint");
        digester.addSetNext(path + "/transaction", "setTransactionConfig");
    }

    protected void addExceptionStrategyRules(Digester digester, String path) throws ConfigurationException {
        path = path + "/exception-strategy";
        digester.addObjectCreate(path, EXCEPTION_STRATEGY_INTERFACE, "className");
        this.addMulePropertiesRule(path, digester);
        this.addEndpointRules(digester, path, "addEndpoint");
        this.addGlobalReferenceEndpointRules(digester, path, "addEndpoint");
        digester.addSetNext(path, "setExceptionListener");
    }

    private void addContainerReference(String propName, String containerRef, Object object, boolean required, String container) {
        this.containerReferences.add(new ContainerReference(propName, containerRef, object, required, container));
    }

    protected void addSetPropertiesRule(String path, Digester digester, String[] s1, String[] s2) {
        digester.addRule(path, (Rule)new ExtendedMuleSetPropertiesRule(s1, s2));
    }

    protected void addSetPropertiesRule(String path, Digester digester) {
        digester.addRule(path, (Rule)new ExtendedMuleSetPropertiesRule());
    }

    private void addTransformerReference(String propName, String transName, Object object) {
        this.transformerReferences.add(new TransformerReference(propName, transName, object));
    }

    private void addEndpointReference(String propName, String endpointName, Object object) {
        this.endpointReferences.add(new EndpointReference(propName, endpointName, null, null, null, null, object));
    }

    protected void addObjectCreateOrGetFromContainer(String path, String defaultImpl, String classAttrib, String refAttrib, boolean classRefRequired) {
        this.digester.addRule(path, (Rule)new ObjectGetOrCreateRule(defaultImpl, classAttrib, refAttrib, classAttrib, classRefRequired, "getContainerContext"));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class ExtendedMuleSetPropertiesRule
    extends MuleSetPropertiesRule {
        public ExtendedMuleSetPropertiesRule() {
        }

        public ExtendedMuleSetPropertiesRule(PlaceholderProcessor processor) {
            super(processor);
        }

        public ExtendedMuleSetPropertiesRule(String[] strings, String[] strings1) {
            super(strings, strings1);
        }

        public ExtendedMuleSetPropertiesRule(String[] strings, String[] strings1, PlaceholderProcessor processor) {
            super(strings, strings1, processor);
        }

        public void begin(String s1, String s2, Attributes attributes) throws Exception {
            Object o;
            String endpoint;
            String transformerNames = (attributes = this.processor.processAttributes(attributes, s2)).getValue("transformer");
            if (transformerNames != null) {
                MuleXmlConfigurationBuilder.this.addTransformerReference("transformer", transformerNames, this.digester.peek());
            }
            if ((transformerNames = attributes.getValue("transformers")) != null) {
                MuleXmlConfigurationBuilder.this.addTransformerReference("transformer", transformerNames, this.digester.peek());
            }
            if ((transformerNames = attributes.getValue("responseTransformers")) != null) {
                MuleXmlConfigurationBuilder.this.addTransformerReference("responseTransformer", transformerNames, this.digester.peek());
            }
            if ((transformerNames = attributes.getValue("responseTransformer")) != null) {
                MuleXmlConfigurationBuilder.this.addTransformerReference("responseTransformer", transformerNames, this.digester.peek());
            }
            if ((transformerNames = attributes.getValue("inboundTransformer")) != null) {
                MuleXmlConfigurationBuilder.this.addTransformerReference("inboundTransformer", transformerNames, this.digester.peek());
            }
            if ((transformerNames = attributes.getValue("outboundTransformer")) != null) {
                MuleXmlConfigurationBuilder.this.addTransformerReference("outboundTransformer", transformerNames, this.digester.peek());
            }
            if ((transformerNames = attributes.getValue("responseTransformer")) != null) {
                MuleXmlConfigurationBuilder.this.addTransformerReference("responseTransformer", transformerNames, this.digester.peek());
            }
            if ((endpoint = attributes.getValue("inboundEndpoint")) != null && (o = PropertiesHelper.getProperty(MuleXmlConfigurationBuilder.this.manager.getEndpoints(), endpoint, null)) != null) {
                MuleXmlConfigurationBuilder.this.addEndpointReference("setInboundEndpoint", endpoint, this.digester.peek());
            }
            if ((endpoint = attributes.getValue("outboundEndpoint")) != null && (o = PropertiesHelper.getProperty(MuleXmlConfigurationBuilder.this.manager.getEndpoints(), endpoint, null)) != null) {
                MuleXmlConfigurationBuilder.this.addEndpointReference("setOutboundEndpoint", endpoint, this.digester.peek());
            }
            super.begin(attributes);
        }
    }
}

