/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.pool;

import org.mule.MuleManager;
import org.mule.config.i18n.Message;
import org.mule.impl.MuleDescriptor;
import org.mule.impl.model.DefaultMuleProxy;
import org.mule.umo.UMOException;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.manager.UMOManager;
import org.mule.util.ClassHelper;
import org.mule.util.ObjectFactory;
import org.mule.util.ObjectPool;

public abstract class AbstractProxyFactory
implements ObjectFactory {
    protected MuleDescriptor descriptor;
    protected ObjectPool pool;

    public AbstractProxyFactory(MuleDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public Object create() throws UMOException {
        UMOManager manager = MuleManager.getInstance();
        Object impl = this.descriptor.getImplementation();
        Object component = null;
        if (impl instanceof String) {
            String reference = impl.toString();
            if (reference.startsWith("local:")) {
                String refName = reference.substring("local:".length());
                component = this.descriptor.getProperties().get(refName);
                if (component == null) {
                    throw new InitialisationException(new Message(91, refName, (Object)this.descriptor.getName()), (Object)this);
                }
            }
            if (component == null) {
                if (this.descriptor.isContainerManaged()) {
                    component = manager.getContainerContext().getComponent(reference);
                } else {
                    try {
                        component = ClassHelper.instanciateClass(reference, new Object[0]);
                    }
                    catch (Exception e) {
                        throw new InitialisationException(new Message(92, reference), e, this.descriptor);
                    }
                }
            }
        } else {
            component = impl;
        }
        if (this.descriptor.isSingleton()) {
            this.descriptor.setImplementation(component);
        }
        this.descriptor.fireInitialisationCallbacks(component);
        this.afterComponentCreate(component);
        return this.createProxy(component);
    }

    protected Object createProxy(Object component) throws UMOException {
        return new DefaultMuleProxy(component, this.descriptor, this.pool);
    }

    protected void afterComponentCreate(Object component) throws InitialisationException {
    }

    public ObjectPool getPool() {
        return this.pool;
    }

    public void setPool(ObjectPool pool) {
        this.pool = pool;
    }
}

