/*
 * Decompiled with CFR 0.152.
 */
package org.mule.impl;

import edu.emory.mathcs.backport.java.util.concurrent.CopyOnWriteArrayList;
import java.beans.ExceptionListener;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.config.ExceptionHelper;
import org.mule.impl.MuleMessage;
import org.mule.impl.RequestContext;
import org.mule.impl.message.ExceptionMessage;
import org.mule.transaction.TransactionCoordination;
import org.mule.umo.MessagingException;
import org.mule.umo.TransactionException;
import org.mule.umo.UMOEventContext;
import org.mule.umo.UMOException;
import org.mule.umo.UMOMessage;
import org.mule.umo.UMOTransaction;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.lifecycle.Initialisable;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.lifecycle.LifecycleException;
import org.mule.umo.routing.RoutingException;

public abstract class AbstractExceptionListener
implements ExceptionListener,
Initialisable {
    protected transient Log logger = LogFactory.getLog(this.getClass());
    protected List endpoints = new CopyOnWriteArrayList();
    static /* synthetic */ Class class$org$mule$umo$routing$RoutingException;
    static /* synthetic */ Class class$org$mule$umo$MessagingException;
    static /* synthetic */ Class class$org$mule$umo$lifecycle$LifecycleException;

    public List getEndpoints() {
        return this.endpoints;
    }

    public void setEndpoints(List endpoints) {
        Iterator iterator = endpoints.iterator();
        while (iterator.hasNext()) {
            this.addEndpoint((UMOEndpoint)iterator.next());
        }
    }

    public void addEndpoint(UMOEndpoint endpoint) {
        if (endpoint != null) {
            endpoint.setType("sender");
            this.endpoints.add(endpoint);
        }
    }

    public boolean removeEndpoint(UMOEndpoint endpoint) {
        return this.endpoints.remove(endpoint);
    }

    public void exceptionThrown(Exception e) {
        Throwable t = this.getExceptionType(e, class$org$mule$umo$routing$RoutingException == null ? (class$org$mule$umo$routing$RoutingException = AbstractExceptionListener.class$("org.mule.umo.routing.RoutingException")) : class$org$mule$umo$routing$RoutingException);
        if (t != null) {
            RoutingException re = (RoutingException)t;
            this.handleRoutingException(re.getUmoMessage(), re.getEndpoint(), e);
            return;
        }
        t = this.getExceptionType(e, class$org$mule$umo$MessagingException == null ? (class$org$mule$umo$MessagingException = AbstractExceptionListener.class$("org.mule.umo.MessagingException")) : class$org$mule$umo$MessagingException);
        if (t != null) {
            MessagingException me = (MessagingException)t;
            this.handleMessagingException(me.getUmoMessage(), e);
            return;
        }
        t = this.getExceptionType(e, class$org$mule$umo$lifecycle$LifecycleException == null ? (class$org$mule$umo$lifecycle$LifecycleException = AbstractExceptionListener.class$("org.mule.umo.lifecycle.LifecycleException")) : class$org$mule$umo$lifecycle$LifecycleException);
        if (t != null) {
            LifecycleException le = (LifecycleException)t;
            this.handleLifecycleException(le.getComponent(), e);
            return;
        }
        this.handleStandardException(e);
    }

    protected Throwable getExceptionType(Exception e, Class exceptionType) {
        for (Throwable current = e; current != null; current = current.getCause()) {
            if (!exceptionType.isAssignableFrom(e.getClass())) continue;
            return current;
        }
        return null;
    }

    public void initialise() throws InitialisationException {
        this.logger.info((Object)("Initialising exception listener: " + this.toString()));
        Iterator iterator = this.endpoints.iterator();
        while (iterator.hasNext()) {
            UMOEndpoint umoEndpoint = (UMOEndpoint)iterator.next();
            umoEndpoint.initialise();
        }
    }

    protected void markTransactionForRollback() {
        UMOTransaction tx = TransactionCoordination.getInstance().getTransaction();
        try {
            if (tx != null) {
                tx.setRollbackOnly();
            }
        }
        catch (TransactionException e) {
            this.logException(e);
        }
    }

    protected void routeException(UMOMessage message, UMOEndpoint failedEndpoint, Throwable t) {
        UMOEndpoint endpoint = this.getEndpoint(t);
        if (endpoint != null) {
            try {
                this.logger.error((Object)("Message being processed is: " + (message == null ? "null" : message.toString())));
                UMOEventContext ctx = RequestContext.getEventContext();
                ExceptionMessage msg = null;
                msg = failedEndpoint != null ? new ExceptionMessage(this.getErrorMessagePayload(message), failedEndpoint, t, ctx) : new ExceptionMessage(this.getErrorMessagePayload(message), t, ctx);
                ctx.sendEvent((UMOMessage)new MuleMessage(msg), endpoint);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("routed Exception message via " + endpoint));
                }
            }
            catch (UMOException e) {
                this.logFatal(message, e);
            }
        } else {
            this.markTransactionForRollback();
        }
    }

    protected Object getErrorMessagePayload(UMOMessage message) {
        try {
            return message.getPayloadAsString();
        }
        catch (Exception e) {
            this.logException(e);
            this.logger.info((Object)"Failed to read message payload as string, using raw payload");
            return message.getPayload();
        }
    }

    protected UMOEndpoint getEndpoint(Throwable t) {
        if (this.endpoints.size() > 0) {
            return (UMOEndpoint)this.endpoints.get(0);
        }
        return null;
    }

    protected void logException(Throwable t) {
        UMOException umoe = ExceptionHelper.getRootMuleException(t);
        if (umoe != null) {
            this.logger.error((Object)umoe.getDetailedMessage());
        } else {
            this.logger.error((Object)("Caught exception in Exception Strategy: " + t.getMessage()), t);
        }
    }

    protected void logFatal(UMOMessage message, Throwable t) {
        this.logger.fatal((Object)("Failed to dispatch message to error queue after it failed to process.  This may cause message loss." + (message == null ? "" : "Logging Message here: \n" + message.toString())), t);
    }

    public abstract void handleMessagingException(UMOMessage var1, Throwable var2);

    public abstract void handleRoutingException(UMOMessage var1, UMOEndpoint var2, Throwable var3);

    public abstract void handleLifecycleException(Object var1, Throwable var2);

    public abstract void handleStandardException(Throwable var1);

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

