/*
 * Decompiled with CFR 0.152.
 */
package org.mule.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.activation.DataHandler;
import org.mule.MuleRuntimeException;
import org.mule.config.i18n.Message;
import org.mule.providers.DefaultMessageAdapter;
import org.mule.umo.UMOExceptionPayload;
import org.mule.umo.UMOMessage;
import org.mule.umo.provider.UMOMessageAdapter;
import org.mule.umo.provider.UniqueIdNotSupportedException;
import org.mule.util.PropertiesHelper;

public class MuleMessage
implements UMOMessage {
    private UMOMessageAdapter adapter;
    protected UMOExceptionPayload exceptionPayload;

    public MuleMessage(Object message) {
        this(message, new HashMap());
    }

    public MuleMessage(Object message, Map props) {
        this.adapter = message instanceof UMOMessageAdapter ? (UMOMessageAdapter)message : new DefaultMessageAdapter(message);
        this.addProperties(props);
    }

    public MuleMessage(Object message, Map properties, UMOMessage previous) {
        this.adapter = message instanceof UMOMessageAdapter ? (UMOMessageAdapter)message : new DefaultMessageAdapter(message);
        if (properties != null) {
            this.addProperties(properties);
        }
        if (previous != null) {
            Iterator iterator = previous.getAttachmentNames().iterator();
            while (iterator.hasNext()) {
                String name = (String)iterator.next();
                try {
                    this.addAttachment(name, previous.getAttachment(name));
                }
                catch (Exception e) {
                    throw new MuleRuntimeException(new Message(124), (Throwable)e);
                }
            }
        }
    }

    public UMOMessageAdapter getAdapter() {
        return this.adapter;
    }

    public Object getProperty(Object key) {
        return this.adapter.getProperty(key.toString());
    }

    public Object removeProperty(Object key) {
        return this.adapter.removeProperty(key);
    }

    public void setProperty(Object key, Object value) {
        this.adapter.setProperty(key.toString(), value);
    }

    public String getPayloadAsString() throws Exception {
        return this.adapter.getPayloadAsString();
    }

    public Iterator getPropertyNames() {
        return this.adapter.getPropertyNames();
    }

    public byte[] getPayloadAsBytes() throws Exception {
        return this.adapter.getPayloadAsBytes();
    }

    public Object getPayload() {
        return this.adapter.getPayload();
    }

    public void addProperties(Map properties) {
        if (properties != null) {
            Iterator iter = properties.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                this.adapter.setProperty(entry.getKey(), entry.getValue());
            }
        }
    }

    public Map getProperties() {
        HashMap props = new HashMap();
        Iterator iter = this.getPropertyNames();
        while (iter.hasNext()) {
            Object key = iter.next();
            if (key == null) continue;
            props.put(key, this.getProperty(key));
        }
        return Collections.unmodifiableMap(props);
    }

    public void clearProperties() {
        Iterator iter = this.adapter.getPropertyNames();
        while (iter.hasNext()) {
            Object key = iter.next();
            this.adapter.removeProperty(key);
        }
    }

    public double getDoubleProperty(String name, double defaultValue) {
        return this.adapter.getDoubleProperty(name, defaultValue);
    }

    public void setDoubleProperty(String name, double value) {
        this.adapter.setDoubleProperty(name, value);
    }

    public String getUniqueId() throws UniqueIdNotSupportedException {
        return this.adapter.getUniqueId();
    }

    public Object getProperty(String name, Object defaultValue) {
        return this.adapter.getProperty(name, defaultValue);
    }

    public int getIntProperty(String name, int defaultValue) {
        return this.adapter.getIntProperty(name, defaultValue);
    }

    public long getLongProperty(String name, long defaultValue) {
        return this.adapter.getLongProperty(name, defaultValue);
    }

    public boolean getBooleanProperty(String name, boolean defaultValue) {
        return this.adapter.getBooleanProperty(name, defaultValue);
    }

    public void setBooleanProperty(String name, boolean value) {
        this.adapter.setBooleanProperty(name, value);
    }

    public void setIntProperty(String name, int value) {
        this.adapter.setIntProperty(name, value);
    }

    public void setLongProperty(String name, long value) {
        this.adapter.setLongProperty(name, value);
    }

    public void setCorrelationId(String id) {
        this.adapter.setCorrelationId(id);
    }

    public String getCorrelationId() {
        return this.adapter.getCorrelationId();
    }

    public void setReplyTo(Object replyTo) {
        this.adapter.setReplyTo(replyTo);
    }

    public Object getReplyTo() {
        return this.adapter.getReplyTo();
    }

    public int getCorrelationSequence() {
        return this.adapter.getCorrelationSequence();
    }

    public void setCorrelationSequence(int sequence) {
        this.adapter.setCorrelationSequence(sequence);
    }

    public int getCorrelationGroupSize() {
        return this.adapter.getCorrelationGroupSize();
    }

    public void setCorrelationGroupSize(int size) {
        this.adapter.setCorrelationGroupSize(size);
    }

    public UMOExceptionPayload getExceptionPayload() {
        return this.exceptionPayload;
    }

    public void setExceptionPayload(UMOExceptionPayload exceptionPayload) {
        this.exceptionPayload = exceptionPayload;
    }

    public String toString() {
        String id = null;
        try {
            id = this.getUniqueId();
        }
        catch (UniqueIdNotSupportedException e) {
            id = "[uniqueId not supported]";
        }
        StringBuffer buf = new StringBuffer();
        buf.append("MuleMessage{");
        buf.append("id=").append(id);
        buf.append(", payload=").append(this.getPayload().getClass().getName());
        buf.append(", correlationId=").append(this.getCorrelationId());
        buf.append(", correlationGroup=").append(this.getCorrelationGroupSize());
        buf.append(", correlationSeq=").append(this.getCorrelationSequence());
        buf.append(", exceptionPayload=").append(this.exceptionPayload);
        buf.append(", properties=").append(PropertiesHelper.propertiesToString(this.getProperties(), true));
        buf.append("}");
        return buf.toString();
    }

    public void addAttachment(String name, DataHandler dataHandler) throws Exception {
        this.adapter.addAttachment(name, dataHandler);
    }

    public void removeAttachment(String name) throws Exception {
        this.adapter.removeAttachment(name);
    }

    public DataHandler getAttachment(String name) {
        return this.adapter.getAttachment(name);
    }

    public Set getAttachmentNames() {
        return this.adapter.getAttachmentNames();
    }
}

