/*
 * Decompiled with CFR 0.152.
 */
package org.mule.impl.container;

import java.io.Reader;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NamingException;
import org.mule.config.i18n.Message;
import org.mule.impl.container.AbstractContainerContext;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.manager.ContainerException;
import org.mule.umo.manager.ObjectNotFoundException;

public class JndiContainerContext
extends AbstractContainerContext {
    protected InitialContext context;
    private Map environment;

    public JndiContainerContext() {
        super("jndi");
    }

    protected JndiContainerContext(String name) {
        super(name);
    }

    public Map getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(Map environment) {
        this.environment = environment;
    }

    public InitialContext getContext() {
        return this.context;
    }

    public void setContext(InitialContext context) {
        this.context = context;
    }

    public Object getComponent(Object key) throws ObjectNotFoundException {
        try {
            if (key == null) {
                throw new ObjectNotFoundException("null");
            }
            if (key instanceof Name) {
                return this.context.lookup((Name)key);
            }
            if (key instanceof Class) {
                return this.context.lookup(((Class)key).getName());
            }
            return this.context.lookup(key.toString());
        }
        catch (NamingException e) {
            throw new ObjectNotFoundException(key.toString(), (Throwable)e);
        }
    }

    public void configure(Reader configuration) throws ContainerException {
        throw new UnsupportedOperationException("configure(Reader)");
    }

    public void initialise() throws InitialisationException {
        try {
            if (this.context == null) {
                this.context = this.environment != null && this.environment.size() > 0 ? new InitialContext(new Hashtable(this.environment)) : new InitialContext();
            }
        }
        catch (NamingException e) {
            throw new InitialisationException(new Message(65, "Jndi context"), e, this);
        }
    }
}

