/*
 * Decompiled with CFR 0.152.
 */
package org.mule.impl.internal.events;

import org.mule.umo.UMOMessage;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.manager.UMOServerEvent;
import org.mule.umo.provider.UMOConnectable;

public class MessageEvent
extends UMOServerEvent {
    public static final int MESSAGE_RECEIVED = 801;
    public static final int MESSAGE_DISPATCHED = 802;
    public static final int MESSAGE_SENT = 803;
    public static final int MESSAGE_REQUESTED = 804;
    private static final transient String[] ACTIONS = new String[]{"received", "dispatched", "sent", "requested"};
    private UMOEndpoint endpoint;

    public MessageEvent(UMOMessage resource, UMOEndpoint endpoint, String identifier, int action) {
        super(resource, action);
        this.resourceIdentifier = identifier;
        this.endpoint = endpoint;
    }

    protected String getPayloadToString() {
        if (this.source instanceof UMOConnectable) {
            return ((UMOConnectable)this.source).getConnectionDescription();
        }
        return this.source.toString();
    }

    protected String getActionName(int action) {
        int i = action - 800;
        if (i - 1 > ACTIONS.length) {
            return String.valueOf(action);
        }
        return ACTIONS[i - 1];
    }

    public String toString() {
        return this.EVENT_NAME + "{action=" + this.getActionName(this.action) + ", endpoint: " + this.endpoint.getEndpointURI() + ", resourceId=" + this.resourceIdentifier + ", timestamp=" + this.timestamp + ", serverId=" + this.serverId + ", message: " + this.source + "}";
    }
}

