/*
 * Decompiled with CFR 0.152.
 */
package org.mule.impl.internal.events;

import edu.emory.mathcs.backport.java.util.concurrent.ArrayBlockingQueue;
import edu.emory.mathcs.backport.java.util.concurrent.BlockingQueue;
import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.MuleRuntimeException;
import org.mule.config.i18n.Message;
import org.mule.impl.internal.events.BlockingServerEvent;
import org.mule.routing.filters.WildcardFilter;
import org.mule.umo.lifecycle.Disposable;
import org.mule.umo.manager.UMOServerEvent;
import org.mule.umo.manager.UMOServerEventListener;
import org.mule.umo.manager.UMOWorkManager;

public class ServerEventManager
implements Work,
Disposable {
    protected static transient Log logger = LogFactory.getLog((Class)(class$org$mule$impl$internal$events$ServerEventManager == null ? (class$org$mule$impl$internal$events$ServerEventManager = ServerEventManager.class$("org.mule.impl.internal.events.ServerEventManager")) : class$org$mule$impl$internal$events$ServerEventManager));
    public static final String NULL_SUBSCRIPTION = "NULL";
    private Map listenersMap = null;
    private Map eventsMap = null;
    private BlockingQueue eventQueue;
    private boolean disposed = false;
    private Comparator comparator = new Comparator(){

        public int compare(Object o1, Object o2) {
            return o1.equals(o2) ? 0 : 1;
        }
    };
    static /* synthetic */ Class class$org$mule$impl$internal$events$ServerEventManager;
    static /* synthetic */ Class class$org$mule$umo$manager$UMOServerEvent;

    public ServerEventManager(UMOWorkManager workManager) {
        this.init();
        try {
            workManager.scheduleWork(this, Long.MAX_VALUE, null, null);
        }
        catch (WorkException e) {
            throw new MuleRuntimeException(new Message(151), (Throwable)e);
        }
    }

    private synchronized void init() {
        this.listenersMap = new ConcurrentHashMap();
        this.eventsMap = new ConcurrentHashMap();
        this.eventQueue = new ArrayBlockingQueue(1000);
    }

    public void registerEventType(Class eventType, Class listenerType) {
        if ((class$org$mule$umo$manager$UMOServerEvent == null ? (class$org$mule$umo$manager$UMOServerEvent = ServerEventManager.class$("org.mule.umo.manager.UMOServerEvent")) : class$org$mule$umo$manager$UMOServerEvent).isAssignableFrom(eventType)) {
            if (!this.listenersMap.containsKey(eventType)) {
                this.listenersMap.put(eventType, new TreeMap(this.comparator));
                this.eventsMap.put(listenerType, eventType);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Registered event type: " + eventType));
                    logger.debug((Object)("Binding listener type '" + listenerType + "' to event type '" + eventType + "'"));
                }
            }
        } else {
            throw new IllegalArgumentException(new Message(157, "eventType", (Object)(class$org$mule$umo$manager$UMOServerEvent == null ? (class$org$mule$umo$manager$UMOServerEvent = ServerEventManager.class$("org.mule.umo.manager.UMOServerEvent")) : class$org$mule$umo$manager$UMOServerEvent).getName(), (Object)eventType.getName()).getMessage());
        }
    }

    public void registerListener(UMOServerEventListener listener) {
        this.registerListener(listener, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerListener(UMOServerEventListener listener, String subscription) {
        TreeMap listeners;
        if (subscription == null) {
            subscription = NULL_SUBSCRIPTION;
        }
        TreeMap treeMap = listeners = this.getListeners(listener.getClass());
        synchronized (treeMap) {
            listeners.put(listener, subscription);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterListener(UMOServerEventListener listener) {
        TreeMap listeners;
        TreeMap treeMap = listeners = this.getListeners(listener.getClass());
        synchronized (treeMap) {
            listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearListeners(Class listenerClass) {
        TreeMap listeners;
        if (listenerClass == null) {
            return;
        }
        TreeMap treeMap = listeners = this.getListeners(listenerClass);
        synchronized (treeMap) {
            listeners.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Iterator iterator = this.listenersMap.values().iterator();
        while (iterator.hasNext()) {
            TreeMap set;
            TreeMap treeMap = set = (TreeMap)iterator.next();
            synchronized (treeMap) {
                set.clear();
            }
        }
        this.listenersMap.clear();
        this.init();
    }

    protected TreeMap getListeners(Class listenerClass) {
        if (listenerClass == null) {
            throw new NullPointerException("Listener class cannot be null");
        }
        Class eventType = null;
        Iterator iterator = this.eventsMap.keySet().iterator();
        while (iterator.hasNext()) {
            Class clazz = (Class)iterator.next();
            if (!clazz.isAssignableFrom(listenerClass)) continue;
            eventType = (Class)this.eventsMap.get(clazz);
            break;
        }
        if (eventType != null) {
            return (TreeMap)this.listenersMap.get(eventType);
        }
        throw new IllegalArgumentException(new Message(157, "Listener Type", (Object)"Registered Type", (Object)listenerClass.getName()).getMessage());
    }

    public void fireEvent(UMOServerEvent event) {
        if (this.disposed) {
            return;
        }
        if (event instanceof BlockingServerEvent) {
            this.notifyListeners(event);
            return;
        }
        try {
            this.eventQueue.put((Object)event);
        }
        catch (InterruptedException e) {
            logger.error((Object)("Failed to queue event: " + event), (Throwable)e);
        }
    }

    public void dispose() {
        this.disposed = true;
        this.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyListeners(UMOServerEvent event) {
        TreeMap listeners;
        String subscription = null;
        Class listenerClass = null;
        Map.Entry entry = null;
        Iterator iterator = this.eventsMap.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            Class eventClass = (Class)entry.getValue();
            if (!event.getClass().isAssignableFrom(eventClass)) continue;
            listenerClass = (Class)entry.getKey();
            break;
        }
        if (listenerClass == null) {
            throw new IllegalArgumentException(new Message(166, event.getClass().getName()).getMessage());
        }
        TreeMap treeMap = listeners = this.getListeners(listenerClass);
        synchronized (treeMap) {
            Iterator iterator2 = listeners.keySet().iterator();
            while (iterator2.hasNext()) {
                UMOServerEventListener l = (UMOServerEventListener)iterator2.next();
                subscription = (String)listeners.get(l);
                if (subscription == null) {
                    subscription = NULL_SUBSCRIPTION;
                }
                if (NULL_SUBSCRIPTION.equals(subscription) || new WildcardFilter(subscription).accept(event.getResourceIdentifier())) {
                    l.onEvent(event);
                    continue;
                }
                logger.trace((Object)("Resource id '" + subscription + "' for listener " + l.getClass().getName() + " does not match Resource id '" + event.getResourceIdentifier() + "' for event, not firing event for this listener"));
            }
        }
    }

    public void release() {
        this.dispose();
    }

    public void run() {
        while (!this.disposed) {
            try {
                UMOServerEvent event = (UMOServerEvent)this.eventQueue.poll(5000L, TimeUnit.MILLISECONDS);
                if (event == null) continue;
                this.notifyListeners(event);
            }
            catch (InterruptedException e) {
                if (this.disposed) continue;
                logger.error((Object)"Failed to take event from server event queue", (Throwable)e);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

