/*
 * Decompiled with CFR 0.152.
 */
package org.mule.impl.model.seda;

import java.util.NoSuchElementException;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkException;
import org.mule.MuleManager;
import org.mule.config.ThreadingProfile;
import org.mule.config.i18n.Message;
import org.mule.impl.FailedToQueueEventException;
import org.mule.impl.MuleDescriptor;
import org.mule.impl.MuleEvent;
import org.mule.impl.model.AbstractComponent;
import org.mule.impl.model.MuleProxy;
import org.mule.impl.model.seda.SedaModel;
import org.mule.umo.ComponentException;
import org.mule.umo.UMOEvent;
import org.mule.umo.UMOException;
import org.mule.umo.UMOMessage;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.lifecycle.LifecycleException;
import org.mule.umo.manager.UMOWorkManager;
import org.mule.util.ObjectPool;
import org.mule.util.queue.QueueSession;

public class SedaComponent
extends AbstractComponent
implements Work {
    protected ObjectPool proxyPool = null;
    protected UMOWorkManager workManager;
    protected String descriptorQueueName;
    protected int queueTimeout = 0;

    public SedaComponent(MuleDescriptor descriptor, SedaModel model) {
        super(descriptor, model);
        this.descriptorQueueName = descriptor.getName() + ".component";
        this.queueTimeout = model.getQueueTimeout();
    }

    public synchronized void doInitialise() throws InitialisationException {
        ThreadingProfile tp = this.descriptor.getThreadingProfile();
        this.workManager = tp.createWorkManager(this.descriptor.getName());
        try {
            this.descriptor.getQueueProfile().configureQueue(this.descriptor.getName());
        }
        catch (InitialisationException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new InitialisationException(new Message(40, "Component Queue"), e, this);
        }
    }

    protected void initialisePool() throws InitialisationException {
        try {
            this.proxyPool = this.descriptor.getPoolingProfile().getPoolFactory().createPool(this.descriptor);
            if (this.descriptor.getPoolingProfile().getInitialisationPolicy() == 2) {
                int threads = this.descriptor.getPoolingProfile().getMaxActive();
                for (int i = 0; i < threads; ++i) {
                    this.proxyPool.returnObject(this.proxyPool.borrowObject());
                }
            } else if (this.descriptor.getPoolingProfile().getInitialisationPolicy() == 1) {
                this.proxyPool.returnObject(this.proxyPool.borrowObject());
            }
            this.poolInitialised.set(true);
        }
        catch (Exception e) {
            throw new InitialisationException(new Message(40, "Proxy Pool"), e, this);
        }
    }

    public void doForceStop() throws UMOException {
        this.workManager.stop();
    }

    public void doStop() throws UMOException {
        this.workManager.stop();
    }

    public void doStart() throws UMOException {
        try {
            if (!this.poolInitialised.get()) {
                this.initialisePool();
            }
            this.proxyPool.start();
            this.workManager.start();
            this.workManager.scheduleWork(this, Long.MAX_VALUE, null, null);
        }
        catch (Exception e) {
            throw new LifecycleException(new Message(42, "Component: " + this.descriptor.getName()), e, this);
        }
    }

    public void doDispose() {
        try {
            if (this.workManager != null) {
                this.workManager.dispose();
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("Component Thread Pool did not close properly: " + e));
        }
        try {
            if (this.proxyPool != null) {
                this.proxyPool.clearPool();
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("Proxy Pool did not close properly: " + e));
        }
    }

    protected void doDispatch(UMOEvent event) throws UMOException {
        if (this.stats.isEnabled()) {
            this.stats.incReceivedEventASync();
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Component: " + this.descriptor.getName() + " has received asynchronous event on: " + event.getEndpoint().getEndpointURI()));
        }
        try {
            this.enqueue(event);
            if (this.stats.isEnabled()) {
                this.stats.incQueuedEvent();
            }
        }
        catch (Exception e) {
            FailedToQueueEventException e1 = new FailedToQueueEventException(new Message(106, this.getName()), event.getMessage(), this, e);
            this.handleException(e1);
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Event added to queue for: " + this.descriptor.getName()));
        }
    }

    public UMOMessage doSend(UMOEvent event) throws UMOException {
        UMOMessage result = null;
        MuleProxy proxy = null;
        try {
            proxy = (MuleProxy)this.proxyPool.borrowObject();
            this.getStatistics().setComponentPoolSize(this.proxyPool.getSize());
            proxy.setStatistics(this.getStatistics());
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)(this + " : got proxy for " + event.getId() + " = " + proxy));
            }
            result = (UMOMessage)proxy.onCall(event);
        }
        catch (UMOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ComponentException(event.getMessage(), this, (Throwable)e);
        }
        finally {
            try {
                if (proxy != null) {
                    this.proxyPool.returnObject(proxy);
                }
            }
            catch (Exception e) {
                throw new ComponentException(event.getMessage(), this, (Throwable)e);
            }
            this.getStatistics().setComponentPoolSize(this.proxyPool.getSize());
        }
        return result;
    }

    ObjectPool getProxyPool() {
        return this.proxyPool;
    }

    public int getQueueSize() {
        QueueSession queueSession = MuleManager.getInstance().getQueueManager().getQueueSession();
        return queueSession.getQueue(this.descriptor.getName()).size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        MuleEvent event = null;
        MuleProxy proxy = null;
        QueueSession queueSession = null;
        while (!this.stopped.get()) {
            try {
                this.paused.whenFalse(null);
                if (this.stopping.get() && queueSession.getQueue(this.descriptor.getName() + ".component").size() == 0) {
                    this.stopping.set(false);
                    break;
                }
                event = (MuleEvent)this.dequeue();
                if (event == null) continue;
                if (this.stats.isEnabled()) {
                    this.stats.decQueuedEvent();
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Component: " + this.descriptor.getName() + " dequeued event on: " + event.getEndpoint().getEndpointURI()));
                }
                proxy = (MuleProxy)this.proxyPool.borrowObject();
                this.getStatistics().setComponentPoolSize(this.proxyPool.getSize());
                proxy.setStatistics(this.getStatistics());
                proxy.start();
                proxy.onEvent(queueSession, event);
                this.workManager.scheduleWork(proxy, Long.MAX_VALUE, null, null);
            }
            catch (Exception e) {
                if (proxy != null) {
                    try {
                        this.proxyPool.returnObject(proxy);
                    }
                    catch (Exception e2) {
                        this.logger.info((Object)"Failed to return proxy to pool", (Throwable)e2);
                    }
                }
                if (e instanceof InterruptedException) {
                    this.stopping.set(false);
                    break;
                }
                if (e instanceof NoSuchElementException) {
                    this.handleException(new ComponentException(new Message(43), event.getMessage(), this, e));
                    continue;
                }
                if (e instanceof UMOException) {
                    this.handleException(e);
                    continue;
                }
                if (e instanceof WorkException) {
                    this.handleException(new ComponentException(new Message(127, this.descriptor.getName()), event.getMessage(), this, e));
                    continue;
                }
                this.handleException(new ComponentException(new Message(44), event.getMessage(), this, e));
            }
            finally {
                this.stopping.set(false);
            }
        }
    }

    public void release() {
        this.stopping.set(false);
    }

    protected void enqueue(UMOEvent event) throws Exception {
        QueueSession session = MuleManager.getInstance().getQueueManager().getQueueSession();
        session.getQueue(this.descriptorQueueName).put(event);
    }

    protected UMOEvent dequeue() throws Exception {
        QueueSession queueSession = MuleManager.getInstance().getQueueManager().getQueueSession();
        return (UMOEvent)queueSession.getQueue(this.descriptorQueueName).poll(this.queueTimeout);
    }
}

