/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers;

import java.beans.ExceptionListener;
import javax.resource.spi.work.Work;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.MuleRuntimeException;
import org.mule.config.ThreadingProfile;
import org.mule.config.i18n.Message;
import org.mule.impl.RequestContext;
import org.mule.impl.internal.events.MessageEvent;
import org.mule.impl.internal.events.SecurityEvent;
import org.mule.providers.AbstractConnector;
import org.mule.transaction.TransactionCoordination;
import org.mule.umo.UMOEvent;
import org.mule.umo.UMOException;
import org.mule.umo.UMOMessage;
import org.mule.umo.UMOTransaction;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.manager.UMOWorkManager;
import org.mule.umo.provider.DispatchException;
import org.mule.umo.provider.UMOConnector;
import org.mule.umo.provider.UMOMessageDispatcher;
import org.mule.umo.security.SecurityException;

public abstract class AbstractMessageDispatcher
implements UMOMessageDispatcher,
ExceptionListener {
    protected transient Log logger = LogFactory.getLog(this.getClass());
    protected UMOWorkManager workManager = null;
    protected AbstractConnector connector;
    protected boolean disposed = false;
    protected boolean doThreading = true;

    public AbstractMessageDispatcher(AbstractConnector connector) {
        this.init(connector);
    }

    private void init(AbstractConnector connector) {
        this.connector = connector;
        if (connector != null) {
            ThreadingProfile profile = connector.getDispatcherThreadingProfile();
            this.doThreading = profile.isDoThreading();
            if (this.doThreading) {
                this.workManager = profile.createWorkManager(connector.getName() + ".dispatcher");
                try {
                    this.workManager.start();
                }
                catch (UMOException e) {
                    this.dispose();
                    throw new MuleRuntimeException(new Message(42, "WorkManager"), (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void dispatch(UMOEvent event) throws DispatchException {
        event.setSynchronous(false);
        event.setProperty("MULE_ENDPOINT", event.getEndpoint().getEndpointURI().toString());
        RequestContext.setEvent(event);
        UMOEndpoint endpoint = event.getEndpoint();
        if (endpoint.getSecurityFilter() != null) {
            try {
                endpoint.getSecurityFilter().authenticate(event);
            }
            catch (SecurityException e) {
                this.logger.warn((Object)("Outbound Request was made but was not authenticated: " + e.getMessage()), (Throwable)e);
                this.connector.fireEvent(new SecurityEvent(e, 600));
                this.connector.handleException(e);
                if (!this.connector.isCreateDispatcherPerRequest()) return;
                this.dispose();
                return;
            }
            catch (UMOException e) {
                this.dispose();
                throw new DispatchException(event.getMessage(), event.getEndpoint(), (Throwable)e);
            }
        }
        event = RequestContext.getEvent();
        try {
            UMOTransaction tx = TransactionCoordination.getInstance().getTransaction();
            if (this.doThreading && !event.isSynchronous() && tx == null) {
                this.workManager.scheduleWork(new Worker(event));
                return;
            }
            this.doDispatch(event);
            if (!this.connector.isEnableMessageEvents()) return;
            this.connector.fireEvent(new MessageEvent(event.getMessage(), event.getEndpoint(), event.getComponent().getDescriptor().getName(), 802));
            return;
        }
        catch (DispatchException e) {
            this.dispose();
            throw e;
        }
        catch (Exception e) {
            this.dispose();
            throw new DispatchException(event.getMessage(), event.getEndpoint(), (Throwable)e);
        }
        finally {
            if (this.connector.isCreateDispatcherPerRequest()) {
                this.dispose();
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final UMOMessage send(UMOEvent event) throws DispatchException {
        event.setSynchronous(true);
        event.setProperty("MULE_ENDPOINT", event.getEndpoint().getEndpointURI().toString());
        RequestContext.setEvent(event);
        UMOEndpoint endpoint = event.getEndpoint();
        if (endpoint.getSecurityFilter() != null) {
            try {
                endpoint.getSecurityFilter().authenticate(event);
            }
            catch (SecurityException e) {
                this.logger.warn((Object)("Outbound Request was made but was not authenticated: " + e.getMessage()), (Throwable)e);
                this.connector.fireEvent(new SecurityEvent(e, 401));
                this.connector.handleException(e);
                UMOMessage uMOMessage = event.getMessage();
                if (!this.connector.isCreateDispatcherPerRequest()) return uMOMessage;
                this.dispose();
                return uMOMessage;
            }
            catch (UMOException e) {
                this.dispose();
                throw new DispatchException(event.getMessage(), event.getEndpoint(), (Throwable)e);
            }
        }
        event = RequestContext.getEvent();
        try {
            UMOMessage result = this.doSend(event);
            if (this.connector.isEnableMessageEvents()) {
                this.connector.fireEvent(new MessageEvent(event.getMessage(), event.getEndpoint(), event.getComponent().getDescriptor().getName(), 803));
            }
            if (result == null) return result;
            result.removeProperty("MULE_REMOTE_SYNC");
            return result;
        }
        catch (DispatchException e) {
            this.dispose();
            throw e;
            catch (Exception e2) {
                this.dispose();
                throw new DispatchException(event.getMessage(), event.getEndpoint(), (Throwable)e2);
            }
        }
        finally {
            if (this.connector.isCreateDispatcherPerRequest()) {
                this.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exceptionThrown(Exception e) {
        try {
            this.getConnector().handleException(e);
        }
        finally {
            this.dispose();
        }
    }

    public final boolean isDisposed() {
        return this.disposed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void dispose() {
        if (!this.disposed) {
            try {
                this.doDispose();
                if (this.workManager != null) {
                    this.workManager.dispose();
                }
            }
            finally {
                this.connector.getDispatchers().values().remove(this);
                this.disposed = true;
            }
        }
    }

    public UMOConnector getConnector() {
        return this.connector;
    }

    public abstract void doDispose();

    public abstract void doDispatch(UMOEvent var1) throws Exception;

    public abstract UMOMessage doSend(UMOEvent var1) throws Exception;

    protected boolean useRemoteSync(UMOEvent event) {
        boolean remoteSync = false;
        if (event.getEndpoint().getConnector().isRemoteSyncEnabled()) {
            boolean bl = remoteSync = event.getEndpoint().isRemoteSync() || event.getMessage().getBooleanProperty("MULE_REMOTE_SYNC", false);
            if (remoteSync && event.getComponent() != null) {
                boolean bl2 = remoteSync = event.getComponent().getDescriptor().getResponseRouter() == null;
            }
        }
        if (!remoteSync) {
            event.removeProperty("MULE_REMOTE_SYNC");
            event.getMessage().removeProperty("MULE_REMOTE_SYNC");
        }
        return remoteSync;
    }

    private class Worker
    implements Work {
        private UMOEvent event;

        public Worker(UMOEvent event) {
            this.event = event;
        }

        public void run() {
            try {
                RequestContext.setEvent(this.event);
                AbstractMessageDispatcher.this.doDispatch(this.event);
                if (AbstractMessageDispatcher.this.connector.isEnableMessageEvents()) {
                    AbstractMessageDispatcher.this.connector.fireEvent(new MessageEvent(this.event.getMessage(), this.event.getEndpoint(), this.event.getComponent().getDescriptor().getName(), 802));
                }
            }
            catch (Exception e) {
                AbstractMessageDispatcher.this.getConnector().handleException(e);
            }
        }

        public void release() {
        }
    }
}

