/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.config.i18n.Message;
import org.mule.impl.MuleEvent;
import org.mule.impl.endpoint.MuleEndpoint;
import org.mule.impl.endpoint.MuleEndpointURI;
import org.mule.impl.model.AbstractComponent;
import org.mule.providers.ReplyToHandler;
import org.mule.umo.UMOEvent;
import org.mule.umo.UMOException;
import org.mule.umo.UMOMessage;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.provider.DispatchException;
import org.mule.umo.transformer.UMOTransformer;

public class DefaultReplyToHandler
implements ReplyToHandler {
    private UMOTransformer transformer;
    private Map endpointCache = new ConcurrentHashMap();
    protected static transient Log logger = LogFactory.getLog((Class)(class$org$mule$providers$DefaultReplyToHandler == null ? (class$org$mule$providers$DefaultReplyToHandler = DefaultReplyToHandler.class$("org.mule.providers.DefaultReplyToHandler")) : class$org$mule$providers$DefaultReplyToHandler));
    static /* synthetic */ Class class$org$mule$providers$DefaultReplyToHandler;

    public DefaultReplyToHandler(UMOTransformer transformer) {
        this.transformer = transformer;
    }

    public void processReplyTo(UMOEvent event, UMOMessage returnMessage, Object replyTo) throws UMOException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("sending reply to: " + returnMessage.getReplyTo()));
        }
        String replyToEndpoint = replyTo.toString();
        UMOEndpoint endpoint = this.getEndpoint(event, replyToEndpoint);
        if (this.transformer != null) {
            endpoint.setTransformer(this.transformer);
        }
        MuleEvent replyToEvent = new MuleEvent(returnMessage, endpoint, event.getSession(), false);
        replyToEvent.removeProperty("MULE_REPLYTO");
        try {
            endpoint.getConnector().getDispatcher(replyTo.toString()).dispatch(replyToEvent);
            if (logger.isInfoEnabled()) {
                logger.info((Object)("reply to sent: " + endpoint));
            }
            ((AbstractComponent)event.getComponent()).getStatistics().incSentReplyToEvent();
        }
        catch (Exception e) {
            throw new DispatchException(new Message(128, endpoint), replyToEvent.getMessage(), replyToEvent.getEndpoint(), e);
        }
    }

    protected UMOEndpoint getEndpoint(UMOEvent event, String endpointUri) throws UMOException {
        UMOEndpoint endpoint = (UMOEndpoint)this.endpointCache.get(endpointUri);
        if (endpoint == null) {
            MuleEndpointURI ep = new MuleEndpointURI(endpointUri);
            endpoint = MuleEndpoint.getOrCreateEndpointForUri(ep, "sender");
            this.endpointCache.put(endpointUri, endpoint);
        }
        return endpoint;
    }

    public UMOTransformer getTransformer() {
        return this.transformer;
    }

    public void setTransformer(UMOTransformer transformer) {
        this.transformer = transformer;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

