/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.mule.providers.AbstractMessageAdapter;
import org.mule.umo.provider.MessageTypeNotSupportedException;
import org.mule.util.StringMessageHelper;

public class StreamMessageAdapter
extends AbstractMessageAdapter {
    private OutputStream out;

    public StreamMessageAdapter(Object message) throws MessageTypeNotSupportedException {
        block5: {
            try {
                if (message instanceof OutputStream) {
                    this.out = (OutputStream)message;
                    break block5;
                }
                if (message instanceof String) {
                    this.out = new ByteArrayOutputStream(message.toString().length());
                    this.out.write(StringMessageHelper.getBytes(message.toString()));
                    break block5;
                }
                if (message instanceof byte[]) {
                    this.out = new ByteArrayOutputStream(((byte[])message).length);
                    this.out.write((byte[])message);
                    break block5;
                }
                throw new MessageTypeNotSupportedException(message, this.getClass());
            }
            catch (IOException e) {
                throw new MessageTypeNotSupportedException(message, this.getClass(), (Throwable)e);
            }
        }
    }

    public String getPayloadAsString() throws Exception {
        if (this.out instanceof ByteArrayOutputStream) {
            return StringMessageHelper.getString(((ByteArrayOutputStream)this.out).toByteArray());
        }
        this.logger.warn((Object)"Attempting to get the String contents of a non-ByteArray output stream");
        return this.out.toString();
    }

    public byte[] getPayloadAsBytes() throws Exception {
        if (this.out instanceof ByteArrayOutputStream) {
            return ((ByteArrayOutputStream)this.out).toByteArray();
        }
        this.logger.warn((Object)"Attempting to get the bytes of a non-ByteArray output stream");
        return StringMessageHelper.getBytes(this.out.toString());
    }

    public Object getPayload() {
        return this.out;
    }

    public void write(String string) throws IOException {
        this.out.write(StringMessageHelper.getBytes(string));
    }

    public void write(String string, int offset, int len) throws IOException {
        this.out.write(StringMessageHelper.getBytes(string), offset, len);
    }

    public void write(byte[] bytes) throws IOException {
        this.out.write(bytes);
    }

    public void write(byte[] bytes, int offset, int len) throws IOException {
        this.out.write(bytes, offset, len);
    }

    public OutputStream getStream() {
        return this.out;
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public void close() throws IOException {
        this.out.close();
    }
}

