/*
 * Decompiled with CFR 0.152.
 */
package org.mule.registry;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.SecureClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.mule.registry.Library;
import org.mule.registry.RegistryComponent;

public class ClassLoaderFactory {
    private static ClassLoaderFactory factory;
    private Map sharedClassLoaders = new HashMap();

    public static ClassLoaderFactory getInstance() {
        if (factory == null) {
            factory = new ClassLoaderFactory();
        }
        return factory;
    }

    private ClassLoaderFactory() {
    }

    public ClassLoader createComponentClassLoader(RegistryComponent component) throws MalformedURLException {
        DelegatingClassLoader dcl = new DelegatingClassLoader();
        Library[] libraries = component.getLibraries();
        for (int i = 0; i < libraries.length; ++i) {
            dcl.addClassLoader(this.getSharedClassLoader(libraries[i]));
        }
        URL[] urls = this.getUrlsFrom(component.getInstallRoot(), component.getClassPathElements());
        boolean isParentFirst = component.isClassLoaderParentFirst();
        JbiClassLoader ccl = new JbiClassLoader(urls, (ClassLoader)dcl, isParentFirst);
        return ccl;
    }

    private ClassLoader getSharedClassLoader(Library library) throws MalformedURLException {
        ClassLoader cl = (ClassLoader)this.sharedClassLoaders.get(library.getName());
        if (cl == null) {
            URL[] urls = this.getUrlsFrom(library.getInstallRoot(), library.getClassPathElements());
            boolean isParentFirst = library.isClassLoaderParentFirst();
            cl = new JbiClassLoader(urls, null, isParentFirst);
            this.sharedClassLoaders.put(library.getName(), cl);
        }
        return cl;
    }

    private URL[] getUrlsFrom(String root, List paths) throws MalformedURLException {
        URL[] urls = new URL[paths.size()];
        for (int i = 0; i < urls.length; ++i) {
            String cpElement = (String)paths.get(i);
            urls[i] = new File(root, cpElement).toURL();
        }
        return urls;
    }

    public static class DelegatingClassLoader
    extends SecureClassLoader {
        private List loaders = new ArrayList();

        public void addClassLoader(ClassLoader loader) {
            if (loader == null) {
                throw new IllegalArgumentException("loader can not be null");
            }
            this.loaders.add(loader);
        }

        protected Class findClass(String name) throws ClassNotFoundException {
            Iterator iter = this.loaders.iterator();
            while (iter.hasNext()) {
                ClassLoader loader = (ClassLoader)iter.next();
                try {
                    return loader.loadClass(name);
                }
                catch (ClassNotFoundException e) {
                }
            }
            throw new ClassNotFoundException(name);
        }
    }

    public static class JbiClassLoader
    extends URLClassLoader {
        private boolean parentFirst;

        public JbiClassLoader(URL[] urls, ClassLoader parent, boolean parentFirst) {
            super(urls, parent);
            this.parentFirst = parentFirst;
        }

        protected synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
            Class<?> clazz = this.findLoadedClass(name);
            if (clazz == null) {
                if (this.parentFirst) {
                    try {
                        clazz = this.getParent().loadClass(name);
                    }
                    catch (ClassNotFoundException cnfe) {
                        clazz = this.findClass(name);
                    }
                } else {
                    try {
                        clazz = this.findClass(name);
                    }
                    catch (ClassNotFoundException e) {
                        clazz = this.getParent().loadClass(name);
                    }
                }
            }
            if (resolve) {
                this.resolveClass(clazz);
            }
            return clazz;
        }
    }
}

