/*
 * Decompiled with CFR 0.152.
 */
package org.mule.registry.impl;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.mule.registry.Assembly;
import org.mule.registry.Registry;
import org.mule.registry.RegistryDescriptor;
import org.mule.registry.RegistryException;
import org.mule.registry.Unit;
import org.mule.registry.impl.AbstractEntry;
import org.mule.registry.impl.AbstractUnit;
import org.mule.util.Utility;

public abstract class AbstractAssembly
extends AbstractEntry
implements Assembly {
    protected List units = new ArrayList();
    protected boolean isTransient;
    protected RegistryDescriptor descriptor;

    protected AbstractAssembly(Registry registry) {
        super(registry);
    }

    public Unit getUnit(String name) {
        Iterator it = this.units.iterator();
        while (it.hasNext()) {
            AbstractUnit u = (AbstractUnit)it.next();
            if (!u.getName().equals(name)) continue;
            return u;
        }
        return null;
    }

    public void addUnit(Unit unit) {
        this.units.add(unit);
    }

    public void removeUnit(Unit unit) {
        this.units.remove(unit);
    }

    public Unit[] getUnits() {
        List c = this.units;
        return c.toArray(new Unit[c.size()]);
    }

    protected void checkDescriptor() throws RegistryException {
        super.checkDescriptor();
        if (!this.getDescriptor().isServiceAssembly()) {
            throw new RegistryException("service-assembly should be set");
        }
    }

    public synchronized String start() throws RegistryException {
        if (this.getCurrentState().equals("Unknown")) {
            throw new RegistryException("Illegal status: " + this.getCurrentState());
        }
        if (!this.getCurrentState().equals("Running")) {
            Unit[] units = this.getUnits();
            for (int i = 0; i < units.length; ++i) {
                units[i].start();
            }
            this.setCurrentState("Running");
        }
        return "";
    }

    public synchronized String stop() throws RegistryException {
        if (this.getCurrentState().equals("Unknown") || this.getCurrentState().equals("Shutdown")) {
            throw new RegistryException("Illegal status: " + this.getCurrentState());
        }
        if (!this.getCurrentState().equals("Stopped")) {
            Unit[] units = this.getUnits();
            for (int i = 0; i < units.length; ++i) {
                units[i].stop();
            }
            this.setCurrentState("Stopped");
        }
        return "";
    }

    public synchronized String shutDown() throws RegistryException {
        if (this.getCurrentState().equals("Unknown")) {
            throw new RegistryException("Illegal status: " + this.getCurrentState());
        }
        if (!this.getCurrentState().equals("Shutdown")) {
            this.stop();
            Unit[] units = this.getUnits();
            for (int i = 0; i < units.length; ++i) {
                units[i].shutDown();
            }
            this.setCurrentState("Shutdown");
        }
        return "";
    }

    public synchronized String undeploy() throws RegistryException {
        if (!this.getCurrentState().equals("Shutdown") && !this.getCurrentState().equals("Unknown")) {
            throw new RegistryException("Illegal status: " + this.getCurrentState());
        }
        Unit[] units = this.getUnits();
        for (int i = 0; i < units.length; ++i) {
            String string = units[i].undeploy();
        }
        Utility.deleteTree(new File(this.getInstallRoot()));
        this.getRegistry().removeAssembly(this);
        this.setCurrentState("Unknown");
        return null;
    }

    public boolean isTransient() {
        return this.isTransient;
    }

    public void setTransient(boolean isTransient) {
        this.isTransient = isTransient;
    }

    public void restoreState() throws RegistryException {
        Unit[] units = this.getUnits();
        for (int i = 0; i < units.length; ++i) {
            units[i].init();
            if (units[i].getStateAtShutdown().equals("Running")) {
                units[i].start();
                continue;
            }
            if (!units[i].getStateAtShutdown().equals("Shutdown")) continue;
            units[i].shutDown();
        }
    }

    public void saveAndShutdown() throws RegistryException {
        Unit[] units = this.getUnits();
        for (int i = 0; i < units.length; ++i) {
            units[i].setStateAtShutdown(units[i].getCurrentState());
            units[i].shutDown();
        }
    }

    public void setDescriptor(RegistryDescriptor descriptor) {
        this.descriptor = descriptor;
    }
}

