/*
 * Decompiled with CFR 0.152.
 */
package org.mule.registry.impl;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.mule.ManagementContext;
import org.mule.MuleManager;
import org.mule.registry.Assembly;
import org.mule.registry.ComponentType;
import org.mule.registry.Library;
import org.mule.registry.Registry;
import org.mule.registry.RegistryComponent;
import org.mule.registry.RegistryException;
import org.mule.registry.RegistryStore;
import org.mule.registry.Unit;
import org.mule.registry.impl.AbstractAssembly;
import org.mule.registry.impl.AbstractLibrary;

public abstract class AbstractRegistry
implements Registry {
    public static final String REGISTRY_DIRECTORY = "registry";
    private List libraries;
    private List assemblies;
    private List components;
    private transient Map registry;
    private transient Map librariesMap;
    private transient Map assembliesMap;
    private transient Map componentsMap;
    private transient String storeLocation;
    private File workingDirectory;
    protected transient RegistryStore store;
    protected transient ManagementContext context;
    private transient boolean started = false;

    public AbstractRegistry(RegistryStore store, ManagementContext context) {
        this.store = store;
        this.context = context;
        this.registry = new HashMap();
        for (int i = 0; i < ComponentType.COMPONENT_TYPES.length; ++i) {
            ComponentType componentType = ComponentType.COMPONENT_TYPES[i];
            this.registry.put(componentType.getName() + ".list", new ArrayList());
            this.registry.put(componentType.getName() + ".map", new HashMap());
        }
        this.components = new ArrayList();
        this.libraries = new ArrayList();
        this.assemblies = new ArrayList();
        this.librariesMap = new HashMap();
        this.assembliesMap = new HashMap();
        this.componentsMap = new HashMap();
        this.workingDirectory = new File(MuleManager.getConfiguration().getWorkingDirectory(), REGISTRY_DIRECTORY);
    }

    public File getWorkingDirectory() {
        return this.workingDirectory;
    }

    public void setWorkingDirectory(File workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    public String getStoreLocation() {
        return this.storeLocation;
    }

    public void setStoreLocation(String storeLocation) {
        this.storeLocation = storeLocation;
    }

    public synchronized RegistryComponent[] getComponents() {
        return this.components.toArray(new RegistryComponent[this.components.size()]);
    }

    public synchronized RegistryComponent[] getComponents(ComponentType type) {
        RegistryComponent[] components = new RegistryComponent[]{};
        List list = (List)this.registry.get(type + ".list");
        if (list != null) {
            components = list.toArray(new RegistryComponent[list.size()]);
        }
        return components;
    }

    public synchronized RegistryComponent getComponent(String name, ComponentType type) {
        return (RegistryComponent)this.componentsMap.get(name);
    }

    public synchronized void removeComponent(RegistryComponent component) {
        Map map;
        this.componentsMap.remove(component.getName());
        List list = (List)this.registry.get(component.getType() + ".list");
        if (list != null) {
            list.remove(component);
        }
        if ((map = (Map)this.registry.get(component.getType() + ".map")) != null) {
            map.remove(component);
        }
    }

    public synchronized RegistryComponent getComponent(String name) {
        return (RegistryComponent)this.componentsMap.get(name);
    }

    public synchronized RegistryComponent addComponent(String name, ComponentType type) throws RegistryException {
        if (this.getComponent(name) != null) {
            throw new RegistryException("Component already registered: " + name);
        }
        RegistryComponent rc = this.createComponent(name, type);
        this.componentsMap.put(name, rc);
        return rc;
    }

    public synchronized RegistryComponent addTransientComponent(String name, ComponentType type, Object component, Object bootstrap) throws RegistryException {
        RegistryComponent rc = this.getComponent(name);
        if (rc == null) {
            rc = this.createComponent(name, type);
            rc.setTransient(true);
            rc.setComponent(component);
            rc.setStateAtShutdown("Running");
            try {
                rc.setWorkspaceRoot(this.context.getComponentWorkspaceDir(this.getWorkingDirectory(), name).getAbsoluteFile().getCanonicalPath());
            }
            catch (IOException e) {
                throw new RegistryException(e);
            }
            this.componentsMap.put(name, rc);
            this.components.add(rc);
            if (bootstrap != null) {
                try {
                    this.bootstrapComponent(rc, bootstrap);
                }
                catch (Exception e) {
                    throw new RegistryException(e);
                }
            }
        } else {
            if (!rc.isTransient()) {
                throw new RegistryException("A non-transient component is already registered: " + name);
            }
            rc.setComponent(component);
        }
        try {
            rc.initComponent();
        }
        catch (Exception e) {
            throw new RegistryException(e);
        }
        return rc;
    }

    protected abstract void bootstrapComponent(RegistryComponent var1, Object var2) throws Exception;

    public synchronized Library[] getLibraries() {
        List c = this.libraries;
        return c.toArray(new Library[c.size()]);
    }

    public synchronized Library getLibrary(String name) {
        return (Library)this.librariesMap.get(name);
    }

    public synchronized Library addLibrary(String name) throws RegistryException {
        if (this.getLibrary(name) != null) {
            throw new RegistryException("Library already registered: " + name);
        }
        Library l = this.createLibrary(name);
        this.libraries.add(l);
        this.librariesMap.put(name, l);
        return l;
    }

    public synchronized void removeLibrary(Library library) {
        this.librariesMap.remove(library.getName());
        this.libraries.remove(library);
    }

    public synchronized Assembly[] getAssemblies() {
        List c = this.assemblies;
        return c.toArray(new Assembly[c.size()]);
    }

    public synchronized Assembly getAssembly(String name) {
        return (Assembly)this.assembliesMap.get(name);
    }

    public synchronized Assembly addAssembly(String name) {
        if (this.getAssembly(name) != null) {
            return null;
        }
        Assembly a = this.createAssembly(name);
        this.assemblies.add(a);
        this.assembliesMap.put(name, a);
        return a;
    }

    public synchronized void removeAssembly(Assembly assembly) {
        this.assembliesMap.remove(assembly.getName());
        this.assemblies.remove(assembly);
    }

    public void initialize() {
        this.componentsMap = new HashMap();
        Iterator it = this.components.iterator();
        while (it.hasNext()) {
            RegistryComponent e = (RegistryComponent)it.next();
            this.componentsMap.put(e.getName(), e);
        }
        this.librariesMap = new HashMap();
        it = this.libraries.iterator();
        while (it.hasNext()) {
            AbstractLibrary l = (AbstractLibrary)it.next();
            this.librariesMap.put(l.getName(), l);
        }
        this.assembliesMap = new HashMap();
        it = this.assemblies.iterator();
        while (it.hasNext()) {
            AbstractAssembly a = (AbstractAssembly)it.next();
            this.assembliesMap.put(a.getName(), a);
        }
    }

    public synchronized void start() throws RegistryException {
        this.started = true;
        try {
            RegistryComponent[] components = this.getComponents();
            for (int i = 0; i < components.length; ++i) {
                if (components[i].isTransient() && components[i].getComponent() == null) {
                    this.removeComponent(components[i]);
                    continue;
                }
                components[i].restoreState();
            }
            Assembly[] assemblies = this.getAssemblies();
            for (int i = 0; i < assemblies.length; ++i) {
                assemblies[i].restoreState();
            }
        }
        catch (Exception e) {
            throw new RegistryException(e);
        }
    }

    public synchronized void shutDown() throws RegistryException {
        RegistryComponent[] components = this.getComponents();
        for (int i = 0; i < components.length; ++i) {
            components[i].saveAndShutdown();
        }
        this.store.save(this);
    }

    public synchronized void addTransientUnit(String suName, RegistryComponent component, String installDir) throws RegistryException {
        Assembly a = this.getAssembly(suName);
        if (a == null) {
            Assembly assembly = this.createAssembly(suName);
            assembly.setTransient(true);
            assembly.setStateAtShutdown("Running");
            Unit unit = this.createUnit(suName);
            unit.setName(suName);
            unit.setAssembly(assembly);
            unit.setRegistryComponent(component);
            try {
                unit.setInstallRoot(new File(installDir).getAbsoluteFile().getCanonicalPath());
            }
            catch (IOException e) {
                throw new RegistryException(e);
            }
            this.assemblies.add(assembly);
            this.assembliesMap.put(suName, assembly);
            unit.deploy();
            unit.start();
            assembly.setCurrentState("Running");
        } else if (!a.isTransient()) {
            throw new RegistryException("A non-transient or assembly is already deployed: " + suName);
        }
    }

    public void save() throws RegistryException {
        this.store.save(this);
    }

    public boolean isStarted() {
        return this.started;
    }

    public ManagementContext getManagementContext() {
        return this.context;
    }
}

