/*
 * Decompiled with CFR 0.152.
 */
package org.mule.registry.impl;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.management.ObjectName;
import org.mule.registry.ClassLoaderFactory;
import org.mule.registry.ComponentType;
import org.mule.registry.Library;
import org.mule.registry.Registry;
import org.mule.registry.RegistryComponent;
import org.mule.registry.RegistryDescriptor;
import org.mule.registry.RegistryException;
import org.mule.registry.Unit;
import org.mule.registry.impl.AbstractEntry;

public abstract class AbstractRegistryComponent
extends AbstractEntry
implements RegistryComponent {
    protected ComponentType type;
    protected String name;
    protected transient ObjectName objectName;
    protected List units;
    protected List libraries;
    protected String workspaceRoot;
    protected List classPathElements;
    protected String componentClassName;
    protected boolean isClassLoaderParentFirst;
    protected boolean isTransient;
    protected Object component;
    protected RegistryDescriptor descriptor;

    protected AbstractRegistryComponent(String name, ComponentType type, Registry registry) {
        super(registry);
        this.type = type;
        this.name = name;
        this.units = new ArrayList();
        this.libraries = new ArrayList();
    }

    public ComponentType getType() {
        return this.type;
    }

    protected void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        super.readObject(in);
        in.defaultReadObject();
    }

    public Library[] getLibraries() {
        ArrayList<Library> c = new ArrayList<Library>();
        Iterator it = this.libraries.iterator();
        while (it.hasNext()) {
            String ref = (String)it.next();
            Library library = this.getRegistry().getLibrary(ref);
            c.add(library);
        }
        return c.toArray(new Library[c.size()]);
    }

    public Unit[] getUnits() {
        ArrayList<Unit> c = new ArrayList<Unit>();
        Iterator it = this.units.iterator();
        while (it.hasNext()) {
            String ref = (String)it.next();
            String[] refs = ref.split("/");
            if (refs.length != 2) {
                throw new IllegalStateException("Malformed unit ref");
            }
            Unit unit = this.getRegistry().getAssembly(refs[0]).getUnit(refs[1]);
            c.add(unit);
        }
        return c.toArray(new Unit[c.size()]);
    }

    public void addUnit(Unit unit) {
        this.units.add(unit.getAssembly().getName() + "/" + unit.getName());
    }

    public void removeUnit(Unit unit) {
        this.units.remove(unit.getAssembly().getName() + "/" + unit.getName());
    }

    public ObjectName getObjectName() {
        return this.objectName;
    }

    protected void checkDescriptor() throws RegistryException {
        super.checkDescriptor();
        if (!this.getDescriptor().isComponent()) {
            throw new RegistryException("component should be set");
        }
    }

    protected void createComponent() throws RegistryException {
        try {
            ClassLoader loader = ClassLoaderFactory.getInstance().createComponentClassLoader(this);
            Class<?> cl = Class.forName(this.componentClassName, true, loader);
            this.component = cl.newInstance();
        }
        catch (Exception e) {
            throw new RegistryException(e);
        }
    }

    public synchronized void install() throws RegistryException {
        if (!this.getCurrentState().equals("Unknown")) {
            throw new RegistryException("Illegal status: " + this.getCurrentState());
        }
        if (this.isTransient) {
            return;
        }
        try {
            this.doInstall();
        }
        catch (Exception e) {
            throw new RegistryException(e);
        }
        this.createComponent();
        try {
            this.objectName = this.initComponent();
        }
        catch (Exception e) {
            throw new RegistryException(e);
        }
    }

    protected abstract void doInstall() throws Exception;

    public final synchronized void restoreState() throws RegistryException {
        if (!this.getCurrentState().equals("Unknown") && !this.getCurrentState().equals("Initialized")) {
            throw new RegistryException("Illegal status: " + this.getCurrentState());
        }
        try {
            if (!this.isTransient) {
                this.createComponent();
                this.initComponent();
            }
            if (this.getStateAtShutdown().equals("Running")) {
                this.start();
            }
            this.doRestoreState();
        }
        catch (Exception e) {
            throw new RegistryException(e);
        }
    }

    protected abstract void doRestoreState() throws Exception;

    public synchronized void saveAndShutdown() throws RegistryException {
        this.setStateAtShutdown(this.getCurrentState());
        Unit[] units = this.getUnits();
        for (int i = 0; i < units.length; ++i) {
            units[i].setStateAtShutdown(units[i].getCurrentState());
        }
        this.shutDown();
    }

    public final synchronized void start() throws RegistryException {
        if (this.getCurrentState().equals("Unknown")) {
            throw new RegistryException("Illegal status: " + this.getCurrentState());
        }
        if (this.getCurrentState().equals("Running")) {
            return;
        }
        try {
            this.doStart();
        }
        catch (Exception e) {
            throw new RegistryException(e);
        }
        this.setCurrentState("Running");
    }

    protected abstract void doStart() throws Exception;

    public final synchronized void stop() throws RegistryException {
        if (this.getCurrentState().equals("Unknown") || this.getCurrentState().equals("Shutdown")) {
            throw new RegistryException("Illegal status: " + this.getCurrentState());
        }
        if (this.getCurrentState().equals("Stopped")) {
            return;
        }
        try {
            this.doStop();
        }
        catch (Exception e) {
            throw new RegistryException(e);
        }
        this.setCurrentState("Stopped");
    }

    protected abstract void doStop() throws Exception;

    public final synchronized void shutDown() throws RegistryException {
        if (this.getCurrentState().equals("Unknown")) {
            throw new RegistryException("Illegal status: " + this.getCurrentState());
        }
        if (this.getCurrentState().equals("Shutdown")) {
            return;
        }
        this.stop();
        try {
            this.doShutDown();
        }
        catch (Exception e) {
            throw new RegistryException(e);
        }
        this.setCurrentState("Shutdown");
    }

    protected abstract void doShutDown() throws Exception;

    public synchronized void uninstall() throws RegistryException {
        if (!this.getCurrentState().equals("Shutdown") && !this.getCurrentState().equals("Unknown")) {
            throw new RegistryException("Illegal status: " + this.getCurrentState());
        }
        if (this.units.size() > 0) {
            throw new RegistryException("Component has service units deployed");
        }
        Library[] libraries = this.getLibraries();
        for (int i = 0; i < libraries.length; ++i) {
            libraries[i].removeComponent(this);
        }
        this.registry.getManagementContext().deleteDir(this.getInstallRoot());
        this.registry.getManagementContext().deleteDir(this.getWorkspaceRoot());
        this.getRegistry().removeComponent(this);
        this.setCurrentState("Unknown");
    }

    public String getWorkspaceRoot() {
        return this.workspaceRoot;
    }

    public void setWorkspaceRoot(String workspaceRoot) {
        this.workspaceRoot = workspaceRoot;
    }

    public List getClassPathElements() {
        return this.classPathElements;
    }

    public void setClassPathElements(List classPathElements) {
        this.classPathElements = classPathElements;
    }

    public boolean isClassLoaderParentFirst() {
        return this.isClassLoaderParentFirst;
    }

    public void setComponent(Object component) {
        this.component = component;
    }

    public boolean isTransient() {
        return this.isTransient;
    }

    public void setTransient(boolean isTransient) {
        this.isTransient = isTransient;
    }

    public Object getComponent() {
        return this.component;
    }

    public RegistryDescriptor getDescriptor() throws RegistryException {
        return this.descriptor;
    }

    public void setDescriptor(RegistryDescriptor descriptor) throws RegistryException {
        this.descriptor = descriptor;
    }
}

