/*
 * Decompiled with CFR 0.152.
 */
package org.mule.registry.impl;

import org.mule.registry.Assembly;
import org.mule.registry.Registry;
import org.mule.registry.RegistryComponent;
import org.mule.registry.RegistryException;
import org.mule.registry.Unit;
import org.mule.registry.impl.AbstractAssembly;
import org.mule.registry.impl.AbstractEntry;

public abstract class AbstractUnit
extends AbstractEntry
implements Unit {
    private String assembly;

    protected AbstractUnit(Registry registry) {
        super(registry);
    }

    public Assembly getAssembly() {
        return this.getRegistry().getAssembly(this.assembly);
    }

    public void setAssembly(Assembly assembly) {
        this.assembly = assembly.getName();
    }

    public final synchronized String deploy() throws RegistryException {
        if (!this.getCurrentState().equals("Unknown")) {
            throw new RegistryException("Illegal status: " + this.getCurrentState());
        }
        String result = null;
        try {
            result = this.doDeploy();
        }
        catch (Exception e) {
            throw new RegistryException(e);
        }
        this.getRegistryComponent().addUnit(this);
        ((AbstractAssembly)this.getAssembly()).addUnit(this);
        this.setCurrentState("Stopped");
        return result;
    }

    public abstract String doDeploy() throws Exception;

    public final synchronized void init() throws RegistryException {
        if (!this.getCurrentState().equals("Unknown")) {
            throw new RegistryException("Illegal status: " + this.getCurrentState());
        }
        try {
            this.doInit();
        }
        catch (Exception e) {
            throw new RegistryException(e);
        }
        this.setCurrentState("Stopped");
    }

    protected abstract void doInit() throws Exception;

    public final synchronized void start() throws RegistryException {
        if (this.getCurrentState().equals("Unknown")) {
            throw new RegistryException("Illegal status: " + this.getCurrentState());
        }
        if (!this.getCurrentState().equals("Running")) {
            try {
                this.doStart();
            }
            catch (Exception e) {
                throw new RegistryException(e);
            }
            this.setCurrentState("Running");
        }
    }

    protected abstract void doStart() throws Exception;

    public final synchronized void stop() throws RegistryException {
        if (this.getCurrentState().equals("Unknown") || this.getCurrentState().equals("Shutdown")) {
            throw new RegistryException("Illegal status: " + this.getCurrentState());
        }
        if (!this.getCurrentState().equals("Stopped")) {
            try {
                this.doStop();
            }
            catch (Exception e) {
                throw new RegistryException(e);
            }
            this.setCurrentState("Stopped");
        }
    }

    protected abstract void doStop() throws Exception;

    public final synchronized void shutDown() throws RegistryException {
        if (this.getCurrentState().equals("Unknown")) {
            throw new RegistryException("Illegal status: " + this.getCurrentState());
        }
        if (!this.getCurrentState().equals("Shutdown")) {
            this.stop();
            try {
                this.doShutDown();
            }
            catch (Exception e) {
                throw new RegistryException(e);
            }
            this.setCurrentState("Shutdown");
        }
    }

    protected abstract void doShutDown() throws Exception;

    public synchronized String undeploy() throws RegistryException {
        if (!this.getCurrentState().equals("Shutdown")) {
            throw new RegistryException("Illegal status: " + this.getCurrentState());
        }
        String result = null;
        try {
            result = this.doUndeploy();
        }
        catch (Exception e) {
            throw new RegistryException(e);
        }
        this.getRegistryComponent().removeUnit(this);
        ((AbstractAssembly)this.getAssembly()).removeUnit(this);
        this.setCurrentState("Unknown");
        return result;
    }

    protected abstract String doUndeploy() throws Exception;

    public void setRegistryComponent(RegistryComponent component) {
    }
}

