/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.inbound;

import java.util.Comparator;
import org.mule.routing.inbound.AbstractEventResequencer;
import org.mule.routing.inbound.EventGroup;
import org.mule.umo.UMOEvent;

public class CorrelationEventResequencer
extends AbstractEventResequencer {
    public CorrelationEventResequencer() {
        this.setComparator(new CorrelationSequenceComparator());
    }

    protected boolean shouldResequence(EventGroup events) {
        UMOEvent event = (UMOEvent)events.getEvents().get(0);
        int size = event.getMessage().getCorrelationGroupSize();
        if (size == -1) {
            logger.warn((Object)"Correlation Group Size not set, but CorrelationResequencer is being used.  This can cause messages to be held indefinitely");
        }
        return size == events.getSize();
    }

    private class CorrelationSequenceComparator
    implements Comparator {
        private CorrelationSequenceComparator() {
        }

        public int compare(Object o1, Object o2) {
            int val2;
            int val1 = ((UMOEvent)o1).getMessage().getCorrelationSequence();
            if (val1 == (val2 = ((UMOEvent)o2).getMessage().getCorrelationSequence())) {
                return 0;
            }
            if (val1 > val2) {
                return 1;
            }
            return -1;
        }
    }
}

