/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.outbound;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import edu.emory.mathcs.backport.java.util.concurrent.CopyOnWriteArrayList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.impl.MuleMessage;
import org.mule.impl.endpoint.MuleEndpoint;
import org.mule.impl.endpoint.MuleEndpointURI;
import org.mule.routing.outbound.FilteringOutboundRouter;
import org.mule.umo.UMOException;
import org.mule.umo.UMOMessage;
import org.mule.umo.UMOSession;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.routing.CouldNotRouteOutboundMessageException;
import org.mule.umo.routing.RoutingException;

public abstract class AbstractRecipientList
extends FilteringOutboundRouter {
    protected static transient Log logger = LogFactory.getLog((Class)(class$org$mule$routing$outbound$AbstractRecipientList == null ? (class$org$mule$routing$outbound$AbstractRecipientList = AbstractRecipientList.class$("org.mule.routing.outbound.AbstractRecipientList")) : class$org$mule$routing$outbound$AbstractRecipientList));
    private Map recipientCache = new ConcurrentHashMap();
    static /* synthetic */ Class class$org$mule$routing$outbound$AbstractRecipientList;

    public UMOMessage route(UMOMessage message, UMOSession session, boolean synchronous) throws RoutingException {
        CopyOnWriteArrayList list = this.getRecipients(message);
        ArrayList<Object> results = new ArrayList<Object>();
        if (this.enableCorrelation != 2) {
            boolean correlationSet;
            boolean bl = correlationSet = message.getCorrelationGroupSize() != -1;
            if (correlationSet && this.enableCorrelation == 0) {
                logger.debug((Object)"CorrelationId is already set, not setting Correlation group size");
            } else {
                message.setCorrelationGroupSize(list.size());
            }
        }
        UMOMessage result = null;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String recipient = (String)iterator.next();
            UMOEndpoint endpoint = this.getRecipientEndpoint(message, recipient);
            try {
                if (synchronous) {
                    result = this.send(session, message, endpoint);
                    if (result != null) {
                        results.add(result.getPayload());
                        continue;
                    }
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)("No result was returned for sync call to: " + endpoint.getEndpointURI()));
                    continue;
                }
                this.dispatch(session, message, endpoint);
            }
            catch (UMOException e) {
                throw new CouldNotRouteOutboundMessageException(message, endpoint, (Throwable)e);
            }
        }
        if (results != null && results.size() == 1) {
            return new MuleMessage(results.get(0), result.getProperties());
        }
        if (results.size() == 0) {
            return null;
        }
        return new MuleMessage(results, result == null ? null : result.getProperties());
    }

    protected UMOEndpoint getRecipientEndpoint(UMOMessage message, String recipient) throws RoutingException {
        MuleEndpointURI endpointUri = null;
        UMOEndpoint endpoint = (UMOEndpoint)this.recipientCache.get(recipient);
        if (endpoint != null) {
            return endpoint;
        }
        try {
            endpointUri = new MuleEndpointURI(recipient);
            endpoint = MuleEndpoint.getOrCreateEndpointForUri(endpointUri, "sender");
        }
        catch (UMOException e) {
            throw new RoutingException(message, endpoint, (Throwable)e);
        }
        this.recipientCache.put(recipient, endpoint);
        return endpoint;
    }

    protected abstract CopyOnWriteArrayList getRecipients(UMOMessage var1);

    public boolean isDynamicEndpoints() {
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

