/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.outbound;

import edu.emory.mathcs.backport.java.util.concurrent.CopyOnWriteArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mule.impl.MuleMessage;
import org.mule.routing.outbound.AbstractMessageSplitter;
import org.mule.umo.UMOMessage;
import org.mule.umo.endpoint.UMOEndpoint;

public class FilteringListMessageSplitter
extends AbstractMessageSplitter {
    private CopyOnWriteArrayList payload;
    private Map properties;

    protected void initialise(UMOMessage message) {
        if (message.getPayload() instanceof List) {
            this.payload = new CopyOnWriteArrayList((Collection)((List)message.getPayload()));
            if (this.enableCorrelation != 2) {
                int groupSize = this.payload.size();
                this.logger.debug((Object)("java.util.List payload detected, setting correlation group size to " + groupSize));
                message.setCorrelationGroupSize(groupSize);
            }
        } else {
            throw new IllegalArgumentException("The payload for this router must be of type java.util.list");
        }
        this.properties = message.getProperties();
    }

    protected UMOMessage getMessagePart(UMOMessage message, UMOEndpoint endpoint) {
        for (int i = 0; i < this.payload.size(); ++i) {
            Object object = this.payload.get(i);
            MuleMessage result = new MuleMessage(object, new HashMap(this.properties));
            if (endpoint.getFilter() != null && !endpoint.getFilter().accept(result)) continue;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Endpoint filter matched. Routing message over: " + endpoint.getEndpointURI().toString()));
            }
            this.payload.remove(i);
            return result;
        }
        return null;
    }
}

