/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.outbound;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Node;
import org.dom4j.XPath;
import org.mule.impl.MuleMessage;
import org.mule.routing.outbound.AbstractMessageSplitter;
import org.mule.umo.UMOMessage;
import org.mule.umo.endpoint.UMOEndpoint;

public class FilteringXmlMessageSplitter
extends AbstractMessageSplitter {
    private Map properties;
    private List nodes;
    private Document dom4jDoc;
    private String splitExpression = "";
    private Map namespaces = null;

    public void setSplitExpression(String splitExpression) {
        this.splitExpression = splitExpression;
    }

    public void setNamespaces(Map namespaces) {
        this.namespaces = namespaces;
    }

    public String getSplitExpression() {
        return this.splitExpression;
    }

    protected void initialise(UMOMessage message) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("splitExpression is " + this.splitExpression));
        }
        if (message.getPayload() instanceof Document) {
            this.dom4jDoc = (Document)message.getPayload();
            XPath xpath = this.dom4jDoc.createXPath(this.splitExpression);
            if (this.namespaces != null) {
                xpath.setNamespaceURIs(this.namespaces);
            }
            this.nodes = xpath.selectNodes((Object)this.dom4jDoc);
        } else {
            this.logger.error((Object)("Message is not a dom4j.Document! It is: " + message.getPayload().getClass().toString()));
        }
        this.properties = message.getProperties();
    }

    protected UMOMessage getMessagePart(UMOMessage message, UMOEndpoint endpoint) {
        for (int i = 0; i < this.nodes.size(); ++i) {
            Node node = (Node)this.nodes.get(i);
            try {
                MuleMessage result = new MuleMessage(DocumentHelper.parseText((String)node.asXML()), new HashMap(this.properties));
                if (endpoint.getFilter() != null && !endpoint.getFilter().accept(result)) continue;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Endpoint filter matched. Routing message over: " + endpoint.getEndpointURI().toString()));
                }
                this.nodes.remove(i);
                return result;
            }
            catch (Exception e) {
                this.logger.error((Object)("Unable to create message for node as position " + i), (Throwable)e);
                return null;
            }
        }
        return null;
    }
}

