/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformers.xml;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamSource;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.io.DocumentResult;
import org.dom4j.io.DocumentSource;
import org.mule.config.i18n.Message;
import org.mule.transformers.AbstractTransformer;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.transformer.TransformerException;
import org.mule.umo.transformer.UMOTransformer;
import org.mule.util.Utility;

public class XsltTransformer
extends AbstractTransformer {
    private Transformer transformer;
    private String xslFile;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class array$B;
    static /* synthetic */ Class class$org$dom4j$io$DocumentSource;
    static /* synthetic */ Class class$org$dom4j$Document;

    public XsltTransformer() {
        this.registerSourceType(class$java$lang$String == null ? (class$java$lang$String = XsltTransformer.class$("java.lang.String")) : class$java$lang$String);
        this.registerSourceType(array$B == null ? (array$B = XsltTransformer.class$("[B")) : array$B);
        this.registerSourceType(class$org$dom4j$io$DocumentSource == null ? (class$org$dom4j$io$DocumentSource = XsltTransformer.class$("org.dom4j.io.DocumentSource")) : class$org$dom4j$io$DocumentSource);
        this.registerSourceType(class$org$dom4j$Document == null ? (class$org$dom4j$Document = XsltTransformer.class$("org.dom4j.Document")) : class$org$dom4j$Document);
    }

    public void initialise() throws InitialisationException {
        try {
            StreamSource source = this.getStreamSource();
            TransformerFactory factory = TransformerFactory.newInstance();
            this.transformer = factory.newTransformer(source);
        }
        catch (Exception e) {
            throw new InitialisationException(e, (Object)this);
        }
    }

    public Object doTransform(Object src) throws TransformerException {
        try {
            DocumentSource sourceDoc = null;
            DocumentResult resultDoc = new DocumentResult();
            DefaultErrorListener errorListener = null;
            if (src instanceof byte[]) {
                src = new String((byte[])src);
            }
            if (src instanceof String) {
                String xml = (String)src;
                Document dom4jDoc = DocumentHelper.parseText((String)xml);
                sourceDoc = new DocumentSource(dom4jDoc);
            } else if (src instanceof DocumentSource) {
                sourceDoc = (DocumentSource)src;
            } else if (src instanceof Document) {
                sourceDoc = new DocumentSource((Document)src);
            }
            errorListener = new DefaultErrorListener(this);
            this.transformer.setErrorListener(errorListener);
            this.transformer.transform((Source)sourceDoc, (Result)resultDoc);
            if (errorListener.isError()) {
                throw errorListener.getException();
            }
            if ((class$org$dom4j$Document == null ? (class$org$dom4j$Document = XsltTransformer.class$("org.dom4j.Document")) : class$org$dom4j$Document).equals(this.returnClass)) {
                return resultDoc.getDocument();
            }
            Document transformedDoc = resultDoc.getDocument();
            return transformedDoc.asXML();
        }
        catch (Exception e) {
            throw new TransformerException(this, (Throwable)e);
        }
    }

    public String getXslFile() {
        return this.xslFile;
    }

    public void setXslFile(String xslFile) {
        this.xslFile = xslFile;
    }

    private StreamSource getStreamSource() throws InitialisationException {
        StreamSource source;
        if (this.xslFile == null) {
            throw new InitialisationException(new Message(45, "xslFile"), (Object)this);
        }
        File file = new File(this.xslFile);
        if (file.exists()) {
            source = new StreamSource(file);
        } else {
            try {
                InputStream stream = Utility.loadResource(this.xslFile, this.getClass());
                if (stream == null) {
                    throw new InitialisationException(new Message(122, this.xslFile), (Object)this);
                }
                source = new StreamSource(stream);
            }
            catch (IOException e) {
                throw new InitialisationException(new Message(58, this.xslFile), e, this);
            }
        }
        return source;
    }

    public Object clone() throws CloneNotSupportedException {
        XsltTransformer x = (XsltTransformer)super.clone();
        try {
            if (x.transformer == null) {
                x.initialise();
            }
        }
        catch (Exception e) {
            throw new CloneNotSupportedException(e.getMessage());
        }
        return x;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class DefaultErrorListener
    implements ErrorListener {
        private TransformerException e = null;
        private UMOTransformer trans;

        public DefaultErrorListener(UMOTransformer trans) {
            this.trans = trans;
        }

        public TransformerException getException() {
            return this.e;
        }

        public boolean isError() {
            return this.e != null;
        }

        public void error(javax.xml.transform.TransformerException exception) throws javax.xml.transform.TransformerException {
            XsltTransformer.this.logger.error((Object)exception.getMessage(), (Throwable)exception);
            this.e = new TransformerException(this.trans, (Throwable)exception);
        }

        public void fatalError(javax.xml.transform.TransformerException exception) throws javax.xml.transform.TransformerException {
            XsltTransformer.this.logger.fatal((Object)exception.getMessage());
            this.e = new TransformerException(this.trans, (Throwable)exception);
        }

        public void warning(javax.xml.transform.TransformerException exception) throws javax.xml.transform.TransformerException {
            XsltTransformer.this.logger.warn((Object)exception.getMessage());
        }
    }
}

