/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TemplateParser {
    protected static transient Log logger = LogFactory.getLog((Class)(class$org$mule$util$TemplateParser == null ? (class$org$mule$util$TemplateParser = TemplateParser.class$("org.mule.util.TemplateParser")) : class$org$mule$util$TemplateParser));
    private Pattern pattern = null;
    private int pre = 1;
    private int post = 1;
    static /* synthetic */ Class class$org$mule$util$TemplateParser;

    public static TemplateParser createAntStyleParser() {
        return new TemplateParser("ant");
    }

    public static TemplateParser createSquareBracesStyleParser() {
        return new TemplateParser("square");
    }

    private TemplateParser(String type) {
        if ("ant".equals(type)) {
            this.pattern = Pattern.compile("\\$\\{[^\\}]+\\}");
            this.pre = 2;
        } else if ("square".equals(type)) {
            this.pattern = Pattern.compile("\\[[^\\]]+\\]");
        }
    }

    public String parse(Map props, String template) {
        String result = template;
        Matcher m = this.pattern.matcher(template);
        while (m.find()) {
            String match = m.group();
            String propname = match.substring(this.pre, match.length() - this.post);
            Object value = props.get(propname);
            if (value == null) {
                logger.error((Object)("Value " + propname + " not found in context"));
                value = "";
            }
            match = this.escape(match);
            result = result.replaceAll(match, value.toString());
        }
        return result;
    }

    public List parse(Map props, List templates) {
        if (templates == null) {
            return new ArrayList();
        }
        ArrayList<String> list = new ArrayList<String>(templates.size());
        Iterator iterator = templates.iterator();
        while (iterator.hasNext()) {
            list.add(this.parse(props, iterator.next().toString()));
        }
        return list;
    }

    public Map parse(Map props, Map templates) {
        if (templates == null) {
            return new HashMap();
        }
        HashMap map = new HashMap(templates.size());
        Iterator iterator = templates.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            map.put(entry.getKey(), this.parse(props, entry.getValue().toString()));
        }
        return map;
    }

    private String escape(String string) {
        int length = string.length();
        if (length == 0) {
            return string;
        }
        StringBuffer buffer = new StringBuffer(length * 2);
        for (int i = 0; i < length; ++i) {
            char currentCharacter = string.charAt(i);
            switch (currentCharacter) {
                case '$': 
                case '[': 
                case ']': 
                case '{': 
                case '}': {
                    buffer.append("\\");
                }
            }
            buffer.append(currentCharacter);
        }
        return buffer.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

