/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util;

import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.mule.MuleManager;
import org.mule.util.ClassHelper;

public class Utility {
    public static final String CRLF = System.getProperty("line.separator");
    public static final String EMPTY_STRING = "";
    private static final int DEFAULT_BUFFER_SIZE = 4096;

    public static File createFile(String filename) throws IOException {
        File file = new File(filename);
        if (!file.canWrite()) {
            String dirName = file.getPath();
            int i = dirName.lastIndexOf(File.separator);
            if (i > -1) {
                dirName = dirName.substring(0, i);
                File dir = new File(dirName);
                dir.mkdirs();
            }
            file.createNewFile();
        }
        return file;
    }

    public static String prepareWinFilename(String filename) {
        filename = filename.replaceAll("<", "(");
        filename = filename.replaceAll(">", ")");
        filename = filename.replaceAll("[/\\*?|:;]", "-");
        return filename;
    }

    public static File openDirectory(String directory) throws IOException {
        File dir = new File(directory);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        if (!dir.isDirectory() || !dir.canRead()) {
            throw new IOException("Directory: " + directory + " exists but isn't a directory");
        }
        return dir;
    }

    public static boolean getBooleanValue(String s) throws Exception {
        boolean result = (s = s.trim()).equalsIgnoreCase("true");
        return result;
    }

    public static String getTimeStamp(String format) {
        SimpleDateFormat formatter = new SimpleDateFormat(format);
        Date currentTime = new Date();
        return formatter.format(currentTime);
    }

    public static String formatTimeStamp(Date dateTime, String format) {
        SimpleDateFormat formatter = new SimpleDateFormat(format);
        return formatter.format(dateTime);
    }

    public static synchronized String fileToString(String fileName) throws IOException {
        StringBuffer sb = new StringBuffer();
        char[] buf = new char[8192];
        FileReader fr = new FileReader(fileName);
        int read = 0;
        while ((read = fr.read(buf)) >= 0) {
            sb.append(buf, 0, read);
        }
        return sb.toString();
    }

    public static File stringToFile(String filename, String data) throws IOException {
        return Utility.stringToFile(filename, data, false);
    }

    public static synchronized File stringToFile(String filename, String data, boolean append) throws IOException {
        return Utility.stringToFile(filename, data, append, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized File stringToFile(String filename, String data, boolean append, boolean newLine) throws IOException {
        File f = Utility.createFile(filename);
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(f, append));
            writer.write(data);
            if (newLine) {
                writer.newLine();
            }
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
        return f;
    }

    public static String getStringFromDate(Date date, String format) {
        SimpleDateFormat formatter = new SimpleDateFormat(format);
        return formatter.format(date);
    }

    public static Date getDateFromString(String date, String format) {
        SimpleDateFormat formatter = new SimpleDateFormat(format);
        ParsePosition pos = new ParsePosition(0);
        return formatter.parse(date, pos);
    }

    public static File loadFile(String filename) throws IOException {
        File file = new File(filename);
        if (file.canRead()) {
            return file;
        }
        throw new IOException("File: " + filename + " can not be read");
    }

    public static byte[] objectToByteArray(Object src) throws IOException {
        if (src instanceof byte[]) {
            return (byte[])src;
        }
        if (src instanceof String) {
            return ((String)src).getBytes();
        }
        byte[] dest = null;
        ByteArrayOutputStream bs = null;
        ObjectOutputStream os = null;
        try {
            bs = new ByteArrayOutputStream();
            os = new ObjectOutputStream(bs);
            os.writeObject(src);
            os.flush();
            dest = bs.toByteArray();
        }
        catch (IOException e) {
            os.close();
            bs.close();
            throw e;
        }
        return dest;
    }

    public static Object byteArrayToObject(byte[] src) throws IOException, ClassNotFoundException {
        Object dest = null;
        ByteArrayInputStream bais = new ByteArrayInputStream(src);
        ObjectInputStream ois = new ObjectInputStream(bais);
        dest = ois.readObject();
        ois.close();
        return dest;
    }

    public static URL getResource(final String resourceName, Class callingClass) {
        URL url = ClassHelper.getResource(resourceName, callingClass);
        if (url == null) {
            url = (URL)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    File f = new File(resourceName);
                    if (f.exists()) {
                        try {
                            return f.toURL();
                        }
                        catch (MalformedURLException e) {
                            return null;
                        }
                    }
                    return null;
                }
            });
        }
        return url;
    }

    public static String loadResourceAsString(String resourceName, Class callingClass) throws IOException {
        return Utility.loadResourceAsString(resourceName, callingClass, MuleManager.getConfiguration().getEncoding());
    }

    public static String loadResourceAsString(String resourceName, Class callingClass, String encoding) throws IOException {
        URL url = Utility.getResource(resourceName, callingClass);
        String resource = null;
        resource = url == null ? Utility.fileToString(resourceName) : Utility.fileToString(URLDecoder.decode(url.getFile(), encoding));
        return resource;
    }

    public static InputStream loadResource(String resourceName, Class callingClass) throws IOException {
        URL url = Utility.getResource(resourceName, callingClass);
        InputStream resource = null;
        if (url == null) {
            File f = new File(resourceName);
            if (f.exists()) {
                resource = new FileInputStream(f);
            }
        } else {
            resource = url.openStream();
        }
        return resource;
    }

    public static String getResourcePath(String resourceName, Class callingClass) throws IOException {
        return Utility.getResourcePath(resourceName, callingClass, MuleManager.getConfiguration().getEncoding());
    }

    public static String getResourcePath(String resourceName, Class callingClass, String encoding) throws IOException {
        if (resourceName == null) {
            return null;
        }
        URL url = Utility.getResource(resourceName, callingClass);
        String resource = null;
        if (url == null) {
            File f = new File(resourceName);
            if (f.exists()) {
                resource = f.getAbsolutePath();
            }
        } else {
            resource = URLDecoder.decode(url.toExternalForm(), encoding);
        }
        if (resource != null) {
            if (resource.startsWith("file:/")) {
                resource = resource.substring(6);
            }
            if (!resource.startsWith(File.separator)) {
                resource = File.separator + resource;
            }
        }
        return resource;
    }

    public static boolean deleteTree(File dir) {
        if (dir == null) {
            return true;
        }
        File[] files = dir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (!(files[i].isDirectory() ? !Utility.deleteTree(files[i]) : !files[i].delete())) continue;
            return false;
        }
        return dir.delete();
    }

    public static String[] split(String string, String delim) {
        StringTokenizer st = new StringTokenizer(string, delim);
        String[] results = new String[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            results[i++] = st.nextToken().trim();
        }
        return results;
    }

    public static String getFormattedDuration(long mills) {
        long days = mills / 86400000L;
        long hours = (mills -= days * 86400000L) / 3600000L;
        long mins = (mills -= hours * 3600000L) / 60000L;
        long secs = (mills -= mins * 60000L) / 1000L;
        mills -= secs * 1000L;
        StringBuffer bf = new StringBuffer();
        bf.append(days).append(" days, ");
        bf.append(hours).append(" hours, ");
        bf.append(mins).append(" mins, ");
        bf.append(secs).append(".").append(mills).append(" sec");
        return bf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unzip(File archive, File directory) throws IOException {
        ZipFile zip = null;
        if (directory.exists()) {
            if (!directory.isDirectory()) {
                throw new IOException("Directory is not a directory: " + directory);
            }
        } else if (!directory.mkdirs()) {
            throw new IOException("Could not create directory: " + directory);
        }
        try {
            zip = new ZipFile(archive);
            Enumeration<? extends ZipEntry> entries = zip.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                File f = new File(directory, entry.getName());
                if (entry.isDirectory()) {
                    if (f.mkdirs()) continue;
                    throw new IOException("Could not create directory: " + f);
                }
                InputStream is = zip.getInputStream(entry);
                BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(f));
                Utility.copy(is, os);
                is.close();
                ((OutputStream)os).close();
            }
        }
        finally {
            if (zip != null) {
                zip.close();
            }
        }
    }

    public static int copy(InputStream input, OutputStream output) throws IOException {
        byte[] buffer = new byte[4096];
        int count = 0;
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += n;
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(URL url, File output) throws IOException {
        InputStream is = null;
        FileOutputStream os = null;
        try {
            is = url.openStream();
            os = new FileOutputStream(output);
            Utility.copy(is, os);
        }
        catch (Throwable throwable) {
            Utility.closeQuietly(is);
            Utility.closeQuietly(os);
            throw throwable;
        }
        Utility.closeQuietly(is);
        Utility.closeQuietly(os);
    }

    public static void closeQuietly(InputStream input) {
        try {
            if (input != null) {
                input.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void closeQuietly(OutputStream output) {
        try {
            if (output != null) {
                output.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

