/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.compression;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.util.compression.CompressionException;
import org.mule.util.compression.CompressionStrategy;

public class GZipCompression
implements CompressionStrategy {
    private static final transient Log logger = LogFactory.getLog((Class)(class$org$mule$util$compression$GZipCompression == null ? (class$org$mule$util$compression$GZipCompression = GZipCompression.class$("org.mule.util.compression.GZipCompression")) : class$org$mule$util$compression$GZipCompression));
    static /* synthetic */ Class class$org$mule$util$compression$GZipCompression;

    public boolean isCompressed(byte[] bytes) throws IOException {
        ByteArrayInputStream is = new ByteArrayInputStream(bytes, 0, 2);
        int b = this.readByte(is);
        b = this.readByte(is) << 8 | b;
        return b == 35615;
    }

    private int readByte(InputStream in) throws IOException {
        int b = in.read();
        if (b == -1) {
            throw new EOFException();
        }
        return b;
    }

    public byte[] compressByteArray(byte[] bytes) throws IOException {
        logger.debug((Object)("Compressing message of size: " + bytes.length));
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        GZIPOutputStream gos = new GZIPOutputStream(baos);
        gos.write(bytes, 0, bytes.length);
        gos.finish();
        gos.close();
        byte[] compressedByteArray = baos.toByteArray();
        logger.debug((Object)("Compressed message to size: " + compressedByteArray.length));
        return compressedByteArray;
    }

    public byte[] uncompressByteArray(byte[] bytes) throws IOException {
        int len;
        logger.debug((Object)("Uncompressing message of size: " + bytes.length));
        if (!this.isCompressed(bytes)) {
            logger.warn((Object)"data is not of type GZIP compressed. The data may not have been compressed in the first place");
            throw new CompressionException("Not in GZIP format");
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        GZIPInputStream gis = new GZIPInputStream(bais);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buf = new byte[2048];
        while ((len = gis.read(buf)) != -1) {
            baos.write(buf, 0, len);
        }
        byte[] uncompressedByteArray = baos.toByteArray();
        logger.debug((Object)("Uncompressing message to size: " + uncompressedByteArray.length));
        return uncompressedByteArray;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

