/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.xa;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.mule.config.i18n.Message;
import org.mule.util.xa.AbstractTransactionContext;
import org.mule.util.xa.ResourceManagerException;
import org.mule.util.xa.ResourceManagerSystemException;

public abstract class AbstractResourceManager {
    public static final int SHUTDOWN_MODE_NORMAL = 0;
    public static final int SHUTDOWN_MODE_ROLLBACK = 1;
    public static final int SHUTDOWN_MODE_KILL = 2;
    protected static final int OPERATION_MODE_STOPPED = 0;
    protected static final int OPERATION_MODE_STOPPING = 1;
    protected static final int OPERATION_MODE_STARTED = 2;
    protected static final int OPERATION_MODE_STARTING = 3;
    protected static final int OPERATION_MODE_RECOVERING = 4;
    protected static final int DEFAULT_TIMEOUT_MSECS = 5000;
    protected static final int DEFAULT_COMMIT_TIMEOUT_FACTOR = 2;
    protected Collection globalTransactions;
    protected int operationMode = 0;
    protected long defaultTimeout = 5000L;
    protected Log logger = this.getLogger();
    protected boolean dirty = false;

    protected abstract Log getLogger();

    public synchronized void start() throws ResourceManagerSystemException {
        this.logger.info((Object)"Starting ResourceManager");
        this.operationMode = 3;
        this.globalTransactions = Collections.synchronizedCollection(new ArrayList());
        this.doStart();
        this.recover();
        this.operationMode = 2;
        if (this.dirty) {
            this.logger.warn((Object)"Started ResourceManager, but in dirty mode only (Recovery of pending transactions failed)");
        } else {
            this.logger.info((Object)"Started ResourceManager");
        }
    }

    protected void doStart() throws ResourceManagerSystemException {
    }

    protected void recover() throws ResourceManagerSystemException {
    }

    public synchronized void stop() throws ResourceManagerSystemException {
        this.stop(0);
    }

    public synchronized boolean stop(int mode) throws ResourceManagerSystemException {
        return this.stop(mode, this.getDefaultTransactionTimeout() * 2L);
    }

    public synchronized boolean stop(int mode, long timeOut) throws ResourceManagerSystemException {
        this.logger.info((Object)"Stopping ResourceManager");
        this.operationMode = 1;
        boolean success = this.shutdown(mode, timeOut);
        if (success) {
            this.operationMode = 0;
            this.logger.info((Object)"Stopped ResourceManager");
        } else {
            this.logger.warn((Object)"Failed to stop ResourceManager");
        }
        return success;
    }

    protected boolean shutdown(int mode, long timeoutMSecs) {
        switch (mode) {
            case 0: {
                return this.waitForAllTxToStop(timeoutMSecs);
            }
            case 1: {
                throw new UnsupportedOperationException();
            }
            case 2: {
                return true;
            }
        }
        return false;
    }

    public long getDefaultTransactionTimeout() {
        return this.defaultTimeout;
    }

    public void setDefaultTransactionTimeout(long timeout) {
        this.defaultTimeout = timeout;
    }

    public AbstractTransactionContext startTransaction(Object session) throws ResourceManagerException {
        AbstractTransactionContext context = this.createTransactionContext(session);
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beginTransaction(AbstractTransactionContext context) throws ResourceManagerException {
        this.assureStarted();
        AbstractTransactionContext abstractTransactionContext = context;
        synchronized (abstractTransactionContext) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Beginning transaction " + context));
            }
            this.doBegin(context);
            context.status = 0;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Begun transaction " + context));
            }
        }
        this.globalTransactions.add(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int prepareTransaction(AbstractTransactionContext context) throws ResourceManagerException {
        this.assureReady();
        AbstractTransactionContext abstractTransactionContext = context;
        synchronized (abstractTransactionContext) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Preparing transaction " + context));
            }
            context.status = 7;
            int status = this.doPrepare(context);
            context.status = 2;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Prepared transaction " + context));
            }
            return status;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollbackTransaction(AbstractTransactionContext context) throws ResourceManagerException {
        this.assureReady();
        AbstractTransactionContext abstractTransactionContext = context;
        synchronized (abstractTransactionContext) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Rolling back transaction " + context));
            }
            try {
                context.status = 9;
                this.doRollback(context);
                context.status = 4;
            }
            catch (Error e) {
                this.setDirty(context, e);
                throw e;
            }
            catch (RuntimeException e) {
                this.setDirty(context, e);
                throw e;
            }
            catch (ResourceManagerSystemException e) {
                this.setDirty(context, e);
                throw e;
            }
            finally {
                this.globalTransactions.remove(context);
                context.finalCleanUp();
                context.notifyFinish();
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Rolled back transaction " + context));
            }
        }
    }

    public void setTransactionRollbackOnly(AbstractTransactionContext context) throws ResourceManagerException {
        context.status = 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commitTransaction(AbstractTransactionContext context) throws ResourceManagerException {
        this.assureReady();
        if (context.status == 1) {
            throw new ResourceManagerException(new Message(77));
        }
        AbstractTransactionContext abstractTransactionContext = context;
        synchronized (abstractTransactionContext) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Committing transaction " + context));
            }
            try {
                context.status = 8;
                this.doCommit(context);
                context.status = 3;
            }
            catch (Error e) {
                this.setDirty(context, e);
                throw e;
            }
            catch (RuntimeException e) {
                this.setDirty(context, e);
                throw e;
            }
            catch (ResourceManagerSystemException e) {
                this.setDirty(context, e);
                throw e;
            }
            catch (ResourceManagerException e) {
                this.logger.warn((Object)("Could not commit tx " + context + ", rolling back instead"), (Throwable)e);
                this.doRollback(context);
            }
            finally {
                this.globalTransactions.remove(context);
                context.finalCleanUp();
                context.notifyFinish();
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Committed transaction " + context));
            }
        }
    }

    protected abstract AbstractTransactionContext createTransactionContext(Object var1);

    protected abstract void doBegin(AbstractTransactionContext var1);

    protected abstract int doPrepare(AbstractTransactionContext var1);

    protected abstract void doCommit(AbstractTransactionContext var1) throws ResourceManagerException;

    protected abstract void doRollback(AbstractTransactionContext var1) throws ResourceManagerException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean waitForAllTxToStop(long timeoutMSecs) {
        ArrayList transactionsToStop;
        long startTime = System.currentTimeMillis();
        Collection collection = this.globalTransactions;
        synchronized (collection) {
            transactionsToStop = new ArrayList(this.globalTransactions);
        }
        Iterator it = transactionsToStop.iterator();
        while (it.hasNext()) {
            AbstractTransactionContext context;
            long remainingTimeout = startTime - System.currentTimeMillis() + timeoutMSecs;
            if (remainingTimeout <= 0L) {
                return false;
            }
            AbstractTransactionContext abstractTransactionContext = context = (AbstractTransactionContext)it.next();
            synchronized (abstractTransactionContext) {
                if (!context.finished) {
                    this.logger.info((Object)("Waiting for tx " + context + " to finish for " + remainingTimeout + " milli seconds"));
                }
                while (!context.finished && remainingTimeout > 0L) {
                    try {
                        context.wait(remainingTimeout);
                    }
                    catch (InterruptedException e) {
                        return false;
                    }
                    remainingTimeout = startTime - System.currentTimeMillis() + timeoutMSecs;
                }
                if (context.finished) {
                    this.logger.info((Object)("Tx " + context + " finished"));
                } else {
                    this.logger.warn((Object)("Tx " + context + " failed to finish in given time"));
                }
            }
        }
        return this.globalTransactions.size() == 0;
    }

    protected void setDirty(AbstractTransactionContext context, Throwable t) {
        this.logger.error((Object)("Fatal error during critical commit/rollback of transaction " + context + ", setting resource manager to dirty."), t);
        this.dirty = true;
    }

    protected void assureStarted() throws ResourceManagerSystemException {
        if (this.operationMode != 2) {
            throw new ResourceManagerSystemException(new Message(161));
        }
        if (this.dirty) {
            throw new ResourceManagerSystemException(new Message(162));
        }
    }

    protected void assureReady() throws ResourceManagerSystemException {
        if (this.operationMode != 2 && this.operationMode != 1) {
            throw new ResourceManagerSystemException(new Message(163));
        }
        if (this.dirty) {
            throw new ResourceManagerSystemException(new Message(162));
        }
    }
}

