/*
 * Decompiled with CFR 0.152.
 */
package org.mule.components.script;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.impl.UMODescriptorAware;
import org.mule.umo.UMODescriptor;
import org.mule.umo.UMOException;
import org.mule.umo.lifecycle.Callable;
import org.mule.umo.lifecycle.Initialisable;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.lifecycle.Lifecycle;
import org.mule.util.ClassUtils;
import org.mule.util.monitor.FileListener;
import org.mule.util.monitor.FileMonitor;

public abstract class AbstractScriptComponent
implements Initialisable,
Lifecycle,
UMODescriptorAware,
FileListener,
Callable {
    protected transient Log logger = LogFactory.getLog(this.getClass());
    private String script = null;
    private String scriptText = null;
    private boolean autoReload = true;
    protected UMODescriptor descriptor;
    private FileMonitor monitor;
    private long reloadInterval = 60000L;

    public void setDescriptor(UMODescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public void initialise() throws InitialisationException {
        if (this.getScript() == null && this.getScriptText() == null) {
            String extension = this.getDefaultFileExtension();
            if (!extension.startsWith(".")) {
                extension = "." + extension;
            }
            this.setScript(this.descriptor.getName() + extension);
            this.logger.info((Object)("script name is not set, using default: " + this.descriptor.getName() + extension));
        }
        if (this.getScriptText() != null) {
            this.loadInterpreter(this.getScriptText());
        } else {
            this.loadInterpreter(this.getScriptUrl(this.getScript()));
        }
        if (this.autoReload) {
            File f = new File(this.getScript());
            if (f.exists()) {
                this.monitor = new FileMonitor(this.reloadInterval);
                this.monitor.addFile(f);
                this.monitor.addListener(this);
                this.logger.debug((Object)"Component script is reloadable");
            } else {
                this.logger.warn((Object)"Cannot setup autoreload as the script fie is not on the local file system");
            }
        }
    }

    protected URL getScriptUrl(String scriptLocation) {
        File f = new File(scriptLocation);
        if (f.exists()) {
            try {
                return f.toURL();
            }
            catch (MalformedURLException e) {
                this.logger.error((Object)("Failed to create URL from file: " + f.getAbsolutePath()), (Throwable)e);
                return null;
            }
        }
        return ClassUtils.getResource(scriptLocation, this.getClass());
    }

    public String getScript() {
        return this.script;
    }

    public void setScript(String script) {
        this.script = script;
    }

    public boolean isAutoReload() {
        return this.autoReload;
    }

    public void setAutoReload(boolean autoReload) {
        this.autoReload = autoReload;
    }

    public void start() throws UMOException {
        if (this.monitor != null) {
            this.monitor.start();
        }
    }

    public void stop() throws UMOException {
        if (this.monitor != null) {
            this.monitor.stop();
        }
    }

    public void dispose() {
        try {
            this.stop();
        }
        catch (UMOException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public String getScriptText() {
        return this.scriptText;
    }

    public void setScriptText(String scriptText) {
        this.scriptText = scriptText;
    }

    protected abstract void loadInterpreter(URL var1) throws InitialisationException;

    protected abstract void loadInterpreter(String var1) throws InitialisationException;

    protected abstract String getDefaultFileExtension();
}

