/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config;

import java.io.IOException;
import java.io.InputStream;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.resource.spi.work.WorkListener;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.MuleRuntimeException;
import org.mule.config.PoolingProfile;
import org.mule.config.QueueProfile;
import org.mule.config.ThreadingProfile;
import org.mule.config.i18n.Message;
import org.mule.providers.ConnectionStrategy;
import org.mule.providers.SingleAttemptConnectionStrategy;
import org.mule.umo.manager.DefaultWorkListener;
import org.mule.util.ClassUtils;
import org.mule.util.queue.EventFilePersistenceStrategy;
import org.mule.util.queue.QueuePersistenceStrategy;

public class MuleConfiguration {
    protected transient Log logger = LogFactory.getLog(this.getClass());
    public static final String DEFAULT_SERVER_URL = "tcp://localhost:60504";
    public static final String USE_MANAGER_PROPERTIES = "org.mule.useManagerProperties";
    public static final String SYNCHRONOUS_PROPERTY = "synchronous";
    public static final String DEFAULT_ENCODING = "UTF-8";
    public static final String DEFAULT_OS_ENCODING = System.getProperty("file.encoding");
    public static final boolean DEFAULT_SYNCHRONOUS = false;
    public static final int DEFAULT_MAX_OUTSTANDING_MESSAGES = 1000;
    public static final int DEFAULT_TIMEOUT = 10000;
    public static final int DEFAULT_TRANSACTION_TIMEOUT = 30000;
    public static final String DEFAULT_WORKING_DIRECTORY = "./.mule";
    public static final String DEFAULT_QUEUE_STORE = "queuestore";
    private boolean synchronous = false;
    private boolean enableMessageEvents = false;
    private String model = null;
    private String encoding = "UTF-8";
    private String osEncoding = DEFAULT_OS_ENCODING;
    private PoolingProfile poolingProfile = new PoolingProfile();
    private ThreadingProfile messageDispatcherThreadingProfile = null;
    private ThreadingProfile messageReceiverThreadingProfile = null;
    private ThreadingProfile componentPoolThreadingProfile = null;
    private QueueProfile queueProfile = new QueueProfile(1000, false);
    private QueuePersistenceStrategy persistenceStrategy = new EventFilePersistenceStrategy();
    private int synchronousEventTimeout = 10000;
    private int transactionTimeout = 30000;
    private boolean remoteSync = false;
    private boolean recoverableMode = false;
    private ThreadingProfile defaultThreadingProfile = new ThreadingProfile();
    private String workingDirectory = "./.mule";
    private String[] configResources = new String[0];
    private String serverUrl = "tcp://localhost:60504";
    private Manifest manifest = null;
    private boolean clientMode = false;
    private boolean embedded = false;
    private String modelType = "default";
    private ConnectionStrategy connectionStrategy = new SingleAttemptConnectionStrategy();
    private WorkListener workListener = new DefaultWorkListener();

    public boolean isSynchronous() {
        return this.synchronous;
    }

    public void setSynchronous(boolean synchronous) {
        this.synchronous = synchronous;
    }

    public String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public ThreadingProfile getMessageDispatcherThreadingProfile() {
        return this.getThreadingProfile(this.messageDispatcherThreadingProfile);
    }

    public void setMessageDispatcherThreadingProfile(ThreadingProfile messageDispatcherThreadingProfile) {
        this.messageDispatcherThreadingProfile = messageDispatcherThreadingProfile;
    }

    public ThreadingProfile getMessageReceiverThreadingProfile() {
        return this.getThreadingProfile(this.messageReceiverThreadingProfile);
    }

    public void setMessageReceiverThreadingProfile(ThreadingProfile messageReceiverThreadingProfile) {
        this.messageReceiverThreadingProfile = messageReceiverThreadingProfile;
    }

    public ThreadingProfile getComponentThreadingProfile() {
        return this.getThreadingProfile(this.componentPoolThreadingProfile);
    }

    public void setComponentThreadingProfile(ThreadingProfile componentPoolThreadingProfile) {
        this.componentPoolThreadingProfile = componentPoolThreadingProfile;
    }

    public ThreadingProfile getDefaultThreadingProfile() {
        return this.getThreadingProfile(this.defaultThreadingProfile);
    }

    public void setDefaultThreadingProfile(ThreadingProfile defaultThreadingProfile) {
        if (defaultThreadingProfile == null) {
            return;
        }
        this.defaultThreadingProfile = defaultThreadingProfile;
    }

    private ThreadingProfile getThreadingProfile(ThreadingProfile profile) {
        if (profile != null) {
            return new ThreadingProfile(profile);
        }
        return new ThreadingProfile(this.defaultThreadingProfile);
    }

    public PoolingProfile getPoolingProfile() {
        return new PoolingProfile(this.poolingProfile);
    }

    public void setPoolingProfile(PoolingProfile poolingProfile) {
        this.poolingProfile = poolingProfile;
    }

    public int getSynchronousEventTimeout() {
        return this.synchronousEventTimeout;
    }

    public void setSynchronousEventTimeout(int synchronousEventTimeout) {
        this.synchronousEventTimeout = synchronousEventTimeout;
    }

    public boolean isRemoteSync() {
        return this.remoteSync;
    }

    public void setRemoteSync(boolean remoteSync) {
        this.remoteSync = remoteSync;
    }

    public QueueProfile getQueueProfile() {
        return new QueueProfile(this.queueProfile);
    }

    public void setQueueProfile(QueueProfile queueProfile) {
        this.queueProfile = queueProfile;
    }

    public boolean isRecoverableMode() {
        return this.recoverableMode;
    }

    public void setRecoverableMode(boolean recoverableMode) {
        this.recoverableMode = recoverableMode;
        if (recoverableMode) {
            this.queueProfile.setPersistent(true);
        }
    }

    public String getWorkingDirectory() {
        return this.workingDirectory;
    }

    public void setWorkingDirectory(String workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    public String[] getConfigResources() {
        return this.configResources;
    }

    public void setConfigResources(String[] configResources) {
        if (configResources != null) {
            int current = this.configResources.length;
            String[] newResources = new String[configResources.length + current];
            System.arraycopy(this.configResources, 0, newResources, 0, current);
            System.arraycopy(configResources, 0, newResources, current, configResources.length);
            this.configResources = newResources;
        } else {
            this.configResources = configResources;
        }
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public void setServerUrl(String serverUrl) {
        if (this.embedded) {
            serverUrl = null;
        } else {
            this.serverUrl = serverUrl;
        }
    }

    public String getProductVersion() {
        return this.getManifestProperty("Implementation-Version");
    }

    public String getVendorName() {
        return this.getManifestProperty("Specification-Vendor");
    }

    public String getProductName() {
        return this.getManifestProperty("Implementation-Title");
    }

    public String getBuildDate() {
        return this.getManifestProperty("Build-Date");
    }

    public Manifest getManifest() {
        if (this.manifest == null) {
            this.manifest = new Manifest();
            InputStream is = ClassUtils.getResourceAsStream("META-INF/Mule.mf", this.getClass());
            if (is == null) {
                is = ClassUtils.getResourceAsStream("meta-inf/Mule.mf", this.getClass());
            }
            if (is != null) {
                try {
                    this.manifest.read(is);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return this.manifest;
    }

    protected String getManifestProperty(String name) {
        return this.getManifest().getMainAttributes().getValue(new Attributes.Name(name));
    }

    public int getTransactionTimeout() {
        return this.transactionTimeout;
    }

    public void setTransactionTimeout(int transactionTimeout) {
        this.transactionTimeout = transactionTimeout;
    }

    public boolean isClientMode() {
        return this.clientMode;
    }

    public void setClientMode(boolean clientMode) {
        this.clientMode = clientMode;
        if (clientMode) {
            this.setServerUrl("");
        }
    }

    public QueuePersistenceStrategy getPersistenceStrategy() {
        return this.persistenceStrategy;
    }

    public void setPersistenceStrategy(QueuePersistenceStrategy persistenceStrategy) {
        this.persistenceStrategy = persistenceStrategy;
    }

    public ConnectionStrategy getConnectionStrategy() {
        try {
            return (ConnectionStrategy)BeanUtils.cloneBean((Object)this.connectionStrategy);
        }
        catch (Exception e) {
            throw new MuleRuntimeException(new Message(145, "Connection Strategy"), (Throwable)e);
        }
    }

    public void setConnectionStrategy(ConnectionStrategy connectionStrategy) {
        this.connectionStrategy = connectionStrategy;
    }

    public boolean isEmbedded() {
        return this.embedded;
    }

    public void setEmbedded(boolean embedded) {
        this.embedded = embedded;
        if (embedded) {
            this.serverUrl = null;
        }
    }

    public String getModelType() {
        return this.modelType;
    }

    public void setModelType(String modelType) {
        this.modelType = modelType;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        if (StringUtils.isEmpty((String)encoding)) {
            this.logger.warn((Object)"Cannot set encoding to null or empty String");
            return;
        }
        this.encoding = encoding;
    }

    public String getOSEncoding() {
        return this.osEncoding;
    }

    public void setOSEncoding(String osEncoding) {
        this.osEncoding = osEncoding;
    }

    public boolean isEnableMessageEvents() {
        return this.enableMessageEvents;
    }

    public void setEnableMessageEvents(boolean enableMessageEvents) {
        this.enableMessageEvents = enableMessageEvents;
    }

    public WorkListener getWorkListener() {
        return this.workListener;
    }

    public void setWorkListener(WorkListener workListener) {
        if (workListener == null) {
            throw new NullPointerException("workListener");
        }
        this.workListener = workListener;
    }
}

