/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.builders;

import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.config.ConfigurationException;
import org.mule.config.ReaderResource;
import org.mule.config.builders.MuleXmlConfigurationBuilder;
import org.mule.config.i18n.Message;
import org.mule.umo.manager.UMOManager;

public class MuleClasspathConfigurationBuilder
extends MuleXmlConfigurationBuilder {
    protected static transient Log logger = LogFactory.getLog((Class)MuleClasspathConfigurationBuilder.class);
    public static final String MULE_CONFIGURATION_RESOURCE = "mule-config.xml";

    public UMOManager configure(String configResources) throws ConfigurationException {
        if (StringUtils.isNotBlank((String)configResources)) {
            if (configResources.indexOf(",") > -1) {
                throw new ConfigurationException(new Message(142));
            }
        } else {
            configResources = MULE_CONFIGURATION_RESOURCE;
        }
        URL url = null;
        ArrayList<ReaderResource> list = new ArrayList<ReaderResource>();
        try {
            Enumeration<URL> e = Thread.currentThread().getContextClassLoader().getResources(configResources);
            while (e.hasMoreElements()) {
                url = e.nextElement();
                logger.info((Object)("Loading resource: " + url.toExternalForm()));
                list.add(new ReaderResource(url.toExternalForm(), new InputStreamReader(url.openStream())));
            }
        }
        catch (Exception e) {
            throw new ConfigurationException(new Message(58, "Config: " + ObjectUtils.toString((Object)url, (String)"null")), (Throwable)e);
        }
        ReaderResource[] resources = new ReaderResource[list.size()];
        resources = list.toArray(resources);
        this.configure(resources);
        return this.manager;
    }
}

