/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.builders;

import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.mule.MuleManager;
import org.mule.config.ConfigurationException;
import org.mule.config.builders.WebappMuleXmlConfigurationBuilder;
import org.mule.umo.manager.UMOManager;

public class MuleXmlBuilderContextListener
implements ServletContextListener {
    public static final String CONFIG_INIT_PARAMETER = "org.mule.config";

    public void contextInitialized(ServletContextEvent event) {
        String config = event.getServletContext().getInitParameter(CONFIG_INIT_PARAMETER);
        if (config == null) {
            config = this.getDefaultConfigResource();
        }
        try {
            this.createManager(config, event.getServletContext());
        }
        catch (ConfigurationException e) {
            event.getServletContext().log(e.getMessage(), (Throwable)e);
        }
    }

    protected UMOManager createManager(String configResource, ServletContext context) throws ConfigurationException {
        WebappMuleXmlConfigurationBuilder builder = new WebappMuleXmlConfigurationBuilder(context);
        return builder.configure(configResource);
    }

    protected String getDefaultConfigResource() {
        return "/WEB-INF/mule-config.xml";
    }

    public void contextDestroyed(ServletContextEvent event) {
        MuleManager.getInstance().dispose();
    }
}

