/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.builders;

import java.beans.ExceptionListener;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.digester.AbstractObjectCreationFactory;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.ObjectCreateRule;
import org.apache.commons.digester.ObjectCreationFactory;
import org.apache.commons.digester.Rule;
import org.apache.commons.digester.SetNextRule;
import org.apache.commons.digester.SetPropertiesRule;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.MuleManager;
import org.mule.config.ConfigurationBuilder;
import org.mule.config.ConfigurationException;
import org.mule.config.MuleConfiguration;
import org.mule.config.PoolingProfile;
import org.mule.config.QueueProfile;
import org.mule.config.ReaderResource;
import org.mule.config.ThreadingProfile;
import org.mule.config.builders.AbstractDigesterConfiguration;
import org.mule.config.builders.ContainerReference;
import org.mule.config.builders.EndpointReference;
import org.mule.config.builders.MuleSetPropertiesRule;
import org.mule.config.builders.ObjectGetOrCreateRule;
import org.mule.config.builders.PlaceholderProcessor;
import org.mule.config.builders.TransformerReference;
import org.mule.config.converters.ConnectorConverter;
import org.mule.config.converters.EndpointConverter;
import org.mule.config.converters.EndpointURIConverter;
import org.mule.config.converters.TransactionFactoryConverter;
import org.mule.config.converters.TransformerConverter;
import org.mule.config.i18n.Message;
import org.mule.config.pool.CommonsPoolFactory;
import org.mule.impl.DefaultLifecycleAdapter;
import org.mule.impl.MuleDescriptor;
import org.mule.impl.MuleTransactionConfig;
import org.mule.impl.endpoint.MuleEndpoint;
import org.mule.impl.model.ModelFactory;
import org.mule.impl.security.MuleSecurityManager;
import org.mule.interceptors.InterceptorStack;
import org.mule.model.DynamicEntryPointResolver;
import org.mule.providers.AbstractConnector;
import org.mule.providers.ConnectionStrategy;
import org.mule.routing.LoggingCatchAllStrategy;
import org.mule.routing.inbound.InboundMessageRouter;
import org.mule.routing.outbound.OutboundMessageRouter;
import org.mule.routing.response.ResponseMessageRouter;
import org.mule.transaction.constraints.BatchConstraint;
import org.mule.umo.UMODescriptor;
import org.mule.umo.UMOEncryptionStrategy;
import org.mule.umo.UMOInterceptor;
import org.mule.umo.UMOInterceptorStack;
import org.mule.umo.UMOTransactionFactory;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.endpoint.UMOEndpointURI;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.manager.ContainerException;
import org.mule.umo.manager.UMOAgent;
import org.mule.umo.manager.UMOContainerContext;
import org.mule.umo.manager.UMOManager;
import org.mule.umo.manager.UMOTransactionManagerFactory;
import org.mule.umo.model.UMOModel;
import org.mule.umo.provider.UMOConnector;
import org.mule.umo.routing.UMOInboundMessageRouter;
import org.mule.umo.routing.UMOOutboundMessageRouter;
import org.mule.umo.routing.UMOOutboundRouter;
import org.mule.umo.routing.UMOResponseMessageRouter;
import org.mule.umo.security.UMOEndpointSecurityFilter;
import org.mule.umo.security.UMOSecurityManager;
import org.mule.umo.security.UMOSecurityProvider;
import org.mule.umo.transformer.UMOTransformer;
import org.mule.util.ClassUtils;
import org.mule.util.StringUtils;
import org.mule.util.queue.EventFilePersistenceStrategy;
import org.xml.sax.Attributes;

public class MuleXmlConfigurationBuilder
extends AbstractDigesterConfiguration
implements ConfigurationBuilder {
    protected static transient Log logger = LogFactory.getLog((Class)MuleXmlConfigurationBuilder.class);
    public static final String DEFAULT_ENTRY_POINT_RESOLVER = DynamicEntryPointResolver.class.getName();
    public static final String DEFAULT_LIFECYCLE_ADAPTER = DefaultLifecycleAdapter.class.getName();
    public static final String DEFAULT_ENDPOINT = MuleEndpoint.class.getName();
    public static final String DEFAULT_TRANSACTION_CONFIG = MuleTransactionConfig.class.getName();
    public static final String DEFAULT_DESCRIPTOR = MuleDescriptor.class.getName();
    public static final String DEFAULT_SECURITY_MANAGER = MuleSecurityManager.class.getName();
    public static final String DEFAULT_OUTBOUND_MESSAGE_ROUTER = OutboundMessageRouter.class.getName();
    public static final String DEFAULT_INBOUND_MESSAGE_ROUTER = InboundMessageRouter.class.getName();
    public static final String DEFAULT_RESPONSE_MESSAGE_ROUTER = ResponseMessageRouter.class.getName();
    public static final String DEFAULT_CATCH_ALL_STRATEGY = LoggingCatchAllStrategy.class.getName();
    public static final String DEFAULT_POOL_FACTORY = CommonsPoolFactory.class.getName();
    public static final String THREADING_PROFILE = ThreadingProfile.class.getName();
    public static final String POOLING_PROFILE = PoolingProfile.class.getName();
    public static final String QUEUE_PROFILE = QueueProfile.class.getName();
    public static final String PERSISTENCE_STRATEGY_INTERFACE = EventFilePersistenceStrategy.class.getName();
    public static final String INBOUND_MESSAGE_ROUTER_INTERFACE = UMOInboundMessageRouter.class.getName();
    public static final String RESPONSE_MESSAGE_ROUTER_INTERFACE = UMOResponseMessageRouter.class.getName();
    public static final String OUTBOUND_MESSAGE_ROUTER_INTERFACE = UMOOutboundMessageRouter.class.getName();
    public static final String TRANSFORMER_INTERFACE = UMOTransformer.class.getName();
    public static final String TRANSACTION_MANAGER_FACTORY_INTERFACE = UMOTransactionManagerFactory.class.getName();
    public static final String SECURITY_PROVIDER_INTERFACE = UMOSecurityProvider.class.getName();
    public static final String ENCRYPTION_STRATEGY_INTERFACE = UMOEncryptionStrategy.class.getName();
    public static final String ENDPOINT_SECURITY_FILTER_INTERFACE = UMOEndpointSecurityFilter.class.getName();
    public static final String AGENT_INTERFACE = UMOAgent.class.getName();
    public static final String TRANSACTION_FACTORY_INTERFACE = UMOTransactionFactory.class.getName();
    public static final String TRANSACTION_CONSTRAINT_INTERFACE = BatchConstraint.class.getName();
    public static final String CONNECTOR_INTERFACE = UMOConnector.class.getName();
    public static final String INTERCEPTOR_INTERFACE = UMOInterceptor.class.getName();
    public static final String ROUTER_INTERFACE = UMOOutboundRouter.class.getName();
    public static final String EXCEPTION_STRATEGY_INTERFACE = ExceptionListener.class.getName();
    public static final String CONNECTION_STRATEGY_INTERFACE = ConnectionStrategy.class.getName();
    protected UMOManager manager;
    private List transformerReferences = new ArrayList();
    private List endpointReferences = new ArrayList();

    public MuleXmlConfigurationBuilder() throws ConfigurationException {
        super(System.getProperty("org.mule.xml.validate", "true").equalsIgnoreCase("true"), System.getProperty("org.mule.xml.dtd", "mule-configuration.dtd"));
        ConvertUtils.register((Converter)new EndpointConverter(), (Class)UMOEndpoint.class);
        ConvertUtils.register((Converter)new TransformerConverter(), (Class)UMOTransformer.class);
        ConvertUtils.register((Converter)new ConnectorConverter(), (Class)UMOConnector.class);
        ConvertUtils.register((Converter)new TransactionFactoryConverter(), (Class)UMOTransactionFactory.class);
        ConvertUtils.register((Converter)new EndpointURIConverter(), (Class)UMOEndpointURI.class);
        String path = this.getRootName();
        this.addManagerRules(this.digester, path);
        this.addServerPropertiesRules(path + "/environment-properties", "addProperties", 0);
        this.addContainerContextRules(path + "/container-context", "setContainerContext", 0);
        this.addMuleConfigurationRules(this.digester, path);
        this.addTransformerRules(this.digester, path);
        this.addSecurityManagerRules(this.digester, path);
        this.addTransactionManagerRules(this.digester, path);
        this.addGlobalEndpointRules(this.digester, path);
        this.addEndpointIdentifierRules(this.digester, path);
        this.addInterceptorStackRules(this.digester, path);
        this.addConnectorRules(this.digester, path);
        this.addAgentRules(this.digester, path);
        this.addModelRules(this.digester, path);
        this.addMuleDescriptorRules(this.digester, path);
    }

    public String getRootName() {
        return "mule-configuration";
    }

    public UMOManager configure(String configResources) throws ConfigurationException {
        try {
            String[] resources = StringUtils.split(configResources, ",");
            MuleManager.getConfiguration().setConfigResources(resources);
            ReaderResource[] readers = new ReaderResource[resources.length];
            for (int i = 0; i < resources.length; ++i) {
                InputStream is = this.loadConfig(resources[i].trim());
                readers[i] = new ReaderResource(resources[i].trim(), new InputStreamReader(is, this.configEncoding));
            }
            return this.configure(readers);
        }
        catch (Exception e) {
            throw new ConfigurationException(e);
        }
    }

    public UMOManager configure(ReaderResource[] configResources) throws ConfigurationException {
        this.manager = (MuleManager)this.process(configResources);
        try {
            this.setContainerProperties();
            this.setTransformers();
            this.setGlobalEndpoints();
            if (System.getProperty("org.mule..start.after.config", "true").equalsIgnoreCase("true")) {
                this.manager.start();
            }
        }
        catch (Exception e) {
            throw new ConfigurationException(new Message(40, "MuleManager"), (Throwable)e);
        }
        return this.manager;
    }

    public boolean isConfigured() {
        return this.manager != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setContainerProperties() throws ContainerException {
        UMOContainerContext ctx = this.manager.getContainerContext();
        try {
            Iterator iterator = this.containerReferences.iterator();
            while (iterator.hasNext()) {
                ContainerReference reference = (ContainerReference)iterator.next();
                reference.resolveReference(ctx);
            }
        }
        finally {
            this.containerReferences.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setTransformers() throws InitialisationException {
        try {
            Iterator iterator = this.transformerReferences.iterator();
            while (iterator.hasNext()) {
                TransformerReference reference = (TransformerReference)iterator.next();
                reference.resolveTransformer();
            }
        }
        finally {
            this.transformerReferences.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setGlobalEndpoints() throws InitialisationException {
        Map endpoints = MuleManager.getInstance().getEndpoints();
        Iterator<Object> iterator = endpoints.values().iterator();
        while (iterator.hasNext()) {
            UMOEndpoint ep = (UMOEndpoint)iterator.next();
            ep.initialise();
            MuleManager.getInstance().unregisterEndpoint(ep.getName());
            MuleManager.getInstance().registerEndpoint(ep);
        }
        try {
            iterator = this.endpointReferences.iterator();
            while (iterator.hasNext()) {
                EndpointReference reference = (EndpointReference)iterator.next();
                reference.resolveEndpoint();
            }
        }
        finally {
            this.endpointReferences.clear();
        }
    }

    protected void addManagerRules(Digester digester, String path) {
        digester.addFactoryCreate(path, (ObjectCreationFactory)new AbstractObjectCreationFactory(){

            public Object createObject(Attributes attributes) throws Exception {
                MuleXmlConfigurationBuilder.this.manager = MuleManager.getInstance();
                return MuleXmlConfigurationBuilder.this.manager;
            }
        });
        digester.addSetProperties(path);
    }

    protected void addMuleConfigurationRules(Digester digester, String path) {
        digester.addSetProperties(path);
        path = path + "/mule-environment-properties";
        digester.addObjectCreate(path, MuleConfiguration.class);
        this.addSetPropertiesRule(path, digester);
        this.addPoolingProfileRules(digester, path);
        this.addQueueProfileRules(digester, path);
        digester.addObjectCreate(path + "/threading-profile", THREADING_PROFILE);
        SetPropertiesRule threadingRule = new SetPropertiesRule();
        threadingRule.addAlias("poolExhaustedAction", "poolExhaustedActionString");
        digester.addRule(path + "/threading-profile", (Rule)threadingRule);
        digester.addRule(path + "/threading-profile", new Rule(){
            private String id;

            public void begin(String s, String s1, Attributes attributes) throws Exception {
                this.id = attributes.getValue("id");
            }

            public void end(String s, String s1) throws Exception {
                ThreadingProfile tp = (ThreadingProfile)this.digester.peek();
                MuleConfiguration cfg = (MuleConfiguration)this.digester.peek(1);
                if ("default".equals(this.id)) {
                    cfg.setDefaultThreadingProfile(tp);
                    cfg.setMessageDispatcherThreadingProfile(tp);
                    cfg.setMessageReceiverThreadingProfile(tp);
                    cfg.setComponentThreadingProfile(tp);
                } else if ("messageReceiver".equals(this.id) || "receiver".equals(this.id)) {
                    cfg.setMessageReceiverThreadingProfile(tp);
                } else if ("messageDispatcher".equals(this.id) || "dispatcher".equals(this.id)) {
                    cfg.setMessageDispatcherThreadingProfile(tp);
                } else if ("component".equals(this.id)) {
                    cfg.setComponentThreadingProfile(tp);
                }
            }
        });
        digester.addObjectCreate(path + "/persistence-strategy", PERSISTENCE_STRATEGY_INTERFACE, "className");
        this.addMulePropertiesRule(path + "/persistence-strategy", digester);
        digester.addSetNext(path + "/persistence-strategy", "setPersistenceStrategy");
        digester.addObjectCreate(path + "/connection-strategy", CONNECTION_STRATEGY_INTERFACE, "className");
        this.addMulePropertiesRule(path + "/connection-strategy", digester);
        digester.addRule(path + "/connection-strategy", (Rule)new SetNextRule("setConnectionStrategy"){

            public void end(String s, String s1) throws Exception {
                super.end(s, s1);
            }
        });
        digester.addRule(path, new Rule(){

            public void end(String s, String s1) throws Exception {
                MuleManager.setConfiguration((MuleConfiguration)this.digester.peek());
            }
        });
    }

    protected void addSecurityManagerRules(Digester digester, String path) throws ConfigurationException {
        path = path + "/security-manager";
        this.addObjectCreateOrGetFromContainer(path, DEFAULT_SECURITY_MANAGER, "className", "ref", false);
        digester.addObjectCreate(path + "/security-provider", SECURITY_PROVIDER_INTERFACE, "className");
        this.addSetPropertiesRule(path + "/security-provider", digester);
        this.addMulePropertiesRule(path + "/security-provider", digester);
        digester.addSetNext(path + "/security-provider", "addProvider");
        digester.addObjectCreate(path + "/encryption-strategy", ENCRYPTION_STRATEGY_INTERFACE, "className");
        this.addSetPropertiesRule(path + "/encryption-strategy", digester);
        this.addMulePropertiesRule(path + "/encryption-strategy", digester);
        digester.addRule(path + "/encryption-strategy", new Rule(){
            private String name;

            public void begin(String endpointName, String endpointName1, Attributes attributes) throws Exception {
                this.name = attributes.getValue("name");
            }

            public void end(String endpointName, String endpointName1) throws Exception {
                UMOEncryptionStrategy s = (UMOEncryptionStrategy)this.digester.peek();
                ((UMOSecurityManager)this.digester.peek(1)).addEncryptionStrategy(this.name, s);
            }
        });
        digester.addSetNext(path, "setSecurityManager");
    }

    protected void addTransformerRules(Digester digester, String path) throws ConfigurationException {
        path = path + "/transformers/transformer";
        this.addObjectCreateOrGetFromContainer(path, TRANSFORMER_INTERFACE, "className", "ref", true);
        this.addSetPropertiesRule(path, digester);
        this.addMulePropertiesRule(path, digester);
        digester.addSetRoot(path, "registerTransformer");
    }

    protected void addGlobalEndpointRules(Digester digester, String path) throws ConfigurationException {
        path = path + "/global-endpoints";
        this.addEndpointRules(digester, path, "registerEndpoint");
    }

    protected void addEndpointIdentifierRules(Digester digester, String path) throws ConfigurationException {
        path = path + "/endpoint-identifiers/endpoint-identifier";
        digester.addRule(path, new Rule(){
            private PlaceholderProcessor processor = new PlaceholderProcessor();

            public void begin(String s, String s1, Attributes attributes) throws Exception {
                attributes = this.processor.processAttributes(attributes, s1);
                String name = attributes.getValue("name");
                String value = attributes.getValue("value");
                ((UMOManager)this.digester.getRoot()).registerEndpointIdentifier(name, value);
            }
        });
    }

    protected void addTransactionManagerRules(Digester digester, String path) throws ConfigurationException {
        path = path + "/transaction-manager";
        this.addObjectCreateOrGetFromContainer(path, TRANSACTION_MANAGER_FACTORY_INTERFACE, "factory", "ref", true);
        this.addMulePropertiesRule(path, digester);
        digester.addSetRoot(path, "setTransactionManager");
        digester.addRule(path, new Rule(){

            public void end(String s, String s1) throws Exception {
                UMOTransactionManagerFactory txFactory = (UMOTransactionManagerFactory)this.digester.pop();
                this.digester.push((Object)txFactory.create());
            }
        });
    }

    protected void addAgentRules(Digester digester, String path) throws ConfigurationException {
        path = path + "/agents/agent";
        this.addObjectCreateOrGetFromContainer(path, AGENT_INTERFACE, "className", "ref", true);
        this.addSetPropertiesRule(path, digester);
        this.addMulePropertiesRule(path, digester);
        digester.addSetRoot(path, "registerAgent");
    }

    protected void addConnectorRules(Digester digester, String path) throws ConfigurationException {
        path = path + "/connector";
        this.addObjectCreateOrGetFromContainer(path, CONNECTOR_INTERFACE, "className", "ref", true);
        this.addSetPropertiesRule(path, digester);
        this.addMulePropertiesRule(path, digester);
        digester.addRule(path + "/threading-profile", new Rule(){
            private String id;

            public void begin(String s, String s1, Attributes attributes) throws Exception {
                MuleConfiguration cfg = MuleManager.getConfiguration();
                this.id = attributes.getValue("id");
                if ("default".equals(this.id)) {
                    this.digester.push((Object)cfg.getDefaultThreadingProfile());
                } else if ("receiver".equals(this.id)) {
                    this.digester.push((Object)cfg.getMessageReceiverThreadingProfile());
                } else if ("dispatcher".equals(this.id)) {
                    this.digester.push((Object)cfg.getMessageDispatcherThreadingProfile());
                }
            }

            public void end(String s, String s1) throws Exception {
                ThreadingProfile tp = (ThreadingProfile)this.digester.pop();
                AbstractConnector cnn = (AbstractConnector)this.digester.peek();
                if ("default".equals(this.id)) {
                    cnn.setReceiverThreadingProfile(tp);
                    cnn.setDispatcherThreadingProfile(tp);
                } else if ("receiver".equals(this.id)) {
                    cnn.setReceiverThreadingProfile(tp);
                } else if ("dispatcher".equals(this.id)) {
                    cnn.setDispatcherThreadingProfile(tp);
                }
            }
        });
        SetPropertiesRule threadingRule = new SetPropertiesRule();
        threadingRule.addAlias("setPoolExhaustedAction", "setPoolExhaustedActionString");
        digester.addRule(path + "/threading-profile", (Rule)threadingRule);
        digester.addObjectCreate(path + "/connection-strategy", CONNECTION_STRATEGY_INTERFACE, "className");
        this.addMulePropertiesRule(path + "/connection-strategy", digester);
        digester.addSetNext(path + "/connection-strategy", "setConnectionStrategy");
        this.addExceptionStrategyRules(digester, path);
        digester.addSetRoot(path, "registerConnector");
    }

    protected void addInterceptorStackRules(Digester digester, String path) throws ConfigurationException {
        path = path + "/interceptor-stack";
        digester.addRule(path + "/interceptor", (Rule)new ObjectCreateRule(INTERCEPTOR_INTERFACE, "className"){

            public void end(String s, String s1) throws Exception {
            }
        });
        digester.addRule(path, new Rule(){

            public void begin(String s, String s1, Attributes attributes) throws Exception {
                this.digester.push((Object)attributes.getValue("name"));
            }

            public void end(String s, String s1) throws Exception {
                ArrayList<Object> list = new ArrayList<Object>();
                Object obj = this.digester.peek();
                while (obj instanceof UMOInterceptor) {
                    list.add(0, this.digester.pop());
                    obj = this.digester.peek();
                }
                InterceptorStack stack = new InterceptorStack();
                stack.setInterceptors(list);
                MuleXmlConfigurationBuilder.this.manager.registerInterceptorStack(this.digester.pop().toString(), stack);
            }
        });
        this.addMulePropertiesRule(path + "/interceptor", digester);
    }

    protected void addModelRules(Digester digester, String path) throws ConfigurationException {
        path = path + "/model";
        digester.addRule(path, new Rule(){

            public void begin(String string, String string1, Attributes attributes) throws Exception {
                UMOModel model = MuleXmlConfigurationBuilder.this.manager.getModel();
                if (model == null) {
                    String modelType = attributes.getValue("type");
                    if (modelType == null) {
                        modelType = MuleManager.getConfiguration().getModelType();
                    }
                    if (modelType.equalsIgnoreCase("custom")) {
                        String className = attributes.getValue("className");
                        if (className == null) {
                            throw new IllegalArgumentException("Cannot use 'custom' model type without setting the 'className' for the model");
                        }
                        model = (UMOModel)ClassUtils.instanciateClass(className, ClassUtils.NO_ARGS, ((Object)((Object)this)).getClass());
                    } else {
                        model = ModelFactory.createModel(modelType);
                    }
                }
                this.digester.push((Object)model);
            }
        });
        this.addSetPropertiesRule(path, digester);
        digester.addSetRoot(path, "setModel");
        digester.addObjectCreate(path + "/entry-point-resolver", DEFAULT_ENTRY_POINT_RESOLVER, "className");
        this.addSetPropertiesRule(path + "/entry-point-resolver", digester);
        digester.addSetNext(path + "/entry-point-resolver", "setEntryPointResolver");
        digester.addObjectCreate(path + "/component-lifecycle-adapter-factory", DEFAULT_LIFECYCLE_ADAPTER, "className");
        this.addSetPropertiesRule(path, digester);
        digester.addSetNext(path + "/component-lifecycle-adapter-factory", "setLifecycleAdapterFactory");
        this.addPoolingProfileRules(digester, path);
        this.addExceptionStrategyRules(digester, path);
        this.addMuleDescriptorRules(digester, path);
    }

    protected void addMuleDescriptorRules(Digester digester, String path) throws ConfigurationException {
        path = path + "/mule-descriptor";
        this.addObjectCreateOrGetFromContainer(path, DEFAULT_DESCRIPTOR, "className", "ref", "container", false);
        this.addSetPropertiesRule(path, digester);
        this.addMessageRouterRules(digester, path, "inbound");
        this.addMessageRouterRules(digester, path, "outbound");
        this.addMessageRouterRules(digester, path, "response");
        this.addThreadingProfileRules(digester, path, "component");
        this.addPoolingProfileRules(digester, path);
        this.addQueueProfileRules(digester, path);
        digester.addRule(path + "/interceptor", new Rule(){

            public void begin(String string, String string1, Attributes attributes) throws Exception {
                String value = attributes.getValue("name");
                if (value == null) {
                    value = attributes.getValue("className");
                }
                UMOManager man = (UMOManager)this.digester.getRoot();
                UMOInterceptorStack interceptorStack = man.lookupInterceptorStack(value);
                MuleDescriptor temp = (MuleDescriptor)this.digester.peek();
                if (interceptorStack != null) {
                    temp.addInterceptor(interceptorStack);
                } else {
                    Class<?> clazz = this.digester.getClassLoader().loadClass(value);
                    Object instance = clazz.newInstance();
                    temp.addInterceptor((UMOInterceptor)instance);
                    this.digester.push(instance);
                }
            }

            public void end(String s, String s1) throws Exception {
                if (this.digester.peek() instanceof UMOInterceptor) {
                    this.digester.pop();
                }
            }
        });
        this.addMulePropertiesRule(path + "/interceptor", digester);
        this.addExceptionStrategyRules(digester, path);
        this.addMulePropertiesRule(path, digester, "setProperties");
        digester.addSetNext(path + "/properties", "setProperties");
        digester.addRule(path, new Rule(){

            public void end(String s, String s1) throws Exception {
                UMODescriptor descriptor = (UMODescriptor)this.digester.peek();
                Object obj = this.digester.peek(1);
                UMOModel model = obj instanceof UMOManager ? ((UMOManager)obj).getModel() : (UMOModel)obj;
                model.registerComponent(descriptor);
            }
        });
    }

    protected void addThreadingProfileRules(Digester digester, String path, final String type) {
        digester.addRule(path + "/threading-profile", new Rule(){

            public void begin(String s, String s1, Attributes attributes) throws Exception {
                MuleConfiguration cfg = MuleManager.getConfiguration();
                if ("component".equals(type)) {
                    this.digester.push((Object)cfg.getComponentThreadingProfile());
                } else if ("messageReceiver".equals(type)) {
                    this.digester.push((Object)cfg.getComponentThreadingProfile());
                } else if ("messageDispatcher".equals(type)) {
                    this.digester.push((Object)cfg.getComponentThreadingProfile());
                } else {
                    this.digester.push((Object)cfg.getDefaultThreadingProfile());
                }
            }

            public void end(String s, String s1) throws Exception {
                this.digester.pop();
            }
        });
        SetPropertiesRule threadingRule = new SetPropertiesRule();
        threadingRule.addAlias("setPoolExhaustedAction", "setPoolExhaustedActionString");
        digester.addRule(path + "/threading-profile", (Rule)threadingRule);
        digester.addSetNext(path + "/threading-profile", "setThreadingProfile");
    }

    protected void addPoolingProfileRules(Digester digester, String path) {
        digester.addRule(path + "/pooling-profile", new Rule(){

            public void begin(String s, String s1, Attributes attributes) throws Exception {
                MuleConfiguration cfg = MuleManager.getConfiguration();
                this.digester.push((Object)cfg.getPoolingProfile());
            }

            public void end(String s, String s1) throws Exception {
                this.digester.pop();
            }
        });
        SetPropertiesRule rule = new SetPropertiesRule();
        rule.addAlias("exhaustedAction", "exhaustedActionString");
        rule.addAlias("initialisationPolicy", "initialisationPolicyString");
        digester.addRule(path + "/pooling-profile", (Rule)rule);
        digester.addSetNext(path + "/pooling-profile", "setPoolingProfile");
    }

    protected void addQueueProfileRules(Digester digester, String path) {
        digester.addObjectCreate(path + "/queue-profile", QUEUE_PROFILE);
        this.addSetPropertiesRule(path + "/queue-profile", digester);
        digester.addSetNext(path + "/queue-profile", "setQueueProfile");
    }

    protected void addMessageRouterRules(Digester digester, String path, String type) throws ConfigurationException {
        String defaultRouter = null;
        String setMethod = null;
        if ("inbound".equals(type)) {
            defaultRouter = DEFAULT_INBOUND_MESSAGE_ROUTER;
            setMethod = "setInboundRouter";
            path = path + "/inbound-router";
            this.addEndpointRules(digester, path, "addEndpoint");
            this.addGlobalReferenceEndpointRules(digester, path, "addEndpoint");
        } else if ("response".equals(type)) {
            defaultRouter = DEFAULT_RESPONSE_MESSAGE_ROUTER;
            setMethod = "setResponseRouter";
            path = path + "/response-router";
            this.addEndpointRules(digester, path, "addEndpoint");
            this.addGlobalReferenceEndpointRules(digester, path, "addEndpoint");
        } else {
            defaultRouter = DEFAULT_OUTBOUND_MESSAGE_ROUTER;
            setMethod = "setOutboundRouter";
            path = path + "/outbound-router";
        }
        digester.addObjectCreate(path, defaultRouter, "className");
        this.addSetPropertiesRule(path, digester);
        digester.addObjectCreate(path + "/catch-all-strategy", DEFAULT_CATCH_ALL_STRATEGY, "className");
        this.addSetPropertiesRule(path + "/catch-all-strategy", digester);
        this.addEndpointRules(digester, path + "/catch-all-strategy", "setEndpoint");
        this.addGlobalReferenceEndpointRules(digester, path + "/catch-all-strategy", "setEndpoint");
        this.addMulePropertiesRule(path + "/catch-all-strategy", digester);
        digester.addSetNext(path + "/catch-all-strategy", "setCatchAllStrategy");
        this.addRouterRules(digester, path, type);
        digester.addSetNext(path, setMethod);
    }

    protected void addRouterRules(Digester digester, String path, String type) throws ConfigurationException {
        path = path + "/router";
        if ("inbound".equals(type)) {
            digester.addObjectCreate(path, INBOUND_MESSAGE_ROUTER_INTERFACE, "className");
        } else if ("response".equals(type)) {
            digester.addObjectCreate(path, RESPONSE_MESSAGE_ROUTER_INTERFACE, "className");
        } else {
            digester.addObjectCreate(path, OUTBOUND_MESSAGE_ROUTER_INTERFACE, "className");
        }
        this.addSetPropertiesRule(path, digester, new String[]{"enableCorrelation"}, new String[]{"enableCorrelationAsString"});
        this.addMulePropertiesRule(path, digester);
        if ("outbound".equals(type)) {
            this.addEndpointRules(digester, path, "addEndpoint");
            this.addReplyToRules(digester, path);
            this.addGlobalReferenceEndpointRules(digester, path, "addEndpoint");
            this.addTransactionConfigRules(path, digester);
        }
        this.addFilterRules(digester, path);
        digester.addSetNext(path, "addRouter");
    }

    protected void addReplyToRules(Digester digester, String path) throws ConfigurationException {
        path = path + "/reply-to";
        digester.addRule(path, new Rule(){

            public void begin(String s, String s1, Attributes attributes) throws Exception {
                String replyTo = attributes.getValue("address");
                ((UMOOutboundRouter)this.digester.peek()).setReplyTo(replyTo);
            }
        });
    }

    protected void addEndpointRules(Digester digester, String path, String method) throws ConfigurationException {
        path = path + "/endpoint";
        this.addObjectCreateOrGetFromContainer(path, DEFAULT_ENDPOINT, "className", "ref", false);
        this.addCommonEndpointRules(digester, path, method);
    }

    protected void addGlobalReferenceEndpointRules(Digester digester, String path, final String method) throws ConfigurationException {
        path = path + "/global-endpoint";
        digester.addRule(path, new Rule(){

            public void begin(String s, String s1, Attributes attributes) throws Exception {
                String name = attributes.getValue("name");
                String address = attributes.getValue("address");
                String trans = attributes.getValue("transformers");
                String responseTrans = attributes.getValue("responseTransformers");
                String createConnector = attributes.getValue("createConnector");
                EndpointReference ref = new EndpointReference(method, name, address, trans, responseTrans, createConnector, this.digester.peek());
                this.digester.push((Object)ref);
            }

            public void end(String endpointName, String endpointName1) throws Exception {
                MuleXmlConfigurationBuilder.this.endpointReferences.add(this.digester.pop());
            }
        });
        this.addCommonEndpointRules(digester, path, null);
    }

    protected void addCommonEndpointRules(Digester digester, String path, String method) throws ConfigurationException {
        this.addSetPropertiesRule(path, digester, new String[]{"address", "transformers", "responseTransformers", "createConnector"}, new String[]{"endpointURI", "transformer", "responseTransformer", "createConnectorAsString"});
        this.addMulePropertiesRule(path, digester, "setProperties");
        this.addTransactionConfigRules(path, digester);
        this.addFilterRules(digester, path);
        if (method != null) {
            digester.addSetNext(path, method);
        }
        digester.addObjectCreate(path + "/security-filter", ENDPOINT_SECURITY_FILTER_INTERFACE, "className");
        this.addMulePropertiesRule(path + "/security-filter", digester);
        digester.addSetNext(path + "/security-filter", "setSecurityFilter");
    }

    protected void addTransactionConfigRules(String path, Digester digester) {
        digester.addObjectCreate(path + "/transaction", DEFAULT_TRANSACTION_CONFIG);
        this.addSetPropertiesRule(path + "/transaction", digester, new String[]{"action"}, new String[]{"actionAsString"});
        digester.addObjectCreate(path + "/transaction/constraint", TRANSACTION_CONSTRAINT_INTERFACE, "className");
        this.addSetPropertiesRule(path + "/transaction/constraint", digester);
        digester.addSetNext(path + "/transaction/constraint", "setConstraint");
        digester.addSetNext(path + "/transaction", "setTransactionConfig");
    }

    protected void addExceptionStrategyRules(Digester digester, String path) throws ConfigurationException {
        path = path + "/exception-strategy";
        digester.addObjectCreate(path, EXCEPTION_STRATEGY_INTERFACE, "className");
        this.addMulePropertiesRule(path, digester);
        this.addEndpointRules(digester, path, "addEndpoint");
        this.addGlobalReferenceEndpointRules(digester, path, "addEndpoint");
        digester.addSetNext(path, "setExceptionListener");
    }

    protected void addSetPropertiesRule(String path, Digester digester, String[] s1, String[] s2) {
        digester.addRule(path, (Rule)new ExtendedMuleSetPropertiesRule(s1, s2));
    }

    protected void addSetPropertiesRule(String path, Digester digester) {
        digester.addRule(path, (Rule)new ExtendedMuleSetPropertiesRule());
    }

    private void addTransformerReference(String propName, String transName, Object object) {
        this.transformerReferences.add(new TransformerReference(propName, transName, object));
    }

    private void addEndpointReference(String propName, String endpointName, Object object) {
        this.endpointReferences.add(new EndpointReference(propName, endpointName, null, null, null, null, object));
    }

    protected void addObjectCreateOrGetFromContainer(String path, String defaultImpl, String classAttrib, String refAttrib, boolean classRefRequired) {
        this.digester.addRule(path, (Rule)new ObjectGetOrCreateRule(defaultImpl, classAttrib, refAttrib, classAttrib, classRefRequired, "getContainerContext"));
    }

    protected void addObjectCreateOrGetFromContainer(String path, String defaultImpl, String classAttrib, String refAttrib, String containerAttrib, boolean classRefRequired) {
        this.digester.addRule(path, (Rule)new ObjectGetOrCreateRule(defaultImpl, classAttrib, refAttrib, containerAttrib, classAttrib, classRefRequired, "getContainerContext"));
    }

    public class ExtendedMuleSetPropertiesRule
    extends MuleSetPropertiesRule {
        public ExtendedMuleSetPropertiesRule() {
        }

        public ExtendedMuleSetPropertiesRule(PlaceholderProcessor processor) {
            super(processor);
        }

        public ExtendedMuleSetPropertiesRule(String[] strings, String[] strings1) {
            super(strings, strings1);
        }

        public ExtendedMuleSetPropertiesRule(String[] strings, String[] strings1, PlaceholderProcessor processor) {
            super(strings, strings1, processor);
        }

        public void begin(String s1, String s2, Attributes attributes) throws Exception {
            Object o;
            String endpoint;
            String transformerNames = (attributes = this.processor.processAttributes(attributes, s2)).getValue("transformer");
            if (transformerNames != null) {
                MuleXmlConfigurationBuilder.this.addTransformerReference("transformer", transformerNames, this.digester.peek());
            }
            if ((transformerNames = attributes.getValue("transformers")) != null) {
                MuleXmlConfigurationBuilder.this.addTransformerReference("transformer", transformerNames, this.digester.peek());
            }
            if ((transformerNames = attributes.getValue("responseTransformers")) != null) {
                MuleXmlConfigurationBuilder.this.addTransformerReference("responseTransformer", transformerNames, this.digester.peek());
            }
            if ((transformerNames = attributes.getValue("inboundTransformer")) != null) {
                MuleXmlConfigurationBuilder.this.addTransformerReference("inboundTransformer", transformerNames, this.digester.peek());
            }
            if ((transformerNames = attributes.getValue("outboundTransformer")) != null) {
                MuleXmlConfigurationBuilder.this.addTransformerReference("outboundTransformer", transformerNames, this.digester.peek());
            }
            if ((transformerNames = attributes.getValue("responseTransformer")) != null) {
                MuleXmlConfigurationBuilder.this.addTransformerReference("responseTransformer", transformerNames, this.digester.peek());
            }
            if ((endpoint = attributes.getValue("inboundEndpoint")) != null && (o = MuleXmlConfigurationBuilder.this.manager.getEndpoints().get(endpoint)) != null) {
                MuleXmlConfigurationBuilder.this.addEndpointReference("setInboundEndpoint", endpoint, this.digester.peek());
            }
            if ((endpoint = attributes.getValue("outboundEndpoint")) != null && (o = MuleXmlConfigurationBuilder.this.manager.getEndpoints().get(endpoint)) != null) {
                MuleXmlConfigurationBuilder.this.addEndpointReference("setOutboundEndpoint", endpoint, this.digester.peek());
            }
            super.begin(attributes);
        }
    }
}

